/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.idmapping;

import java.util.function.Function;
import org.goplanit.converter.idmapping.IdMapperFunctionFactory;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.PlanitComponentIdMapper;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class ZoningIdMapper
extends PlanitComponentIdMapper {
    public ZoningIdMapper(IdMapperType mappingType) {
        super(mappingType);
        this.add(Zone.class, IdMapperFunctionFactory.createZoneIdMappingFunction(mappingType));
        this.add(Connectoid.class, IdMapperFunctionFactory.createConnectoidIdMappingFunction(mappingType));
        this.add(TransferZoneGroup.class, IdMapperFunctionFactory.createTransferZoneGroupIdMappingFunction(mappingType));
        this.add(Zoning.class, IdMapperFunctionFactory.createZoningIdMappingFunction(mappingType));
    }

    public Function<? super Zone, String> getZoneIdMapper() {
        return this.get(Zone.class);
    }

    public Function<Connectoid, String> getConnectoidIdMapper() {
        return this.get(Connectoid.class);
    }

    public Function<TransferZoneGroup, String> getTransferZoneGroupIdMapper() {
        return this.get(TransferZoneGroup.class);
    }

    public Function<Zoning, String> getZoningIdMapper() {
        return this.get(Zoning.class);
    }
}

