/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.idmapping;

import java.util.function.Function;
import org.goplanit.converter.idmapping.IdMapperFunctionFactory;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.PlanitComponentIdMapper;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;

public class ServiceNetworkIdMapper
extends PlanitComponentIdMapper {
    public ServiceNetworkIdMapper(IdMapperType type) {
        super(type);
        this.add(Vertex.class, IdMapperFunctionFactory.createVertexIdMappingFunction(type));
        this.add(ServiceLeg.class, IdMapperFunctionFactory.createServiceLegIdMappingFunction(type));
        this.add(ServiceLegSegment.class, IdMapperFunctionFactory.createServiceLegSegmentIdMappingFunction(type));
        this.add(ServiceNetwork.class, IdMapperFunctionFactory.createServiceNetworkIdMappingFunction(type));
        this.add(ServiceNetworkLayer.class, IdMapperFunctionFactory.createServiceNetworkLayerIdMappingFunction(type));
    }

    public Function<Vertex, String> getServiceNodeIdMapper() {
        return this.get(Vertex.class);
    }

    public Function<ServiceLeg, String> getServiceLegIdMapper() {
        return this.get(ServiceLeg.class);
    }

    public Function<ServiceLegSegment, String> getServiceLegSegmentIdMapper() {
        return this.get(ServiceLegSegment.class);
    }

    public Function<ServiceNetwork, String> getServiceNetworkIdMapper() {
        return this.get(ServiceNetwork.class);
    }

    public Function<ServiceNetworkLayer, String> getServiceNetworkLayerIdMapper() {
        return this.get(ServiceNetworkLayer.class);
    }
}

