/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.idmapping;

import org.goplanit.converter.idmapping.DemandsIdMapper;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.NetworkIdMapper;
import org.goplanit.converter.idmapping.PlanitComponentIdMapper;
import org.goplanit.converter.idmapping.RoutedServicesIdMapper;
import org.goplanit.converter.idmapping.ServiceNetworkIdMapper;
import org.goplanit.converter.idmapping.VirtualNetworkIdMapper;
import org.goplanit.converter.idmapping.ZoningIdMapper;
import org.goplanit.utils.exceptions.PlanItRunTimeException;

public class PlanitComponentIdMappers {
    private NetworkIdMapper networkIdMappers;
    private ZoningIdMapper zoningIdMappers;
    private VirtualNetworkIdMapper virtualNetworkIdMapper;
    private ServiceNetworkIdMapper serviceNetworkIdMapper;
    private RoutedServicesIdMapper routedServicesIdMapper;
    private DemandsIdMapper demandsIdMapperIdMapper;

    public void setDedicatedIdMapper(PlanitComponentIdMapper componentIdMapper) {
        if (componentIdMapper instanceof NetworkIdMapper) {
            this.networkIdMappers = (NetworkIdMapper)componentIdMapper;
        } else if (componentIdMapper instanceof ZoningIdMapper) {
            this.zoningIdMappers = (ZoningIdMapper)componentIdMapper;
        } else if (componentIdMapper instanceof DemandsIdMapper) {
            this.demandsIdMapperIdMapper = (DemandsIdMapper)componentIdMapper;
        } else if (componentIdMapper instanceof ServiceNetworkIdMapper) {
            this.serviceNetworkIdMapper = (ServiceNetworkIdMapper)componentIdMapper;
        } else if (componentIdMapper instanceof RoutedServicesIdMapper) {
            this.routedServicesIdMapper = (RoutedServicesIdMapper)componentIdMapper;
        } else if (componentIdMapper instanceof VirtualNetworkIdMapper) {
            this.virtualNetworkIdMapper = (VirtualNetworkIdMapper)componentIdMapper;
        } else {
            throw new PlanItRunTimeException("Unsupported id mapper provided as override");
        }
    }

    public void populateMissingIdMappers(IdMapperType idMapperType) {
        if (this.networkIdMappers == null) {
            this.networkIdMappers = new NetworkIdMapper(idMapperType);
        }
        if (this.zoningIdMappers == null) {
            this.zoningIdMappers = new ZoningIdMapper(idMapperType);
        }
        if (this.serviceNetworkIdMapper == null) {
            this.serviceNetworkIdMapper = new ServiceNetworkIdMapper(idMapperType);
        }
        if (this.routedServicesIdMapper == null) {
            this.routedServicesIdMapper = new RoutedServicesIdMapper(idMapperType);
        }
        if (this.demandsIdMapperIdMapper == null) {
            this.demandsIdMapperIdMapper = new DemandsIdMapper(idMapperType);
        }
        if (this.virtualNetworkIdMapper == null) {
            this.virtualNetworkIdMapper = new VirtualNetworkIdMapper(idMapperType);
        }
    }

    public NetworkIdMapper getNetworkIdMappers() {
        return this.networkIdMappers;
    }

    public ZoningIdMapper getZoningIdMappers() {
        return this.zoningIdMappers;
    }

    public ServiceNetworkIdMapper getServiceNetworkIdMapper() {
        return this.serviceNetworkIdMapper;
    }

    public RoutedServicesIdMapper getRoutedServicesIdMapper() {
        return this.routedServicesIdMapper;
    }

    public DemandsIdMapper getDemandsIdMapperIdMapper() {
        return this.demandsIdMapperIdMapper;
    }

    public VirtualNetworkIdMapper getVirtualNetworkIdMapper() {
        return this.virtualNetworkIdMapper;
    }
}

