/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.idmapping;

import java.util.function.Function;
import org.goplanit.converter.idmapping.IdMapperFunctionFactory;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.PlanitComponentIdMapper;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.userclass.TravellerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.time.TimePeriod;

public class NetworkIdMapper
extends PlanitComponentIdMapper {
    public NetworkIdMapper(IdMapperType type) {
        super(type);
        this.add(Link.class, IdMapperFunctionFactory.createLinkIdMappingFunction(type));
        this.add(Link.class, IdMapperFunctionFactory.createLinkIdMappingFunction(type));
        this.add(MacroscopicLinkSegmentType.class, IdMapperFunctionFactory.createLinkSegmentTypeIdMappingFunction(type));
        this.add(MacroscopicLinkSegment.class, IdMapperFunctionFactory.createLinkSegmentIdMappingFunction(type));
        this.add(TimePeriod.class, IdMapperFunctionFactory.createTimePeriodIdMappingFunction(type));
        this.add(TravellerType.class, IdMapperFunctionFactory.createTravellerTypeIdMappingFunction(type));
        this.add(UserClass.class, IdMapperFunctionFactory.createUserClassIdMappingFunction(type));
        this.add(Vertex.class, IdMapperFunctionFactory.createVertexIdMappingFunction(type));
        this.add(MacroscopicNetworkLayer.class, IdMapperFunctionFactory.createMacroscopicNetworkLayerIdMappingFunction(type));
        this.add(MacroscopicNetwork.class, IdMapperFunctionFactory.createMacroscopicNetworkIdMappingFunction(type));
    }

    public Function<Vertex, String> getVertexIdMapper() {
        return this.get(Vertex.class);
    }

    public Function<Link, String> getLinkIdMapper() {
        return this.get(Link.class);
    }

    public Function<MacroscopicLinkSegment, String> getLinkSegmentIdMapper() {
        return this.get(MacroscopicLinkSegment.class);
    }

    public Function<MacroscopicLinkSegmentType, String> getLinkSegmentTypeIdMapper() {
        return this.get(MacroscopicLinkSegmentType.class);
    }

    public Function<TravellerType, String> getTravellerTypeIdMapper() {
        return this.get(TravellerType.class);
    }

    public Function<TimePeriod, String> getTimePeriodIdMapper() {
        return this.get(TimePeriod.class);
    }

    public Function<UserClass, String> getUserClassIdMapper() {
        return this.get(UserClass.class);
    }

    public Function<MacroscopicNetworkLayer, String> getNetworkLayerIdMapper() {
        return this.get(MacroscopicNetworkLayer.class);
    }

    public Function<MacroscopicNetwork, String> getNetworkIdMapper() {
        return this.get(MacroscopicNetwork.class);
    }
}

