/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.idmapping;

import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.userclass.TravellerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedTrip;
import org.goplanit.utils.service.routed.RoutedTripDeparture;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class IdMapperFunctionFactory {
    private static final Logger LOGGER = Logger.getLogger(IdMapperFunctionFactory.class.getCanonicalName());

    protected static <T extends ExternalIdAble> Function<T, String> createIdMappingFunction(Class<T> clazz, IdMapperType idMapper) {
        switch (idMapper) {
            case ID: {
                return instance -> instance != null ? Long.toString(instance.getId()) : null;
            }
            case EXTERNAL_ID: {
                return instance -> instance != null ? instance.getExternalId() : null;
            }
            case XML: {
                return instance -> instance != null ? instance.getXmlId() : null;
            }
        }
        throw new PlanItRunTimeException(String.format("unknown id mapping type found for %s %s", new Object[]{clazz.getName(), idMapper}));
    }

    public static Function<Vertex, String> createVertexIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Vertex.class, idMapper);
    }

    public static Function<Link, String> createLinkIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Link.class, idMapper);
    }

    public static Function<MacroscopicLinkSegmentType, String> createLinkSegmentTypeIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegmentType.class, idMapper);
    }

    public static Function<MacroscopicLinkSegment, String> createLinkSegmentIdMappingFunction(IdMapperType idMapper) {
        switch (idMapper) {
            case EXTERNAL_ID: {
                return macroscopicLinkSegment -> {
                    if (macroscopicLinkSegment.getExternalId() != null) {
                        return String.format("%s", macroscopicLinkSegment.getExternalId());
                    }
                    if (macroscopicLinkSegment.getParentLink() != null && macroscopicLinkSegment.getParentLink().getExternalId() != null) {
                        return String.format("%s_%s", macroscopicLinkSegment.getParentLink().getExternalId(), macroscopicLinkSegment.isDirectionAb() ? "ab" : "ba");
                    }
                    LOGGER.severe(String.format("unable to map id for link, PLANit link segment external id not available or parent link missing (id:%d)", macroscopicLinkSegment.getId()));
                    return "-1";
                };
            }
        }
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicLinkSegment.class, idMapper);
    }

    public static Function<Mode, String> createModeIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Mode.class, idMapper);
    }

    public static Function<Connectoid, String> createConnectoidIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Connectoid.class, idMapper);
    }

    public static Function<Zone, String> createZoneIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Zone.class, idMapper);
    }

    public static Function<TransferZoneGroup, String> createTransferZoneGroupIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(TransferZoneGroup.class, idMapper);
    }

    public static Function<TravellerType, String> createTravellerTypeIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(TravellerType.class, idMapper);
    }

    public static Function<TimePeriod, String> createTimePeriodIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(TimePeriod.class, idMapper);
    }

    public static Function<UserClass, String> createUserClassIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(UserClass.class, idMapper);
    }

    public static Function<ServiceLeg, String> createServiceLegIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ServiceLeg.class, idMapper);
    }

    public static Function<ServiceLegSegment, String> createServiceLegSegmentIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ServiceLegSegment.class, idMapper);
    }

    public static Function<RoutedTrip, String> createRoutedTripIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(RoutedTrip.class, idMapper);
    }

    public static Function<RoutedTripDeparture, String> createRoutedTripDepartureIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(RoutedTripDeparture.class, idMapper);
    }

    public static Function<RoutedService, String> createRoutedServiceIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(RoutedService.class, idMapper);
    }

    public static Function<RoutedTripSchedule, String> createRoutedTripScheduleIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(RoutedTripSchedule.class, idMapper);
    }

    public static Function<MacroscopicNetworkLayer, String> createMacroscopicNetworkLayerIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicNetworkLayer.class, idMapper);
    }

    public static Function<MacroscopicNetwork, String> createMacroscopicNetworkIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(MacroscopicNetwork.class, idMapper);
    }

    public static Function<ServiceNetwork, String> createServiceNetworkIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ServiceNetwork.class, idMapper);
    }

    public static Function<RoutedServicesLayer, String> createRoutedServiceLayerIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(RoutedServicesLayer.class, idMapper);
    }

    public static Function<ServiceNetworkLayer, String> createServiceNetworkLayerIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ServiceNetworkLayer.class, idMapper);
    }

    public static Function<Zoning, String> createZoningIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(Zoning.class, idMapper);
    }

    public static Function<? extends ExternalIdAble, String> createConnectoidEdgeIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ConnectoidEdge.class, idMapper);
    }

    public static Function<? extends ExternalIdAble, String> createConnectoidSegmentIdMappingFunction(IdMapperType idMapper) {
        return IdMapperFunctionFactory.createIdMappingFunction(ConnectoidSegment.class, idMapper);
    }
}

