/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterBase;
import org.goplanit.converter.PairConverterReader;
import org.goplanit.converter.PairConverterWriter;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;

public abstract class PairConverter<T, U>
extends ConverterBase {
    private static final Logger LOGGER = Logger.getLogger(PairConverter.class.getCanonicalName());

    protected PairConverter(PairConverterReader<T, U> reader, PairConverterWriter<T, U> writer) {
        super(reader, writer);
    }

    @Override
    public void convert() throws PlanItException {
        PairConverterReader reader = (PairConverterReader)this.getReader();
        LOGGER.info(String.format("****************** [START] CONVERTER: READ %s [START] ********************", reader.getTypeDescription()));
        Pair multiResult = reader.read();
        reader.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: READ %s [END]   ********************", reader.getTypeDescription()));
        PairConverterWriter writer = (PairConverterWriter)this.getWriter();
        LOGGER.info(String.format("****************** [START] CONVERTER: WRITE %s [START] ********************", writer.getTypeDescription()));
        writer.write(multiResult.first(), multiResult.second());
        writer.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: WRITE %s [END]   ********************", writer.getTypeDescription()));
    }
}

