/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterWriterSettings;
import org.goplanit.utils.misc.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FileBasedConverterWriterSettings
implements ConverterWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(FileBasedConverterWriterSettings.class.getCanonicalName());
    private String outputDirectory = null;
    private String countryName = DEFAULT_COUNTRY;
    protected CoordinateReferenceSystem destinationCoordinateReferenceSystem = null;
    public static String DEFAULT_COUNTRY = "global";

    protected boolean validate() {
        if (StringUtils.isNullOrBlank((String)this.outputDirectory)) {
            LOGGER.severe("PLANit output directory is not provided, unable to continue");
            return false;
        }
        return true;
    }

    protected FileBasedConverterWriterSettings() {
    }

    protected FileBasedConverterWriterSettings(String outputPathDirectory) {
        this.outputDirectory = outputPathDirectory;
    }

    protected FileBasedConverterWriterSettings(String outputPathDirectory, String countryName) {
        this.outputDirectory = outputPathDirectory;
        this.setCountry(countryName);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getCountry() {
        return this.countryName;
    }

    public void setCountry(String countryName) {
        this.countryName = countryName;
    }

    public void logSettings() {
        if (this.getDestinationCoordinateReferenceSystem() != null) {
            LOGGER.info(String.format("Destination Coordinate Reference System set to: %s", this.getDestinationCoordinateReferenceSystem().getName()));
        }
    }

    public CoordinateReferenceSystem getDestinationCoordinateReferenceSystem() {
        return this.destinationCoordinateReferenceSystem;
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.destinationCoordinateReferenceSystem = destinationCoordinateReferenceSystem;
    }

    @Override
    public void reset() {
        this.outputDirectory = null;
        this.destinationCoordinateReferenceSystem = null;
        this.countryName = DEFAULT_COUNTRY;
    }
}

