/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.goplanit.converter.BaseWriterImpl;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.utils.epsg.EpsgCodesByCountry;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public abstract class CrsWriterImpl<T>
extends BaseWriterImpl<T> {
    private static final Logger LOGGER = Logger.getLogger(CrsWriterImpl.class.getCanonicalName());
    private PlanitJtsCrsUtils geoUtils;
    CoordinateReferenceSystem destinationCrs;
    private MathTransform destinationCrsTransformer = null;

    protected Coordinate createTransformedCoordinate(Coordinate coordinate) {
        try {
            if (this.getDestinationCrsTransformer() != null) {
                return JTS.transform((Coordinate)coordinate, null, (MathTransform)this.getDestinationCrsTransformer());
            }
            return coordinate;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to transform coordinate from %s ", coordinate.toString()));
            return null;
        }
    }

    protected Coordinate[] getTransformedCoordinates(Coordinate[] coordinates) {
        Coordinate[] transformedCoordinates = null;
        try {
            if (this.getDestinationCrsTransformer() != null) {
                transformedCoordinates = new Coordinate[coordinates.length];
                for (int index = 0; index < coordinates.length; ++index) {
                    transformedCoordinates[index] = JTS.transform((Coordinate)coordinates[index], null, (MathTransform)this.getDestinationCrsTransformer());
                }
            } else {
                transformedCoordinates = coordinates;
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("unable to transform coordinates from %s ", coordinates.toString()));
        }
        return transformedCoordinates;
    }

    private CoordinateReferenceSystem identifyDestinationCoordinateReferenceSystem(CoordinateReferenceSystem overwriteCrs, String countryName, CoordinateReferenceSystem fallBackCrs) {
        CoordinateReferenceSystem destinationCrs = overwriteCrs;
        if (destinationCrs == null && countryName != null) {
            destinationCrs = PlanitCrsUtils.createCoordinateReferenceSystem((String)EpsgCodesByCountry.getEpsg((String)countryName));
        }
        if (destinationCrs == null) {
            destinationCrs = fallBackCrs;
        }
        PlanItRunTimeException.throwIfNull((Object)destinationCrs, (String)"Destination Coordinate Reference System is null, this is not allowed");
        return destinationCrs;
    }

    private void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCrs) {
        this.destinationCrs = destinationCrs;
    }

    protected CoordinateReferenceSystem getDestinationCoordinateReferenceSystem() {
        return this.destinationCrs;
    }

    protected static String extractSrsName(CoordinateReferenceSystem crs) {
        String srsName = "";
        if ("EPSG".equals(crs.getName().getCodeSpace())) {
            Integer epsgCode = null;
            try {
                epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                if (epsgCode == null) {
                    epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                srsName = String.format("EPSG:%s", epsgCode.toString());
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
                throw new PlanItRunTimeException("Unable to extract epsg code from destination crs %s", new Object[]{crs.getName()});
            }
        } else if (!crs.equals(PlanitJtsCrsUtils.CARTESIANCRS)) {
            throw new PlanItRunTimeException("Unable to extract epsg code from destination crs %s", new Object[]{crs.getName()});
        }
        return srsName;
    }

    protected void prepareCoordinateReferenceSystem(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem userDefinedDestinationCrs, String destinationCountry) {
        PlanItRunTimeException.throwIfNull((Object)sourceCrs, (String)"Source Crs null, this is not allowed");
        this.geoUtils = new PlanitJtsCrsUtils(sourceCrs);
        CoordinateReferenceSystem identifiedDestinationCrs = this.identifyDestinationCoordinateReferenceSystem(userDefinedDestinationCrs, destinationCountry, sourceCrs);
        PlanItRunTimeException.throwIfNull((Object)identifiedDestinationCrs, (String)"Destination Coordinate Reference System is null, this is not allowed");
        if (!identifiedDestinationCrs.equals(sourceCrs)) {
            this.destinationCrsTransformer = PlanitJtsUtils.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)identifiedDestinationCrs);
        }
        this.setDestinationCoordinateReferenceSystem(identifiedDestinationCrs);
    }

    protected MathTransform getDestinationCrsTransformer() {
        return this.destinationCrsTransformer;
    }

    protected PlanitJtsCrsUtils getGeoUtils() {
        return this.geoUtils;
    }

    protected CrsWriterImpl(IdMapperType idMapperType) {
        super(idMapperType);
    }
}

