/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterBase;
import org.goplanit.converter.ConverterReader;
import org.goplanit.converter.ConverterWriter;
import org.goplanit.utils.exceptions.PlanItException;

public abstract class Converter<T>
extends ConverterBase {
    private static final Logger LOGGER = Logger.getLogger(Converter.class.getCanonicalName());

    protected Converter(ConverterReader<T> reader, ConverterWriter<T> writer) {
        super(reader, writer);
    }

    protected T read() {
        ConverterReader reader = (ConverterReader)this.getReader();
        LOGGER.info(String.format("****************** [START] CONVERTER: READ %s [START] ********************", reader.getTypeDescription()));
        Object entity = reader.read();
        reader.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: READ %s [END]   ********************", reader.getTypeDescription()));
        return entity;
    }

    protected void write(T readEntity) throws PlanItException {
        ConverterWriter writer = (ConverterWriter)this.getWriter();
        LOGGER.info(String.format("****************** [START] CONVERTER: WRITE %s [START] ********************", writer.getTypeDescription()));
        writer.write(readEntity);
        writer.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: WRITE %s [END]   ********************", writer.getTypeDescription()));
    }

    @Override
    public void convert() throws PlanItException {
        this.write(this.read());
    }
}

