/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.function.Function;
import org.goplanit.converter.ConverterReader;
import org.goplanit.utils.misc.CustomIndexTracker;
import org.goplanit.utils.wrapper.MapWrapper;

public abstract class BaseReaderImpl<T>
implements ConverterReader<T> {
    protected final CustomIndexTracker sourceIdTracker = new CustomIndexTracker();

    protected <V> void registerBySourceId(V obj) {
        this.registerBySourceId(obj.getClass(), obj);
    }

    protected <U, V> void registerBySourceId(Class<U> theClazz, V obj) {
        this.sourceIdTracker.register(theClazz, obj);
    }

    protected <K, V> void initialiseSourceIdMap(Class<V> clazz, Function<V, K> valueToKey) {
        this.sourceIdTracker.initialiseEntityContainer(clazz, valueToKey);
    }

    protected <K, V> void initialiseSourceIdMap(Class<V> clazz, Function<V, K> valueToKey, Iterable<V> addToSourceIdMap) {
        this.sourceIdTracker.initialiseEntityContainer(clazz, valueToKey, addToSourceIdMap);
    }

    protected <V> MapWrapper<?, V> getSourceIdContainer(Class<V> clazz) {
        return this.sourceIdTracker.getEntityContainer(clazz);
    }

    protected <V, K> V getBySourceId(Class<V> clazz, K key) {
        return (V)this.sourceIdTracker.get(clazz, key);
    }

    protected BaseReaderImpl() {
    }

    @Override
    public void reset() {
        this.sourceIdTracker.reset();
    }
}

