/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.component;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.event.PlanitComponentEvent;
import org.goplanit.component.event.PlanitComponentEventType;
import org.goplanit.component.event.PlanitComponentListener;
import org.goplanit.component.event.PopulateComponentEvent;
import org.goplanit.component.event.PopulateDemandsEvent;
import org.goplanit.component.event.PopulateFundamentalDiagramEvent;
import org.goplanit.component.event.PopulateGapFunctionEvent;
import org.goplanit.component.event.PopulateInitialLinkSegmentCostEvent;
import org.goplanit.component.event.PopulateNetworkEvent;
import org.goplanit.component.event.PopulatePhysicalCostEvent;
import org.goplanit.component.event.PopulateRoutedServicesEvent;
import org.goplanit.component.event.PopulateServiceNetworkEvent;
import org.goplanit.component.event.PopulateUntypedComponentEvent;
import org.goplanit.component.event.PopulateZoningEvent;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.BprLinkTravelTimeCost;
import org.goplanit.cost.physical.FreeFlowLinkTravelTimeCost;
import org.goplanit.cost.physical.SteadyStateTravelTimeCost;
import org.goplanit.cost.physical.initial.InitialMacroscopicLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.cost.virtual.FixedConnectoidTravelTimeCost;
import org.goplanit.cost.virtual.SpeedConnectoidTravelTimeCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.gap.NormBasedGapFunction;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.Network;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.path.OdPathSets;
import org.goplanit.path.choice.PathChoice;
import org.goplanit.path.choice.logit.LogitChoiceModel;
import org.goplanit.path.choice.logit.MultinomialLogit;
import org.goplanit.sdinteraction.smoothing.MSASmoothing;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.supply.fundamentaldiagram.NewellFundamentalDiagramComponent;
import org.goplanit.supply.network.nodemodel.NodeModelComponent;
import org.goplanit.supply.network.nodemodel.TampereNodeModelComponent;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventListenerPriority;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.reflection.ReflectionUtils;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class PlanitComponentFactory<T extends PlanitComponent<?>>
extends EventProducerImpl
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(PlanitComponentFactory.class.getCanonicalName());
    private static final long serialVersionUID = -4507287133047792042L;
    protected final String componentSuperTypeCanonicalName;
    protected static final HashMap<String, TreeSet<String>> registeredPlanitComponents = new HashMap();

    private static void registerDefaultImplementations() {
        PlanitComponentFactory.registerPlanitComponentType(Zoning.class);
        PlanitComponentFactory.registerPlanitComponentType(TraditionalStaticAssignment.class);
        PlanitComponentFactory.registerPlanitComponentType(StaticLtm.class);
        PlanitComponentFactory.registerPlanitComponentType(MSASmoothing.class);
        PlanitComponentFactory.registerPlanitComponentType(Demands.class);
        PlanitComponentFactory.registerPlanitComponentType(RoutedServices.class);
        PlanitComponentFactory.registerPlanitComponentType(MacroscopicNetwork.class);
        PlanitComponentFactory.registerPlanitComponentType(ServiceNetwork.class);
        PlanitComponentFactory.registerPlanitComponentType(BprLinkTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(FreeFlowLinkTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(SteadyStateTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(InitialMacroscopicLinkSegmentCost.class);
        PlanitComponentFactory.registerPlanitComponentType(FixedConnectoidTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(SpeedConnectoidTravelTimeCost.class);
        PlanitComponentFactory.registerPlanitComponentType(NewellFundamentalDiagramComponent.class);
        PlanitComponentFactory.registerPlanitComponentType(TampereNodeModelComponent.class);
        PlanitComponentFactory.registerPlanitComponentType(MultinomialLogit.class);
        PlanitComponentFactory.registerPlanitComponentType(OdPathSets.class);
        PlanitComponentFactory.registerPlanitComponentType(LinkBasedRelativeDualityGapFunction.class);
        PlanitComponentFactory.registerPlanitComponentType(NormBasedGapFunction.class);
    }

    private <T extends PlanitComponent<?>> T createTrafficComponent(String planitComponentClassName, Object[] constructorParameters) {
        TreeSet<String> eligibleComponentTypes = registeredPlanitComponents.get(this.componentSuperTypeCanonicalName);
        PlanItRunTimeException.throwIf((eligibleComponentTypes == null || !eligibleComponentTypes.contains(planitComponentClassName) ? 1 : 0) != 0, (String)"Provided PLANit Component class %s is not eligible for construction", (Object[])new Object[]{planitComponentClassName != null ? planitComponentClassName : ""});
        PlanitComponent typedInstance = null;
        try {
            Object instance = ReflectionUtils.createInstance((String)planitComponentClassName, (Object[])constructorParameters);
            PlanItRunTimeException.throwIf((!(instance instanceof PlanitComponent) ? 1 : 0) != 0, (String)"provided factory class is not eligible for construction since it is not derived from PLANitComponent<?>", (Object[])new Object[0]);
            typedInstance = (PlanitComponent)instance;
        }
        catch (Exception e) {
            throw new PlanItRunTimeException(e);
        }
        this.addListener(typedInstance, EventListenerPriority.HIGH);
        return (T)typedInstance;
    }

    private <T extends PlanitComponent<?>> void dispatchPopulatePlanitComponentEvent(T newPlanitComponent, Object[] parameters) {
        PopulateUntypedComponentEvent event = null;
        if (newPlanitComponent instanceof MacroscopicNetwork && this.hasListener(PopulateNetworkEvent.EVENT_TYPE)) {
            event = new PopulateNetworkEvent(this, (MacroscopicNetwork)newPlanitComponent);
        } else if (newPlanitComponent instanceof Zoning && this.hasListener(PopulateZoningEvent.EVENT_TYPE)) {
            event = new PopulateZoningEvent(this, (Zoning)newPlanitComponent, (MacroscopicNetwork)parameters[0]);
        } else if (newPlanitComponent instanceof Demands && this.hasListener(PopulateDemandsEvent.EVENT_TYPE)) {
            event = new PopulateDemandsEvent(this, (Demands)newPlanitComponent, (Zoning)parameters[0], (MacroscopicNetwork)parameters[1]);
        } else if (newPlanitComponent instanceof ServiceNetwork && this.hasListener(PopulateServiceNetworkEvent.EVENT_TYPE)) {
            event = new PopulateServiceNetworkEvent(this, (ServiceNetwork)newPlanitComponent);
        } else if (newPlanitComponent instanceof RoutedServices && this.hasListener(PopulateRoutedServicesEvent.EVENT_TYPE)) {
            event = new PopulateRoutedServicesEvent(this, (RoutedServices)newPlanitComponent);
        } else if (newPlanitComponent instanceof GapFunction && this.hasListener(PopulateGapFunctionEvent.EVENT_TYPE)) {
            event = new PopulateGapFunctionEvent(this, (GapFunction)newPlanitComponent);
        } else if (newPlanitComponent instanceof FundamentalDiagramComponent && this.hasListener(PopulateFundamentalDiagramEvent.EVENT_TYPE)) {
            event = new PopulateFundamentalDiagramEvent(this, (FundamentalDiagramComponent)newPlanitComponent, (MacroscopicNetworkLayer)parameters[0]);
        } else if (newPlanitComponent instanceof InitialMacroscopicLinkSegmentCost && this.hasListener(PopulateInitialLinkSegmentCostEvent.EVENT_TYPE)) {
            event = new PopulateInitialLinkSegmentCostEvent(this, (InitialMacroscopicLinkSegmentCost)newPlanitComponent, (String)parameters[0], (MacroscopicNetwork)parameters[1], (TimePeriod)parameters[2]);
        } else if (newPlanitComponent instanceof AbstractPhysicalCost && this.hasListener(PopulatePhysicalCostEvent.EVENT_TYPE)) {
            event = new PopulatePhysicalCostEvent(this, (AbstractPhysicalCost)newPlanitComponent, (MacroscopicNetwork)parameters[0]);
        } else if (this.hasListener(PopulateComponentEvent.EVENT_TYPE)) {
            event = new PopulateComponentEvent(this, newPlanitComponent, parameters);
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    protected void fireEvent(EventListener eventListener, Event event) {
        try {
            ((PlanitComponentListener)PlanitComponentListener.class.cast(eventListener)).onPlanitComponentEvent((PlanitComponentEvent)PlanitComponentEvent.class.cast(event));
        }
        catch (PlanItException e) {
            if (e.getCause() != null) {
                LOGGER.severe(e.getCause().getMessage());
            }
            LOGGER.severe(e.getMessage());
            throw new RuntimeException("Unable to complete fired event" + event.toString());
        }
    }

    public <U extends PlanitComponent<U>> PlanitComponentFactory(Class<U> componentSuperType) {
        this.componentSuperTypeCanonicalName = componentSuperType.getCanonicalName();
    }

    public PlanitComponentFactory(String componentSuperTypeCanonicalName) {
        this.componentSuperTypeCanonicalName = componentSuperTypeCanonicalName;
    }

    public static void registerPlanitComponentType(Class<? extends PlanitComponent<?>> planitComponent) {
        for (Class<PlanitComponent<?>> currentClass = planitComponent; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Type currentSuperClass = currentClass.getGenericSuperclass();
            if (!(currentSuperClass instanceof ParameterizedType) || ((ParameterizedType)currentSuperClass).getRawType() != PlanitComponent.class) continue;
            TreeSet<String> treeSet = registeredPlanitComponents.get(currentClass.getCanonicalName());
            if (treeSet == null) {
                LOGGER.severe("Base class of PLANit component not registered as eligible on PLANit, component not eligible and therefore ignored");
                return;
            }
            treeSet.add(planitComponent.getCanonicalName());
            registeredPlanitComponents.get(currentClass.getCanonicalName()).add(planitComponent.getCanonicalName());
            return;
        }
        LOGGER.severe("PLANit component not eligible for registration");
    }

    public static <C extends PlanitComponent<?>, U extends C> U createWithListeners(Class<C> clazzCategory, Class<U> concreteClass, Object[] constructorParameters, Object[] eventParameters, PlanitComponentListener ... listeners) {
        return (U)PlanitComponentFactory.createWithListeners(clazzCategory, concreteClass.getCanonicalName(), constructorParameters, eventParameters, listeners);
    }

    public static <C extends PlanitComponent<?>> C createWithListeners(Class<C> clazzCategory, String concreteClassCanonicalName, Object[] constructorParameters, Object[] eventParameters, PlanitComponentListener ... listeners) {
        PlanitComponentFactory factoryInstance = new PlanitComponentFactory(clazzCategory.getCanonicalName());
        if (listeners != null) {
            for (PlanitComponentListener listener : listeners) {
                factoryInstance.addListener(listener);
            }
            return factoryInstance.create(concreteClassCanonicalName, constructorParameters, eventParameters);
        }
        return factoryInstance.create(concreteClassCanonicalName, constructorParameters);
    }

    public static <C extends PlanitComponent<?>> C createWithListeners(Class<C> clazzCategory, String concreteClassCanonicalName, Object[] constructorParameters, PlanitComponentListener ... listeners) {
        return PlanitComponentFactory.createWithListeners(clazzCategory, concreteClassCanonicalName, constructorParameters, null, listeners);
    }

    public static <C extends PlanitComponent<?>> C create(Class<C> clazzCategory, String concreteClassCanonicalName, Object[] constructorParameters) {
        return PlanitComponentFactory.createWithListeners(clazzCategory, concreteClassCanonicalName, constructorParameters, null, null);
    }

    public static <C extends PlanitComponent<?>, U extends C> U createWithListeners(Class<C> clazzCategory, Class<U> concreteClass, Object[] constructorParameters, PlanitComponentListener ... listeners) {
        return PlanitComponentFactory.createWithListeners(clazzCategory, concreteClass, constructorParameters, null, listeners);
    }

    public <C extends PlanitComponent<?>> C create(String planitComponentClassName, Object[] constructorParameters) {
        T newTrafficComponent = this.createTrafficComponent(planitComponentClassName, constructorParameters);
        this.dispatchPopulatePlanitComponentEvent(newTrafficComponent, (Object[])null);
        return (C)newTrafficComponent;
    }

    public <C extends PlanitComponent<?>> C create(String planitComponentClassName, Object[] constructorParameters, Object ... eventParameters) {
        T newTrafficComponent = this.createTrafficComponent(planitComponentClassName, constructorParameters);
        this.dispatchPopulatePlanitComponentEvent(newTrafficComponent, eventParameters);
        return (C)newTrafficComponent;
    }

    public <U> boolean isFactoryForDerivedClassesOf(Class<U> superClazz) {
        return superClazz.getCanonicalName().equals(this.componentSuperTypeCanonicalName);
    }

    public void addListener(PlanitComponentListener listener, PlanitComponentEventType ... eventTypes) {
        super.addListener((EventListener)listener, (EventType[])eventTypes);
    }

    public void addListener(PlanitComponentListener listener) {
        if (listener == null) {
            return;
        }
        super.addListener((EventListener)listener);
    }

    public void removeListener(PlanitComponentListener listener, PlanitComponentEventType eventType) {
        super.removeListener((EventListener)listener, (EventType)eventType);
    }

    public void removeListener(PlanitComponentListener listener) {
        super.removeListener((EventListener)listener);
    }

    static {
        registeredPlanitComponents.put(Zoning.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(NetworkLoading.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Smoothing.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Demands.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(RoutedServices.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(Network.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(AbstractPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(InitialPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(AbstractVirtualCost.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(FundamentalDiagramComponent.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(NodeModelComponent.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(PathChoice.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(LogitChoiceModel.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(OdPathSets.class.getCanonicalName(), new TreeSet());
        registeredPlanitComponents.put(GapFunction.class.getCanonicalName(), new TreeSet());
        PlanitComponentFactory.registerDefaultImplementations();
    }
}

