/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.component;

import java.util.Map;
import org.goplanit.component.event.PlanitComponentEvent;
import org.goplanit.component.event.PlanitComponentEventType;
import org.goplanit.component.event.PlanitComponentListener;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public abstract class PlanitComponent<T extends PlanitComponent<T>>
implements ExternalIdAble,
PlanitComponentListener {
    private final ExternalIdAbleImpl idImpl;
    private IdGroupingToken tokenId;
    private final String planitComponentType;

    protected PlanitComponent(IdGroupingToken tokenId, Class<?> classType) {
        this.planitComponentType = this.getClass().getCanonicalName();
        this.tokenId = tokenId;
        this.idImpl = new ExternalIdAbleImpl(IdGenerator.generateId((IdGroupingToken)tokenId, classType));
    }

    protected PlanitComponent(PlanitComponent<T> other, boolean deepCopy) {
        this.planitComponentType = other.planitComponentType;
        this.tokenId = other.tokenId;
        this.idImpl = deepCopy ? other.idImpl.deepClone() : other.idImpl.shallowClone();
    }

    public abstract PlanitComponent<T> shallowClone();

    public abstract PlanitComponent<T> deepClone();

    public abstract void reset();

    public PlanitComponentEventType[] getKnownSupportedEventTypes() {
        return new PlanitComponentEventType[0];
    }

    public int hashCode() {
        return this.idHashCode();
    }

    public boolean equals(Object obj) {
        return this.idEquals(obj);
    }

    public long getId() {
        return this.idImpl.getId();
    }

    public String getExternalId() {
        return this.idImpl.getExternalId();
    }

    public void setExternalId(String externalId) {
        this.idImpl.setExternalId(externalId);
    }

    public String getXmlId() {
        return this.idImpl.getXmlId();
    }

    public void setXmlId(String xmlId) {
        this.idImpl.setXmlId(xmlId);
    }

    @Override
    public void onPlanitComponentEvent(PlanitComponentEvent event) throws PlanItException {
    }

    public abstract Map<String, String> collectSettingsAsKeyValueMap();

    public String getComponentType() {
        return this.planitComponentType;
    }

    public IdGroupingToken getIdGroupingToken() {
        return this.tokenId;
    }
}

