/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.traditionalstatic;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.goplanit.assignment.SimulationData;
import org.goplanit.assignment.traditionalstatic.ModeData;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.od.skim.OdSkimMatrix;
import org.goplanit.output.configuration.OdOutputTypeConfiguration;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.OdZones;

public class TraditionalStaticAssignmentSimulationData
extends SimulationData {
    private IdGroupingToken groupId;
    private final Map<Mode, ModeData> modeSpecificData;
    private Map<Mode, double[]> modalNetworkSegmentCostsMap;
    private Map<Mode, Map<OdSkimSubOutputType, OdSkimMatrix>> modalSkimMatrixMap;
    private Map<Mode, OdPathMatrix> modalOdPathMatrixMap;

    public TraditionalStaticAssignmentSimulationData(IdGroupingToken groupId) {
        this.groupId = groupId;
        this.modeSpecificData = new TreeMap<Mode, ModeData>();
        this.modalNetworkSegmentCostsMap = new HashMap<Mode, double[]>();
        this.modalSkimMatrixMap = new HashMap<Mode, Map<OdSkimSubOutputType, OdSkimMatrix>>();
        this.modalOdPathMatrixMap = new HashMap<Mode, OdPathMatrix>();
    }

    public Map<Mode, ModeData> getModeSpecificData() {
        return this.modeSpecificData;
    }

    public double collectTotalNetworkSegmentFlow(LinkSegment linkSegment) {
        return this.modeSpecificData.values().stream().collect(Collectors.summingDouble(modeData -> modeData.getCurrentSegmentFlows()[(int)linkSegment.getId()]));
    }

    public double[] collectTotalNetworkSegmentFlows() {
        Collection<ModeData> modeData = this.modeSpecificData.values();
        double[] networkSegmentFlows = null;
        for (ModeData modeDataEntry : modeData) {
            if (networkSegmentFlows == null) {
                networkSegmentFlows = Arrays.copyOf(modeDataEntry.getCurrentSegmentFlows(), modeDataEntry.getCurrentSegmentFlows().length);
                continue;
            }
            ArrayUtils.addTo(networkSegmentFlows, (double[])modeDataEntry.getCurrentSegmentFlows());
        }
        return networkSegmentFlows;
    }

    public void setModalLinkSegmentCosts(Mode mode, double[] modalLinkSegmentCosts) {
        this.modalNetworkSegmentCostsMap.put(mode, modalLinkSegmentCosts);
    }

    public double[] getModalLinkSegmentCosts(Mode mode) {
        return this.modalNetworkSegmentCostsMap.get(mode);
    }

    public void resetSkimMatrix(Mode mode, OdZones zones, OdOutputTypeConfiguration originDestinationOutputTypeConfiguration) {
        this.modalSkimMatrixMap.put(mode, new HashMap());
        for (SubOutputTypeEnum odSkimOutputType : originDestinationOutputTypeConfiguration.getActiveSubOutputTypes()) {
            OdSkimMatrix odSkimMatrix = new OdSkimMatrix(zones, (OdSkimSubOutputType)odSkimOutputType);
            this.modalSkimMatrixMap.get(mode).put((OdSkimSubOutputType)odSkimOutputType, odSkimMatrix);
        }
    }

    public void resetPathMatrix(Mode mode, OdZones zones) {
        this.modalOdPathMatrixMap.put(mode, new OdPathMatrix(this.groupId, zones));
    }

    public OdSkimMatrix getOdSkimMatrix(OdSkimSubOutputType odSkimOutputType, Mode mode) {
        Map<OdSkimSubOutputType, OdSkimMatrix> skimMatrixMap;
        if (this.modalSkimMatrixMap.containsKey(mode) && (skimMatrixMap = this.modalSkimMatrixMap.get(mode)).containsKey(odSkimOutputType)) {
            return skimMatrixMap.get(odSkimOutputType);
        }
        return null;
    }

    public OdPathMatrix getOdPathMatrix(Mode mode) {
        return this.modalOdPathMatrixMap.get(mode);
    }

    public Map<OdSkimSubOutputType, OdSkimMatrix> getSkimMatrixMap(Mode mode) {
        return this.modalSkimMatrixMap.get(mode);
    }
}

