/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.traditionalstatic;

import java.util.Optional;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.goplanit.output.adapter.MacroscopicLinkOutputTypeAdapterImpl;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.time.TimePeriod;

public class TraditionalStaticAssignmentLinkOutputTypeAdapter
extends MacroscopicLinkOutputTypeAdapterImpl {
    @Override
    protected TraditionalStaticAssignment getAssignment() {
        return (TraditionalStaticAssignment)super.getAssignment();
    }

    private Optional<Double> getCalculatedSpeed(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentCosts = this.getAssignment().getIterationData().getModalLinkSegmentCosts(mode);
        double travelTime = modalNetworkSegmentCosts[id];
        double length = linkSegment.getParentLink().getLengthKm();
        return Optional.of(length / travelTime);
    }

    private Optional<Double> getFlow(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentFlows = this.getAssignment().getIterationData().getModeSpecificData().get(mode).getCurrentSegmentFlows();
        return Optional.of(modalNetworkSegmentFlows[id]);
    }

    private Optional<Double> getLinkCostTravelTime(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentCosts = this.getAssignment().getIterationData().getModalLinkSegmentCosts(mode);
        return Optional.of(modalNetworkSegmentCosts[id]);
    }

    private Optional<Double> getCostTimesFlow(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        return Optional.of(this.getLinkCostTravelTime(linkSegment, mode).get() * this.getFlow(linkSegment, mode).get());
    }

    private Optional<Double> getVCRatio(MacroscopicLinkSegment linkSegment) throws PlanItException {
        double totalFlow = 0.0;
        for (Mode mode : this.getAssignment().getTransportNetwork().getInfrastructureNetwork().getModes()) {
            totalFlow += this.getFlow(linkSegment, mode).get().doubleValue();
        }
        double capacityPerLane = this.getCapacityPerLanePcuHour(linkSegment).get();
        return Optional.of(totalFlow / ((double)linkSegment.getNumberOfLanes() * capacityPerLane));
    }

    public TraditionalStaticAssignmentLinkOutputTypeAdapter(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<Boolean> isFlowPositive(MacroscopicLinkSegment linkSegment, Mode mode) {
        return Optional.of(this.getAssignment().getIterationData().getModeSpecificData().get(mode).getCurrentSegmentFlows()[(int)linkSegment.getId()] > 0.0);
    }

    @Override
    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty outputProperty, MacroscopicLinkSegment linkSegment, Mode mode, TimePeriod timePeriod) {
        Optional<Object> value = Optional.empty();
        try {
            value = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            value = super.getLinkSegmentOutputPropertyValue(outputProperty, linkSegment, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            switch (outputProperty.getOutputPropertyType()) {
                case CALCULATED_SPEED: {
                    value = this.getCalculatedSpeed(linkSegment, mode);
                    break;
                }
                case FLOW: {
                    value = this.getFlow(linkSegment, mode);
                    break;
                }
                case INFLOW: {
                    value = this.getFlow(linkSegment, mode);
                    break;
                }
                case OUTFLOW: {
                    value = this.getFlow(linkSegment, mode);
                    break;
                }
                case LINK_SEGMENT_COST: {
                    value = this.getLinkCostTravelTime(linkSegment, mode);
                    break;
                }
                case VC_RATIO: {
                    value = this.getVCRatio(linkSegment);
                    break;
                }
                case COST_TIMES_FLOW: {
                    value = this.getCostTimesFlow(linkSegment, mode);
                    break;
                }
                default: {
                    throw new PlanItException("Tried to find link property of %s which is not applicable for links", new Object[]{outputProperty.getName()});
                }
            }
            if (outputProperty.supportsUnitOverride() && outputProperty.isUnitOverride()) {
                value = TraditionalStaticAssignmentLinkOutputTypeAdapter.createConvertedUnitsValue(outputProperty, value);
            }
        }
        catch (PlanItException e) {
            value = Optional.of(e.getMessage());
        }
        return value;
    }
}

