/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.algorithms.nodemodel.TampereNodeModel;
import org.goplanit.algorithms.nodemodel.TampereNodeModelFixedInput;
import org.goplanit.algorithms.nodemodel.TampereNodeModelInput;
import org.goplanit.assignment.ltm.sltm.LinkSegmentData;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.assignment.ltm.sltm.consumer.NMRUpdateEntryLinksOutflowConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.NMRUpdateExitLinkInflowsConsumer;
import org.goplanit.assignment.ltm.sltm.loading.InflowOutflowData;
import org.goplanit.assignment.ltm.sltm.loading.NetworkLoadingFactorData;
import org.goplanit.assignment.ltm.sltm.loading.ReceivingFlowData;
import org.goplanit.assignment.ltm.sltm.loading.SendingFlowData;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateDataComplete;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateDataPartial;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingScheme;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoadingConvergenceAnalyser;
import org.goplanit.gap.NormBasedGapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.pcu.PcuCapacitated;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Access1D;

public abstract class StaticLtmNetworkLoading {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmNetworkLoading.class.getCanonicalName());
    private final IdGroupingToken idToken;
    private final long runId;
    private TransportModelNetwork network;
    private Mode mode;
    private OdDemands odDemands;
    protected SendingFlowData sendingFlowData;
    protected ReceivingFlowData receivingFlowData;
    protected SplittingRateData splittingRateData;
    protected NetworkLoadingFactorData networkLoadingFactorData;
    protected InflowOutflowData inFlowOutflowData;
    protected NormBasedGapFunction flowAcceptanceGapFunction;
    protected NormBasedGapFunction sendingFlowGapFunction;
    protected NormBasedGapFunction receivingFlowGapFunction;
    protected final StaticLtmSettings settings;
    protected final StaticLtmNetworkLoadingConvergenceAnalyser convergenceAnalyser;
    protected StaticLtmLoadingScheme solutionScheme;
    protected StaticLtmLoadingScheme prevIterationFinalSolutionScheme;

    private void initialiseStaticLtmSolutionSchemeApproach(boolean logSolutionScheme) {
        this.solutionScheme = this.getSettings().isDisableStorageConstraints() != false ? StaticLtmLoadingScheme.POINT_QUEUE_BASIC : StaticLtmLoadingScheme.PHYSICAL_QUEUE_BASIC;
        if (logSolutionScheme) {
            LOGGER.info(String.format("sLTM network loading scheme set to %s", this.solutionScheme.getValue()));
        }
    }

    private void initialiseTrackAllNodeTurnFlows() {
        this.initialiseSendingFlows();
        this.initialiseNodeSplittingRateStatus();
    }

    private void initialiseSendingFlows() {
        this.sendingFlowData.resetCurrentSendingFlows();
        this.networkLoadingLinkSegmentSendingFlowUpdate();
        LinkSegmentData.copyTo(this.sendingFlowData.getCurrentSendingFlows(), this.sendingFlowData.getNextSendingFlows());
    }

    private void initialiseReceivingFlows() {
        if (this.solutionScheme.isPointQueue()) {
            double[] currReceivingFlows = this.receivingFlowData.getCurrentReceivingFlows();
            for (MacroscopicLinkSegment linkSegment : this.getUsedNetworkLayer().getLinkSegments()) {
                currReceivingFlows[(int)linkSegment.getId()] = linkSegment.getCapacityOrDefaultPcuH();
            }
            for (ConnectoidSegment connectoidSegment : this.network.getVirtualNetwork().getConnectoidSegments()) {
                currReceivingFlows[(int)connectoidSegment.getId()] = connectoidSegment.getCapacityOrDefaultPcuH();
            }
            LinkSegmentData.copyTo(currReceivingFlows, this.receivingFlowData.getNextReceivingFlows());
        } else {
            LOGGER.severe("sLTM with physical queues is not yet implemented, please disable storage constraints and try again");
        }
    }

    private SplittingRateData createSplittingRateData() {
        if (!this.isTrackAllNodeTurnFlows()) {
            return new SplittingRateDataPartial(this.getTransportNetwork().getNumberOfVerticesAllLayers());
        }
        if (!this.solutionScheme.equals((Object)StaticLtmLoadingScheme.NONE)) {
            return new SplittingRateDataComplete(this.inFlowOutflowData.getInflows().length);
        }
        LOGGER.severe("Unable to create correct splitting rate tracking data class");
        return null;
    }

    private void initialiseNodeSplittingRateStatus() {
        if (this.solutionScheme.equals((Object)StaticLtmLoadingScheme.NONE)) {
            LOGGER.severe("Unable to initialise node splitting rate data");
            return;
        }
        boolean initialiseTrackedNodes = false;
        if (!this.prevIterationFinalSolutionScheme.equals((Object)this.getActivatedSolutionScheme())) {
            this.splittingRateData = this.createSplittingRateData();
            initialiseTrackedNodes = true;
        }
        if (initialiseTrackedNodes) {
            if (this.isTrackAllNodeTurnFlows()) {
                this.activateAllUsedNodeSplittingRates(this.sendingFlowData.getCurrentSendingFlows());
            } else {
                this.activateEligibleSplittingRateTrackedNodes();
            }
        }
        if (!this.isTrackAllNodeTurnFlows()) {
            this.updatePotentiallyBlockingNodes(this.sendingFlowData.getCurrentSendingFlows());
        }
    }

    private void updateNextSplittingRates(MultiKeyMap<Object, Double> acceptedTurnFlows) {
        TreeSet<DirectedVertex> trackedNodes = this.splittingRateData.getTrackedNodes();
        for (DirectedVertex node : trackedNodes) {
            for (EdgeSegment entrySegment : node.getEntryEdgeSegments()) {
                Array1D<Double> nextSplittingRates = this.splittingRateData.getSplittingRates(entrySegment);
                nextSplittingRates.reset();
                int index = 0;
                for (EdgeSegment exitSegment : node.getExitEdgeSegments()) {
                    if (entrySegment.idEquals((Object)exitSegment)) continue;
                    Double acceptedTurnFlow = (Double)acceptedTurnFlows.get((Object)entrySegment, (Object)exitSegment);
                    if (acceptedTurnFlow == null) {
                        acceptedTurnFlow = 0.0;
                    }
                    nextSplittingRates.set(index++, (Object)acceptedTurnFlow);
                }
                double totalEntryFlow = (Double)nextSplittingRates.aggregateAll(Aggregator.SUM);
                if (totalEntryFlow > 0.0) {
                    nextSplittingRates.modifyAll(PrimitiveFunction.DIVIDE.by(totalEntryFlow));
                    continue;
                }
                nextSplittingRates.fillAll((Number)1.0);
            }
        }
    }

    private void performNodeModelUpdate(ApplyToNodeModelResult consumer) {
        for (DirectedVertex trackedNode : this.splittingRateData.getTrackedNodes()) {
            StaticLtmNetworkLoading.performNodeModelUpdate(trackedNode, consumer, this);
        }
    }

    private void updateNextStorageCapacityFactors() {
        this.networkLoadingFactorData.resetNextStorageCapacityFactors();
        double[] nextStorageCapacityFactor = this.networkLoadingFactorData.getNextStorageCapacityFactors();
        double[] inflows = this.inFlowOutflowData.getInflows();
        double[] receivingFlows = this.receivingFlowData.getCurrentReceivingFlows();
        int currentLinkSegmentId = -1;
        for (DirectedVertex trackedNode : this.splittingRateData.getTrackedNodes()) {
            if (!this.splittingRateData.isPotentiallyBlocking(trackedNode)) continue;
            for (EdgeSegment entryEdgeSegment : trackedNode.getEntryEdgeSegments()) {
                currentLinkSegmentId = (int)entryEdgeSegment.getId();
                nextStorageCapacityFactor[currentLinkSegmentId] = inflows[currentLinkSegmentId] / receivingFlows[currentLinkSegmentId];
            }
        }
    }

    private void updateNextFlowAcceptanceFactors() {
        this.networkLoadingFactorData.resetNextFlowAcceptanceFactors();
        double[] inflows = this.inFlowOutflowData.getInflows();
        double[] nextFlowAcceptanceFactors = this.networkLoadingFactorData.getNextFlowAcceptanceFactors();
        double[] currentFlowCapacityFactors = this.networkLoadingFactorData.getCurrentFlowCapacityFactors();
        double[] currentStorageCapacityFactors = this.networkLoadingFactorData.getCurrentStorageCapacityFactors();
        int currentLinkSegmentId = -1;
        for (DirectedVertex trackedNode : this.splittingRateData.getTrackedNodes()) {
            if (!this.splittingRateData.isPotentiallyBlocking(trackedNode)) continue;
            for (EdgeSegment entryEdgeSegment : trackedNode.getEntryEdgeSegments()) {
                currentLinkSegmentId = (int)entryEdgeSegment.getId();
                if (inflows[currentLinkSegmentId] <= 1.0E-6) {
                    nextFlowAcceptanceFactors[currentLinkSegmentId] = 1.0;
                    continue;
                }
                nextFlowAcceptanceFactors[currentLinkSegmentId] = currentFlowCapacityFactors[currentLinkSegmentId] / currentStorageCapacityFactors[currentLinkSegmentId];
            }
        }
    }

    private void updateNextFlowCapacityFactors() {
        this.networkLoadingFactorData.resetNextFlowCapacityFactors();
        double[] nextFlowCapacityFactors = this.networkLoadingFactorData.getNextFlowCapacityFactors();
        double[] outflows = this.inFlowOutflowData.getOutflows();
        double[] receivingFlows = this.receivingFlowData.getCurrentReceivingFlows();
        int currentLinkSegmentId = -1;
        for (DirectedVertex trackedNode : this.splittingRateData.getTrackedNodes()) {
            if (!this.splittingRateData.isPotentiallyBlocking(trackedNode)) continue;
            for (EdgeSegment entryEdgeSegment : trackedNode.getEntryEdgeSegments()) {
                currentLinkSegmentId = (int)entryEdgeSegment.getId();
                nextFlowCapacityFactors[currentLinkSegmentId] = Math.min(1.0, outflows[currentLinkSegmentId] / receivingFlows[currentLinkSegmentId]);
            }
        }
    }

    protected boolean validateInputs() {
        if (!this.getSettings().validate()) {
            LOGGER.severe(String.format("%sUnable to use sLTM settings, aborting initialisation of sLTM", LoggingUtils.runIdPrefix((long)this.runId)));
            return false;
        }
        if (this.mode == null) {
            LOGGER.severe("Mode for sLTM network loading is null");
            return false;
        }
        if (this.network == null || this.network.getInfrastructureNetwork() == null || this.network.getInfrastructureNetwork().getLayerByMode(this.mode) == null) {
            LOGGER.severe("Network or network layer or mode of network layer not available for static LTM network loading");
            return false;
        }
        if (!(this.network.getInfrastructureNetwork().getLayerByMode(this.mode) instanceof MacroscopicNetworkLayer)) {
            LOGGER.severe(String.format("Network layer for mode %s not of compatible type, expected MacroscopicNetworkLayer", this.mode.getXmlId()));
            return false;
        }
        if (this.odDemands == null) {
            LOGGER.severe("OdDemands for sLTM network loading are null");
            return false;
        }
        return true;
    }

    protected MacroscopicNetworkLayer getUsedNetworkLayer() {
        return (MacroscopicNetworkLayer)this.network.getInfrastructureNetwork().getLayerByMode(this.mode);
    }

    protected TransportModelNetwork getTransportNetwork() {
        return this.network;
    }

    protected OdDemands getOdDemands() {
        return this.odDemands;
    }

    protected boolean isIterativeSendingFlowUpdateActivated() {
        return !this.solutionScheme.equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
    }

    protected boolean isTrackAllNodeTurnFlows() {
        return !this.solutionScheme.equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
    }

    protected void updatePotentiallyBlockingNodes(double[] sendingFlowsPcuH) {
        SplittingRateDataPartial pointQueueBasicSplittingRates = (SplittingRateDataPartial)this.splittingRateData;
        pointQueueBasicSplittingRates.resetPotentiallyBlockingNodes();
        for (MacroscopicLinkSegment linkSegment : this.getUsedNetworkLayer().getLinkSegments()) {
            if (pointQueueBasicSplittingRates.isPotentiallyBlocking((DirectedVertex)linkSegment.getUpstreamNode())) continue;
            double capacity = linkSegment.getCapacityOrDefaultPcuH();
            if (!Precision.greater((double)sendingFlowsPcuH[(int)linkSegment.getId()], (double)capacity)) continue;
            pointQueueBasicSplittingRates.registerPotentiallyBlockingNode((DirectedVertex)linkSegment.getUpstreamNode());
        }
    }

    protected void activateAllUsedNodeSplittingRates(double[] sendingFlowsPcuH) {
        SplittingRateDataComplete extendedSplittingRates = (SplittingRateDataComplete)this.splittingRateData;
        for (MacroscopicLinkSegment linkSegment : this.getUsedNetworkLayer().getLinkSegments()) {
            if (!Precision.positive((double)sendingFlowsPcuH[(int)linkSegment.getId()])) continue;
            extendedSplittingRates.activateNode((DirectedVertex)linkSegment.getUpstreamNode());
        }
        for (ConnectoidSegment connectoidSegment : this.getTransportNetwork().getZoning().getVirtualNetwork().getConnectoidSegments()) {
            if (!Precision.positive((double)sendingFlowsPcuH[(int)connectoidSegment.getId()])) continue;
            extendedSplittingRates.activateNode(connectoidSegment.getUpstreamVertex());
            extendedSplittingRates.activateNode(connectoidSegment.getDownstreamVertex());
        }
    }

    protected abstract MultiKeyMap<Object, Double> networkLoadingTurnFlowUpdate();

    protected abstract void networkLoadingLinkSegmentSendingFlowUpdate();

    protected abstract void networkLoadingLinkSegmentSendingflowOutflowUpdate();

    protected abstract void activateEligibleSplittingRateTrackedNodes();

    protected StaticLtmNetworkLoading(IdGroupingToken idToken, long runId, StaticLtmSettings settings) {
        this.runId = runId;
        this.idToken = idToken;
        this.settings = settings;
        this.convergenceAnalyser = new StaticLtmNetworkLoadingConvergenceAnalyser();
        this.prevIterationFinalSolutionScheme = this.solutionScheme = StaticLtmLoadingScheme.NONE;
    }

    public static void performNodeModelUpdate(DirectedVertex node, ApplyToNodeModelResult consumer, StaticLtmNetworkLoading staticLtmNetworkLoading) {
        SplittingRateData splittingRateData = staticLtmNetworkLoading.getSplittingRateData();
        SendingFlowData sendingFlowData = staticLtmNetworkLoading.sendingFlowData;
        if (!splittingRateData.isPotentiallyBlocking(node) || node instanceof CentroidVertex) {
            consumer.acceptNonBlockingLinkBasedResult(node, sendingFlowData.getCurrentSendingFlows());
            return;
        }
        int numEntrySegments = node.getNumberOfEntryEdgeSegments();
        int numExitSegments = node.getNumberOfExitEdgeSegments();
        Array1D inCapacities = Array1D.PRIMITIVE64.makeZero((long)numEntrySegments);
        int index = 0;
        for (EdgeSegment entryEdgeSegment : node.getEntryEdgeSegments()) {
            inCapacities.set((long)index++, Math.min(TampereNodeModelFixedInput.DEFAULT_MAX_IN_CAPACITY, ((PcuCapacitated)entryEdgeSegment).getCapacityOrDefaultPcuH()));
        }
        Access1D[] tunSendingFlowsByEntryLinkSegment = new Access1D[numEntrySegments];
        int entryIndex = 0;
        for (EdgeSegment entryEdgeSegment : node.getEntryEdgeSegments()) {
            double sendingFlow = sendingFlowData.getCurrentSendingFlows()[(int)entryEdgeSegment.getId()];
            Array1D localTurnSendingFlows = splittingRateData.getSplittingRates(entryEdgeSegment).copy();
            localTurnSendingFlows.modifyAll(PrimitiveFunction.MULTIPLY.by(sendingFlow));
            tunSendingFlowsByEntryLinkSegment[entryIndex] = localTurnSendingFlows;
            ++entryIndex;
        }
        Array2D turnSendingFlows = Array2D.PRIMITIVE64.rows(tunSendingFlowsByEntryLinkSegment);
        Array1D outReceivingFlows = Array1D.PRIMITIVE64.makeZero((long)numExitSegments);
        index = 0;
        for (EdgeSegment exitEdgeSegment : node.getExitEdgeSegments()) {
            outReceivingFlows.set((long)index++, ((PcuCapacitated)exitEdgeSegment).getCapacityOrDefaultPcuH());
        }
        try {
            TampereNodeModel nodeModel = new TampereNodeModel(new TampereNodeModelInput(new TampereNodeModelFixedInput((Array1D<Double>)inCapacities, (Array1D<Double>)outReceivingFlows), (Array2D<Double>)turnSendingFlows));
            Array1D<Double> localFlowAcceptanceFactors = nodeModel.run();
            consumer.acceptTurnBasedResult(node, localFlowAcceptanceFactors, nodeModel);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Unable to run Tampere node model on tracked node %s", node.getXmlId()));
        }
    }

    public void initialiseInputs(Mode mode, OdDemands odDemands, TransportModelNetwork network) {
        this.mode = mode;
        this.odDemands = odDemands;
        this.network = network;
        this.validateInputs();
        double[] referenceEmptyArray = new double[network.getNumberOfEdgeSegmentsAllLayers()];
        this.sendingFlowData = new SendingFlowData(referenceEmptyArray);
        this.receivingFlowData = new ReceivingFlowData(referenceEmptyArray);
        this.inFlowOutflowData = new InflowOutflowData(referenceEmptyArray);
        this.networkLoadingFactorData = new NetworkLoadingFactorData(network.getNumberOfEdgeSegmentsAllLayers());
        this.flowAcceptanceGapFunction = new NormBasedGapFunction(this.idToken, new StopCriterion());
        this.sendingFlowGapFunction = new NormBasedGapFunction(this.idToken, new StopCriterion());
        this.receivingFlowGapFunction = new NormBasedGapFunction(this.idToken, new StopCriterion());
    }

    public boolean stepZeroIterationInitialisation(boolean logSolutionScheme) {
        this.initialiseStaticLtmSolutionSchemeApproach(logSolutionScheme);
        this.initialiseSendingFlows();
        this.initialiseNodeSplittingRateStatus();
        this.sendingFlowData.limitCurrentSendingFlowsToCapacity(this.getUsedNetworkLayer().getLinkSegments());
        this.initialiseReceivingFlows();
        return true;
    }

    public void stepOneSplittingRatesUpdate() {
        if (this.solutionScheme.isPhysicalQueue()) {
            LOGGER.severe(String.format("%ssLTM with physical queues is not yet implemented, please disable storage constraints and try again", LoggingUtils.runIdPrefix((long)this.runId)));
        }
        MultiKeyMap<Object, Double> acceptedTurnFlows = this.networkLoadingTurnFlowUpdate();
        this.updateNextSplittingRates(acceptedTurnFlows);
    }

    public void stepTwoInflowSendingFlowUpdate() {
        if (this.solutionScheme.isPhysicalQueue()) {
            LOGGER.severe(String.format("%ssLTM with physical queues is not yet implemented, please disable storage constraints and try again", LoggingUtils.runIdPrefix((long)this.runId)));
            return;
        }
        int sendingFlowIterationIndex = 0;
        double sendingFlowGap = this.sendingFlowGapFunction.getGap();
        do {
            LinkSegmentData.copyTo(this.sendingFlowData.getCurrentSendingFlows(), this.inFlowOutflowData.getInflows());
            this.performNodeModelUpdate(new NMRUpdateExitLinkInflowsConsumer(this.inFlowOutflowData.getInflows()));
            LinkSegmentData.copyTo(this.inFlowOutflowData.getInflows(), this.sendingFlowData.getNextSendingFlows());
            this.sendingFlowGapFunction.reset();
            this.sendingFlowGapFunction.increaseMeasuredValue(this.sendingFlowData.getNextSendingFlows(), this.sendingFlowData.getCurrentSendingFlows());
            sendingFlowGap = this.sendingFlowGapFunction.computeGap();
            this.sendingFlowData.swapCurrentAndNextSendingFlows();
        } while (this.isIterativeSendingFlowUpdateActivated() && !this.sendingFlowGapFunction.getStopCriterion().hasConverged(sendingFlowGap, sendingFlowIterationIndex++));
        this.sendingFlowGapFunction.reset();
        this.updateNextStorageCapacityFactors();
        this.networkLoadingFactorData.swapCurrentAndNextStorageCapacityFactors();
    }

    public void stepThreeSplittingRateUpdate() {
        if (!this.solutionScheme.isPhysicalQueue()) {
            return;
        }
        if (this.solutionScheme.isPhysicalQueue()) {
            LOGGER.severe(String.format("%ssLTM with physical queues is not yet implemented, please disable storage constraints and try again", LoggingUtils.runIdPrefix((long)this.runId)));
            return;
        }
        this.updateNextFlowAcceptanceFactors();
        MultiKeyMap<Object, Double> acceptedTurnFlows = this.networkLoadingTurnFlowUpdate();
        this.updateNextSplittingRates(acceptedTurnFlows);
    }

    public void stepFourOutflowReceivingFlowUpdate() {
        if (this.solutionScheme.isPhysicalQueue()) {
            LOGGER.severe(String.format("%ssLTM with physical queues is not yet implemented, please disable storage constraints and try again", LoggingUtils.runIdPrefix((long)this.runId)));
            return;
        }
        int receivingFlowIterationIndex = 0;
        double receivingFlowGap = this.receivingFlowGapFunction.getGap();
        do {
            this.performNodeModelUpdate(new NMRUpdateEntryLinksOutflowConsumer(this.inFlowOutflowData.getOutflows()));
            if (this.solutionScheme.isPointQueue()) break;
            double[] outflows = this.inFlowOutflowData.getOutflows();
            double[] nextReceivingFlows = this.receivingFlowData.getNextReceivingFlows();
            for (DirectedVertex node : this.splittingRateData.getTrackedNodes()) {
                for (EdgeSegment entryEdgeSegment : node.getEntryEdgeSegments()) {
                    double receivingFlow;
                    int index = (int)entryEdgeSegment.getId();
                    double storageCapacity = Double.POSITIVE_INFINITY;
                    nextReceivingFlows[index] = receivingFlow = Math.min(((PcuCapacitated)entryEdgeSegment).getCapacityOrDefaultPcuH(), outflows[index] + storageCapacity);
                }
            }
            this.receivingFlowGapFunction.reset();
            this.receivingFlowGapFunction.increaseMeasuredValue(this.receivingFlowData.getNextReceivingFlows(), this.receivingFlowData.getCurrentReceivingFlows());
            receivingFlowGap = this.receivingFlowGapFunction.computeGap();
            this.receivingFlowData.swapCurrentAndNextReceivingFlows();
        } while (!this.receivingFlowGapFunction.getStopCriterion().hasConverged(receivingFlowGap, receivingFlowIterationIndex++));
        this.receivingFlowGapFunction.reset();
        this.updateNextFlowCapacityFactors();
        this.networkLoadingFactorData.swapCurrentAndNextFlowCapacityFactors();
    }

    public boolean stepFiveCheckNetworkLoadingConvergence(int networkLoadingIteration) {
        if (this.solutionScheme.isPhysicalQueue()) {
            LOGGER.severe(String.format("%ssLTM with physical queues is not yet implemented, please disable storage constraints and try again", LoggingUtils.runIdPrefix((long)this.runId)));
            return true;
        }
        this.updateNextFlowAcceptanceFactors();
        this.flowAcceptanceGapFunction.reset();
        this.flowAcceptanceGapFunction.increaseMeasuredValue(this.networkLoadingFactorData.getNextFlowAcceptanceFactors(), this.networkLoadingFactorData.getCurrentFlowAcceptanceFactors());
        double globalGap = this.flowAcceptanceGapFunction.computeGap();
        this.convergenceAnalyser.registerIterationGap(globalGap);
        if (this.getSettings().isDetailedLogging().booleanValue()) {
            LOGGER.info(String.format("%sNetwork loading gap (i=%d): %.10f", LoggingUtils.runIdPrefix((long)this.runId), networkLoadingIteration, globalGap));
        }
        this.networkLoadingFactorData.swapCurrentAndNextFlowAcceptanceFactors();
        boolean converged = this.flowAcceptanceGapFunction.getStopCriterion().hasConverged(globalGap, networkLoadingIteration);
        if (converged) {
            LOGGER.info(String.format("%ssLTM network loading converged in %d iterations (remaining gap: %.10f)", LoggingUtils.runIdPrefix((long)this.runId), networkLoadingIteration, globalGap));
        }
        return converged;
    }

    public void stepSixFinaliseForPersistence() {
        if (!this.isTrackAllNodeTurnFlows()) {
            this.solutionScheme = StaticLtmLoadingScheme.POINT_QUEUE_ADVANCED;
            int originalMaxIterations = this.sendingFlowGapFunction.getStopCriterion().getMaxIterations();
            this.sendingFlowGapFunction.getStopCriterion().setMaxIterations(1);
            this.initialiseTrackAllNodeTurnFlows();
            this.stepOneSplittingRatesUpdate();
            this.stepTwoInflowSendingFlowUpdate();
            this.stepThreeSplittingRateUpdate();
            this.stepFourOutflowReceivingFlowUpdate();
            this.sendingFlowGapFunction.getStopCriterion().setMaxIterations(originalMaxIterations);
        }
        this.networkLoadingLinkSegmentSendingflowOutflowUpdate();
        this.sendingFlowData.limitCurrentSendingFlowsToCapacity(this.getUsedNetworkLayer().getLinkSegments());
        LinkSegmentData.copyTo(this.sendingFlowData.getCurrentSendingFlows(), this.inFlowOutflowData.getInflows());
        this.inFlowOutflowData.limitOutflowsToCapacity(this.getUsedNetworkLayer().getLinkSegments());
    }

    public boolean isConverging() {
        return this.convergenceAnalyser.isImproving();
    }

    public boolean activateNextExtension(boolean logRecentGaps) {
        if (logRecentGaps) {
            this.convergenceAnalyser.logGapsSince(this.runId, this.convergenceAnalyser.getIterationOffset());
        }
        this.convergenceAnalyser.setIterationOffset(this.convergenceAnalyser.getRegisteredIterations());
        boolean solutionSchemeChanged = true;
        if (this.solutionScheme.isPointQueue()) {
            if (this.solutionScheme.equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC)) {
                this.solutionScheme = StaticLtmLoadingScheme.POINT_QUEUE_ADVANCED;
                this.initialiseTrackAllNodeTurnFlows();
            } else {
                this.convergenceAnalyser.setMinIterationThreshold(Integer.MAX_VALUE);
                solutionSchemeChanged = false;
            }
        } else {
            LOGGER.warning(String.format("%sNo extensions have yet been implemented for sLTM with physical queues", LoggingUtils.runIdPrefix((long)this.runId)));
            solutionSchemeChanged = false;
        }
        if (solutionSchemeChanged) {
            LOGGER.info(String.format("%sSwitching network loading scheme to %s", LoggingUtils.runIdPrefix((long)this.runId), this.solutionScheme.getValue()));
        }
        return solutionSchemeChanged;
    }

    public StaticLtmSettings getSettings() {
        return this.settings;
    }

    public Mode getSupportedMode() {
        return this.mode;
    }

    public double[] getCurrentInflowsPcuH() {
        return this.inFlowOutflowData.getInflows();
    }

    public double[] getCurrentOutflowsPcuH() {
        return this.inFlowOutflowData.getOutflows();
    }

    public void reset() {
        this.resetIteration();
        this.splittingRateData.reset();
        this.prevIterationFinalSolutionScheme = this.solutionScheme;
    }

    public void resetIteration() {
        this.sendingFlowData.reset();
        this.receivingFlowData.reset();
        this.inFlowOutflowData.reset();
        this.networkLoadingFactorData.reset();
        this.flowAcceptanceGapFunction.reset();
        this.sendingFlowGapFunction.reset();
        this.receivingFlowGapFunction.reset();
        this.convergenceAnalyser.reset();
        this.prevIterationFinalSolutionScheme = this.solutionScheme;
        this.solutionScheme = StaticLtmLoadingScheme.NONE;
    }

    public final double[] getCurrentFlowAcceptanceFactors() {
        return this.networkLoadingFactorData.getCurrentFlowAcceptanceFactors();
    }

    public final SplittingRateData getSplittingRateData() {
        return this.splittingRateData;
    }

    public StaticLtmLoadingScheme getActivatedSolutionScheme() {
        return this.solutionScheme;
    }
}

