/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkTurnFlowUpdateData;
import org.goplanit.assignment.ltm.sltm.consumer.PathFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.PathLinkFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.PathTurnFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.od.path.OdPaths;
import org.goplanit.utils.id.IdGroupingToken;

public class StaticLtmLoadingPath
extends StaticLtmNetworkLoading {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmLoadingPath.class.getCanonicalName());
    private OdPaths odPaths = null;

    private PathFlowUpdateConsumer<?> createPathFlowUpdateConsumer(boolean updateTurnAcceptedFlows, boolean updateSendingFlows, boolean updateOutflows) {
        if (!updateSendingFlows && !updateTurnAcceptedFlows) {
            LOGGER.warning("Network flow updates using paths must either updating link sending flows or turn accepted flows, neither are selected");
            return null;
        }
        if (updateSendingFlows) {
            this.sendingFlowData.reset();
        }
        if (updateOutflows) {
            this.inFlowOutflowData.resetOutflows();
        }
        if (!updateTurnAcceptedFlows) {
            NetworkFlowUpdateData dataConfig = null;
            dataConfig = updateOutflows ? new NetworkFlowUpdateData(this.sendingFlowData, this.inFlowOutflowData, this.networkLoadingFactorData) : new NetworkFlowUpdateData(this.sendingFlowData, this.networkLoadingFactorData);
            return new PathLinkFlowUpdateConsumer(dataConfig, this.odPaths);
        }
        if (updateTurnAcceptedFlows) {
            NetworkTurnFlowUpdateData dataConfig = null;
            if (updateSendingFlows) {
                if (updateOutflows) {
                    LOGGER.warning("Network flow updates using paths cannot update turn accepted flows and outflows, this is not yet supported");
                    return null;
                }
                dataConfig = new NetworkTurnFlowUpdateData(this.isTrackAllNodeTurnFlows(), this.sendingFlowData, this.splittingRateData, this.networkLoadingFactorData);
            } else {
                dataConfig = new NetworkTurnFlowUpdateData(this.isTrackAllNodeTurnFlows(), this.splittingRateData, this.networkLoadingFactorData);
            }
            return new PathTurnFlowUpdateConsumer(dataConfig, this.odPaths);
        }
        LOGGER.warning("Invalid network flow update requested for path based loading");
        return null;
    }

    @Override
    protected MultiKeyMap<Object, Double> networkLoadingTurnFlowUpdate() {
        boolean updateTurnAcceptedFlows = true;
        boolean updateSendingFlows = !this.isIterativeSendingFlowUpdateActivated();
        boolean updateOutflows = false;
        PathTurnFlowUpdateConsumer pathTurnFlowUpdateConsumer = (PathTurnFlowUpdateConsumer)this.createPathFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlows, updateOutflows);
        this.getOdDemands().forEachNonZeroOdDemand(this.getTransportNetwork().getZoning().getOdZones(), pathTurnFlowUpdateConsumer);
        return pathTurnFlowUpdateConsumer.getAcceptedTurnFlows();
    }

    @Override
    protected void networkLoadingLinkSegmentSendingFlowUpdate() {
        boolean updateTurnAcceptedFlows = false;
        boolean updateOutflows = false;
        boolean updateSendingFlows = true;
        PathLinkFlowUpdateConsumer pathLinkFlowUpdateConsumer = (PathLinkFlowUpdateConsumer)this.createPathFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlows, updateOutflows);
        this.getOdDemands().forEachNonZeroOdDemand(this.getTransportNetwork().getZoning().getOdZones(), pathLinkFlowUpdateConsumer);
    }

    @Override
    protected void networkLoadingLinkSegmentSendingflowOutflowUpdate() {
        boolean updateTurnAcceptedFlows = false;
        boolean updateSendingFlows = true;
        boolean updateOutflows = true;
        PathLinkFlowUpdateConsumer pathLinkFlowUpdateConsumer = (PathLinkFlowUpdateConsumer)this.createPathFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlows, updateOutflows);
        this.getOdDemands().forEachNonZeroOdDemand(this.getTransportNetwork().getZoning().getOdZones(), pathLinkFlowUpdateConsumer);
    }

    @Override
    protected void activateEligibleSplittingRateTrackedNodes() {
    }

    public StaticLtmLoadingPath(IdGroupingToken idToken, long assignmentId, StaticLtmSettings settings) {
        super(idToken, assignmentId, settings);
    }

    public void updateOdPaths(OdPaths odPaths) {
        this.odPaths = odPaths;
    }
}

