/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.BushFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateDataPartial;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;

public abstract class StaticLtmLoadingBushBase<B extends Bush>
extends StaticLtmNetworkLoading {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmLoadingBushBase.class.getCanonicalName());
    private B[] bushes;
    private PasManager pasManager;

    private void executeNetworkLoadingUpdate(BushFlowUpdateConsumer<B> bushFlowUpdateConsumer) {
        for (B bush : this.bushes) {
            if (bush == null) continue;
            bushFlowUpdateConsumer.accept(bush);
        }
    }

    protected abstract BushFlowUpdateConsumer<B> createBushFlowUpdateConsumer(boolean var1, boolean var2, boolean var3);

    @Override
    protected MultiKeyMap<Object, Double> networkLoadingTurnFlowUpdate() {
        boolean updateTurnAcceptedFlows = true;
        boolean updateSendingFlowDuringLoading = !this.isIterativeSendingFlowUpdateActivated();
        boolean updateOutflows = false;
        BushFlowUpdateConsumer<B> bushTurnFlowUpdateConsumer = this.createBushFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlowDuringLoading, updateOutflows);
        this.executeNetworkLoadingUpdate(bushTurnFlowUpdateConsumer);
        return bushTurnFlowUpdateConsumer.getAcceptedTurnFlows();
    }

    @Override
    protected void networkLoadingLinkSegmentSendingFlowUpdate() {
        boolean updateTurnAcceptedFlows = false;
        boolean updateSendingFlowDuringLoading = true;
        boolean updateOutflows = false;
        BushFlowUpdateConsumer<B> bushFlowUpdateConsumer = this.createBushFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlowDuringLoading, updateOutflows);
        this.executeNetworkLoadingUpdate(bushFlowUpdateConsumer);
    }

    @Override
    protected void networkLoadingLinkSegmentSendingflowOutflowUpdate() {
        boolean updateTurnAcceptedFlows = false;
        boolean updateSendingFlow = true;
        boolean updateOutflowFlow = true;
        BushFlowUpdateConsumer<B> bushFlowUpdateConsumer = this.createBushFlowUpdateConsumer(updateTurnAcceptedFlows, updateSendingFlow, updateOutflowFlow);
        this.executeNetworkLoadingUpdate(bushFlowUpdateConsumer);
    }

    @Override
    protected void activateEligibleSplittingRateTrackedNodes() {
        this.pasManager.forEachPas(pas -> this.activateNodeTrackingFor((Pas)pas));
    }

    public StaticLtmLoadingBushBase(IdGroupingToken idToken, long assignmentId, StaticLtmSettings settings) {
        super(idToken, assignmentId, settings);
    }

    public void setBushes(B[] bushes) {
        this.bushes = bushes;
    }

    public void setPasManager(PasManager pasManager) {
        this.pasManager = pasManager;
    }

    public void activateNodeTrackingFor(Pas newPas) {
        if (newPas == null) {
            LOGGER.severe("Provided PAS is null, unable to activate node tracking for alternative segments");
            return;
        }
        if (!this.isTrackAllNodeTurnFlows()) {
            SplittingRateDataPartial pointQueueBasicSplittingRates = (SplittingRateDataPartial)this.getSplittingRateData();
            boolean lowCostSegment = true;
            newPas.forEachVertex(lowCostSegment, v -> {
                if (!pointQueueBasicSplittingRates.isTracked((DirectedVertex)v)) {
                    pointQueueBasicSplittingRates.registerTrackedNode((DirectedVertex)v);
                }
            });
            lowCostSegment = false;
            newPas.forEachVertex(lowCostSegment, v -> {
                if (!pointQueueBasicSplittingRates.isTracked((DirectedVertex)v)) {
                    pointQueueBasicSplittingRates.registerTrackedNode((DirectedVertex)v);
                }
            });
        }
    }
}

