/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.BitSet;
import java.util.TreeSet;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.ojalgo.array.Array1D;

public class SplittingRateDataPartial
implements SplittingRateData {
    private final TreeSet<DirectedVertex> trackedNodes;
    private final BitSet potentiallyBlockingNodes;
    private final MultiKeyMap<Object, Array1D<Double>> splittingRates = new MultiKeyMap();

    private void registerSplittingRates(DirectedVertex potentiallyBlockingNode, EdgeSegment entrySegment) {
        Array1D result = (Array1D)this.splittingRates.get((Object)potentiallyBlockingNode, (Object)entrySegment);
        if (result == null) {
            this.splittingRates.put((Object)potentiallyBlockingNode, (Object)entrySegment, (Object)Array1D.PRIMITIVE64.makeZero((long)potentiallyBlockingNode.getNumberOfExitEdgeSegments()));
        }
    }

    public SplittingRateDataPartial(int numberOfVertices) {
        this.trackedNodes = new TreeSet();
        this.potentiallyBlockingNodes = new BitSet(numberOfVertices);
    }

    public void registerPotentiallyBlockingNode(DirectedVertex potentiallyBlockingNode) {
        int id = (int)potentiallyBlockingNode.getId();
        if (!this.potentiallyBlockingNodes.get(id)) {
            this.potentiallyBlockingNodes.set(id);
            this.registerTrackedNode(potentiallyBlockingNode);
        }
    }

    public void registerTrackedNode(DirectedVertex trackNode) {
        if (!this.trackedNodes.contains(trackNode)) {
            this.trackedNodes.add(trackNode);
            for (EdgeSegment entrySegment : trackNode.getEntryEdgeSegments()) {
                this.registerSplittingRates(trackNode, entrySegment);
            }
        }
    }

    @Override
    public boolean isTracked(DirectedVertex nodeToVerify) {
        return this.trackedNodes.contains(nodeToVerify);
    }

    @Override
    public boolean isPotentiallyBlocking(DirectedVertex nodeToVerify) {
        return this.potentiallyBlockingNodes.get((int)nodeToVerify.getId());
    }

    @Override
    public TreeSet<DirectedVertex> getTrackedNodes() {
        return this.trackedNodes;
    }

    @Override
    public Array1D<Double> getSplittingRates(EdgeSegment entrySegment) {
        return (Array1D)this.splittingRates.get((Object)entrySegment.getDownstreamVertex(), (Object)entrySegment);
    }

    @Override
    public void resetTrackedNodes() {
        this.trackedNodes.clear();
    }

    @Override
    public void resetPotentiallyBlockingNodes() {
        this.potentiallyBlockingNodes.clear();
    }

    @Override
    public void resetSplittingRates() {
        this.splittingRates.clear();
    }
}

