/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.consumer.BushFlowUpdateConsumer;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConnectoidSegment;

public class RootedBushFlowUpdateConsumerImpl<T extends NetworkFlowUpdateData>
implements BushFlowUpdateConsumer<RootedLabelledBush> {
    private static final Logger LOGGER = Logger.getLogger(RootedBushFlowUpdateConsumerImpl.class.getCanonicalName());
    protected T dataConfig;

    private void initialiseRootExitSegmentSendingFlows(RootedLabelledBush bush, MultiKeyMap<Object, Double> bushSendingFlows) {
        Set<CentroidVertex> originVertices = bush.getOriginVertices();
        for (CentroidVertex originVertex : originVertices) {
            double totalOriginsSendingFlow = 0.0;
            for (EdgeSegment originExit : originVertex.getExitEdgeSegments()) {
                if (!bush.containsEdgeSegment(originExit)) continue;
                TreeSet<BushFlowLabel> usedLabels = bush.getFlowCompositionLabels(originExit);
                for (BushFlowLabel usedLabel : usedLabels) {
                    double sendingFlow = bush.getSendingFlowPcuH(originExit, usedLabel);
                    bushSendingFlows.put((Object)originExit, (Object)usedLabel, (Object)sendingFlow);
                    totalOriginsSendingFlow += sendingFlow;
                }
            }
            if (!Precision.notEqual((double)totalOriginsSendingFlow, (double)bush.getOriginDemandPcuH(originVertex))) continue;
            LOGGER.severe(String.format("bush specific origin's (%s) travel demand (%.2f pcu/h) not equal to total flow (%.2f pcu/h) placed on bush root, this shouldn't happen", originVertex.getParent().getParentZone().getXmlId(), bush.getOriginDemandPcuH(originVertex), totalOriginsSendingFlow));
        }
    }

    protected void applyAcceptedTurnFlowUpdate(EdgeSegment prevSegment, BushFlowLabel prevLabel, EdgeSegment currentSegment, BushFlowLabel currLabel, double turnAcceptedFlowPcuH) {
    }

    public RootedBushFlowUpdateConsumerImpl(T dataConfig) {
        this.dataConfig = dataConfig;
    }

    @Override
    public void accept(RootedLabelledBush bush) {
        MultiKeyMap bushSendingFlows = new MultiKeyMap();
        Iterator<? extends DirectedVertex> vertexIter = bush.getTopologicalIterator(true);
        if (vertexIter == null) {
            LOGGER.severe(String.format("Topologically sorted bush not available, this shouldn't happen, skip", new Object[0]));
            return;
        }
        DirectedVertex currVertex = vertexIter.next();
        this.initialiseRootExitSegmentSendingFlows(bush, (MultiKeyMap<Object, Double>)bushSendingFlows);
        while (vertexIter.hasNext()) {
            currVertex = vertexIter.next();
            for (EdgeSegment entrySegment : currVertex.getEntryEdgeSegments()) {
                if (!bush.containsEdgeSegment(entrySegment)) continue;
                int entrySegmentId = (int)entrySegment.getId();
                TreeSet<BushFlowLabel> usedLabels = bush.getFlowCompositionLabels(entrySegment);
                if (usedLabels == null) {
                    LOGGER.severe(String.format("Edge segment %s on bush, but no flow labels present, this shouldn't happen", entrySegment.getXmlId()));
                    continue;
                }
                double totalEntryAcceptedFlow = 0.0;
                double totalExitAcceptedFlow = 0.0;
                for (BushFlowLabel entrylabel : usedLabels) {
                    MultiKeyMap<Object, Double> splittingRates;
                    Double bushLinkLabelSendingFlow = (Double)bushSendingFlows.get((Object)entrySegment, (Object)entrylabel);
                    if (bushLinkLabelSendingFlow == null) {
                        LOGGER.severe(String.format("No link sending flow found for segment %s and label %d, this shouldn't happen", entrySegment.getXmlId(), entrylabel.getLabelId()));
                        continue;
                    }
                    double alpha = ((NetworkFlowUpdateData)this.dataConfig).flowAcceptanceFactors[entrySegmentId];
                    double bushEntryAcceptedFlow = bushLinkLabelSendingFlow * alpha;
                    totalEntryAcceptedFlow += bushEntryAcceptedFlow;
                    if (((NetworkFlowUpdateData)this.dataConfig).isSendingflowsUpdate()) {
                        int n = entrySegmentId;
                        ((NetworkFlowUpdateData)this.dataConfig).sendingFlows[n] = ((NetworkFlowUpdateData)this.dataConfig).sendingFlows[n] + bushLinkLabelSendingFlow;
                    }
                    if (((NetworkFlowUpdateData)this.dataConfig).isOutflowsUpdate()) {
                        int n = entrySegmentId;
                        ((NetworkFlowUpdateData)this.dataConfig).outFlows[n] = ((NetworkFlowUpdateData)this.dataConfig).outFlows[n] + bushEntryAcceptedFlow;
                    }
                    if ((splittingRates = bush.getSplittingRates(entrySegment, entrylabel)) == null || splittingRates.isEmpty()) continue;
                    for (EdgeSegment exitSegment : currVertex.getExitEdgeSegments()) {
                        if (!bush.containsEdgeSegment(exitSegment)) continue;
                        TreeSet<BushFlowLabel> exitLabels = bush.getFlowCompositionLabels(exitSegment);
                        if (exitLabels == null) {
                            LOGGER.severe(String.format("Edge segment %s on bush, but no flow labels present, this shouldn't happen", exitSegment.getXmlId()));
                            continue;
                        }
                        for (BushFlowLabel exitLabel : exitLabels) {
                            Double splittingRate = (Double)splittingRates.get((Object)exitSegment, (Object)exitLabel);
                            if (splittingRate == null || !(splittingRate > 0.0)) continue;
                            double turnAcceptedFlow = bushEntryAcceptedFlow * splittingRate;
                            totalExitAcceptedFlow += turnAcceptedFlow;
                            Double exitLabelFlowToUpdate = (Double)bushSendingFlows.get((Object)exitSegment, (Object)exitLabel);
                            exitLabelFlowToUpdate = exitLabelFlowToUpdate == null ? Double.valueOf(turnAcceptedFlow) : Double.valueOf(exitLabelFlowToUpdate + turnAcceptedFlow);
                            bushSendingFlows.put((Object)exitSegment, (Object)exitLabel, (Object)exitLabelFlowToUpdate);
                            this.applyAcceptedTurnFlowUpdate(entrySegment, entrylabel, exitSegment, exitLabel, turnAcceptedFlow);
                        }
                    }
                }
                if (!Precision.notEqual((double)totalEntryAcceptedFlow, (double)totalExitAcceptedFlow) || entrySegment instanceof ConnectoidSegment) continue;
                LOGGER.severe(String.format("Accepted (labelled) out flow %.10f on edge segment (%s) not equal to flow (%.10f) assigned to (labelled) turns, this shouldn't happen", totalEntryAcceptedFlow, entrySegment.getXmlId(), totalExitAcceptedFlow));
            }
        }
    }
}

