/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkTurnFlowUpdateData;
import org.goplanit.assignment.ltm.sltm.consumer.PathFlowUpdateConsumer;
import org.goplanit.od.path.OdPaths;
import org.goplanit.utils.graph.directed.EdgeSegment;

public class PathTurnFlowUpdateConsumer
extends PathFlowUpdateConsumer<NetworkTurnFlowUpdateData> {
    private static final Logger LOGGER = Logger.getLogger(PathTurnFlowUpdateConsumer.class.getCanonicalName());

    @Override
    protected double applySingleFlowUpdate(EdgeSegment prevSegment, EdgeSegment currentSegment, double turnSendingFlowPcuH) {
        if (((NetworkTurnFlowUpdateData)this.dataConfig).trackAllNodeTurnFlows || ((NetworkTurnFlowUpdateData)this.dataConfig).splittingRateData.isTracked(currentSegment.getUpstreamVertex())) {
            int prevSegmentId = (int)prevSegment.getId();
            if (((NetworkTurnFlowUpdateData)this.dataConfig).isSendingflowsUpdate()) {
                int n = prevSegmentId;
                ((NetworkTurnFlowUpdateData)this.dataConfig).sendingFlows[n] = ((NetworkTurnFlowUpdateData)this.dataConfig).sendingFlows[n] + turnSendingFlowPcuH;
            }
            double acceptedTurnFlowPcuH = turnSendingFlowPcuH * ((NetworkTurnFlowUpdateData)this.dataConfig).flowAcceptanceFactors[prevSegmentId];
            ((NetworkTurnFlowUpdateData)this.dataConfig).addToAcceptedTurnFlows(prevSegment, currentSegment, acceptedTurnFlowPcuH);
            if (((NetworkTurnFlowUpdateData)this.dataConfig).isOutflowsUpdate()) {
                int n = prevSegmentId;
                ((NetworkTurnFlowUpdateData)this.dataConfig).outFlows[n] = ((NetworkTurnFlowUpdateData)this.dataConfig).outFlows[n] + acceptedTurnFlowPcuH;
            }
            return acceptedTurnFlowPcuH;
        }
        return turnSendingFlowPcuH;
    }

    @Override
    protected void applyPathFinalSegmentFlowUpdate(EdgeSegment lastEdgeSegment, double acceptedPathFlowRate) {
    }

    public PathTurnFlowUpdateConsumer(NetworkTurnFlowUpdateData dataConfig, OdPaths odPaths) {
        super(dataConfig, odPaths);
    }

    public MultiKeyMap<Object, Double> getAcceptedTurnFlows() {
        return ((NetworkTurnFlowUpdateData)this.dataConfig).getAcceptedTurnFlows();
    }
}

