/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.od.path.OdPaths;
import org.goplanit.utils.functionalinterface.TriConsumer;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.path.ManagedDirectedPath;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;

public abstract class PathFlowUpdateConsumer<T extends NetworkFlowUpdateData>
implements TriConsumer<OdZone, OdZone, Double> {
    private static final Logger LOGGER = Logger.getLogger(PathFlowUpdateConsumer.class.getCanonicalName());
    protected T dataConfig;
    private final OdPaths odPaths;

    protected abstract double applySingleFlowUpdate(EdgeSegment var1, EdgeSegment var2, double var3);

    protected abstract void applyPathFinalSegmentFlowUpdate(EdgeSegment var1, double var2);

    public PathFlowUpdateConsumer(T dataConfig, OdPaths odPaths) {
        this.dataConfig = dataConfig;
        this.odPaths = odPaths;
    }

    public void accept(OdZone origin, OdZone destination, Double odDemand) {
        ManagedDirectedPath odPath = (ManagedDirectedPath)this.odPaths.getValue((Zone)origin, (Zone)destination);
        double acceptedPathFlowRate = odDemand;
        if (odPath == null || odPath.isEmpty()) {
            LOGGER.warning(String.format("IGNORE: encountered empty path %s", odPath == null ? "" : odPath.getXmlId()));
            return;
        }
        Iterator edgeSegmentIter = odPath.iterator();
        EdgeSegment previousEdgeSegment = (EdgeSegment)edgeSegmentIter.next();
        EdgeSegment currEdgeSegment = null;
        while (edgeSegmentIter.hasNext()) {
            currEdgeSegment = (EdgeSegment)edgeSegmentIter.next();
            acceptedPathFlowRate = this.applySingleFlowUpdate(previousEdgeSegment, currEdgeSegment, acceptedPathFlowRate);
            previousEdgeSegment = currEdgeSegment;
        }
        this.applyPathFinalSegmentFlowUpdate(currEdgeSegment, acceptedPathFlowRate);
    }
}

