/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.algorithms.nodemodel.TampereNodeModel;
import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;

public class NMRUpdateExitLinkInflowsConsumer
implements ApplyToNodeModelResult {
    private double[] inFlowsToUpdate;

    public NMRUpdateExitLinkInflowsConsumer(double[] inFlowsToUpdate) {
        this.inFlowsToUpdate = inFlowsToUpdate;
    }

    @Override
    public void acceptNonBlockingLinkBasedResult(DirectedVertex node, double[] sendingFlows) {
        int segmentId = -1;
        for (EdgeSegment exitLinkSegment : node.getExitEdgeSegments()) {
            segmentId = (int)exitLinkSegment.getId();
            this.inFlowsToUpdate[segmentId] = sendingFlows[segmentId];
        }
    }

    @Override
    public void acceptTurnBasedResult(DirectedVertex node, Array1D<Double> flowAcceptanceFactors, NodeModel nodeModel) {
        Array2D<Double> turnSendingFlows = ((TampereNodeModel)nodeModel).getInputs().getTurnSendingFlows();
        int entryIndex = 0;
        while ((long)entryIndex < flowAcceptanceFactors.length) {
            double alpha = (Double)flowAcceptanceFactors.get(entryIndex);
            if (Precision.smaller((double)alpha, (double)1.0)) {
                turnSendingFlows.modifyRow((long)entryIndex, PrimitiveFunction.MULTIPLY.by(alpha));
            }
            ++entryIndex;
        }
        int exitIndex = 0;
        for (EdgeSegment exitLinkSegment : node.getExitEdgeSegments()) {
            this.inFlowsToUpdate[(int)exitLinkSegment.getId()] = (Double)turnSendingFlows.aggregateColumn((long)exitIndex++, Aggregator.SUM);
        }
    }
}

