/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.algorithms.nodemodel.TampereNodeModel;
import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.aggregator.Aggregator;

public class NMRUpdateEntryLinksOutflowConsumer
implements ApplyToNodeModelResult {
    private final double[] outflowsToPopulate;

    public NMRUpdateEntryLinksOutflowConsumer(double[] outflowsToPopulate) {
        this.outflowsToPopulate = outflowsToPopulate;
    }

    @Override
    public void acceptNonBlockingLinkBasedResult(DirectedVertex node, double[] linkSegmentSendingFlows) {
        int linkSegmentId = 0;
        for (EdgeSegment entryLinkSegment : node.getEntryEdgeSegments()) {
            linkSegmentId = (int)entryLinkSegment.getId();
            this.outflowsToPopulate[linkSegmentId] = linkSegmentSendingFlows[linkSegmentId];
        }
    }

    @Override
    public void acceptTurnBasedResult(DirectedVertex node, Array1D<Double> flowAcceptanceFactor, NodeModel nodeModel) {
        Array2D<Double> turnSendingFlows = ((TampereNodeModel)nodeModel).getInputs().getTurnSendingFlows();
        int entryIndex = 0;
        int linkSegmentId = 0;
        for (EdgeSegment entryLinkSegment : node.getEntryEdgeSegments()) {
            double acceptedOutflow;
            linkSegmentId = (int)entryLinkSegment.getId();
            double sendingFlow = (Double)turnSendingFlows.aggregateRow((long)entryIndex, Aggregator.SUM);
            this.outflowsToPopulate[linkSegmentId] = acceptedOutflow = sendingFlow * (Double)flowAcceptanceFactor.get(entryIndex);
            ++entryIndex;
        }
    }
}

