/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.Iterator;
import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.algorithms.nodemodel.TampereNodeModel;
import org.goplanit.assignment.ltm.sltm.consumer.ApplyToNodeModelResult;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.ojalgo.array.Array1D;

public class NMRCollectMostRestrictingTurnConsumer
implements ApplyToNodeModelResult {
    private EdgeSegment mostRestrictingOutSegment = null;
    private EdgeSegment entrySegment;

    public NMRCollectMostRestrictingTurnConsumer(EdgeSegment entrySegment) {
        this.entrySegment = entrySegment;
    }

    @Override
    public void acceptNonBlockingLinkBasedResult(DirectedVertex node, double[] sendingFlows) {
    }

    @Override
    public void acceptTurnBasedResult(DirectedVertex node, Array1D<Double> flowAcceptanceFactors, NodeModel nodeModel) {
        Iterator iter = node.getEntryEdgeSegments().iterator();
        int index = 0;
        while (iter.hasNext() && !((EdgeSegment)iter.next()).idEquals((Object)this.entrySegment)) {
            ++index;
        }
        Integer outSegmentIndex = ((TampereNodeModel)nodeModel).getMostRestrictedOutLinkByInLink().get(index);
        if (outSegmentIndex == null) {
            return;
        }
        iter = node.getExitEdgeSegments().iterator();
        index = 0;
        while (iter.hasNext()) {
            EdgeSegment outSegment = (EdgeSegment)iter.next();
            if (index++ != outSegmentIndex) continue;
            this.mostRestrictingOutSegment = outSegment;
            break;
        }
    }

    public boolean hasMostRestrictingOutSegment() {
        return this.mostRestrictingOutSegment != null;
    }

    public EdgeSegment getMostRestrictingOutSegment() {
        return this.mostRestrictingOutSegment;
    }
}

