/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.conjugate;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestBushGeneralised;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.StaticLtmBushStrategyBase;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.conjugate.ConjugateDestinationBush;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingBushConjugate;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ConjugateMacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNode;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class StaticLtmStrategyConjugateBush
extends StaticLtmBushStrategyBase<ConjugateDestinationBush> {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmStrategyConjugateBush.class.getCanonicalName());
    private final ConjugateVirtualNetwork conjugateVirtualNetwork;
    private final ConjugateMacroscopicNetworkLayer conjugateNetworkLayer;

    public StaticLtmStrategyConjugateBush(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
        IdGroupingToken token = IdGenerator.createIdGroupingToken((String)("conjugate for network " + this.getInfrastructureNetwork().getId()));
        this.conjugateVirtualNetwork = transportModelNetwork.getZoning().getVirtualNetwork().createConjugate(token);
        this.conjugateNetworkLayer = ((MacroscopicNetworkLayer)this.getInfrastructureNetwork().getLayerByMode((Mode)this.getInfrastructureNetwork().getModes().getFirst())).createConjugate(token, this.conjugateVirtualNetwork);
    }

    protected ConjugateDestinationBush[] createEmptyBushes() {
        Map centroid2ConjugateNodeMapping = this.conjugateVirtualNetwork.createCentroidToConjugateNodeMapping();
        Zoning zoning = this.getTransportNetwork().getZoning();
        ConjugateDestinationBush[] conjugateBushes = new ConjugateDestinationBush[(int)zoning.getNumberOfCentroids()];
        OdDemands odDemands = this.getOdDemands();
        block0: for (OdZone destination : zoning.getOdZones()) {
            ConjugateDestinationBush bush = null;
            for (OdZone origin : zoning.getOdZones()) {
                Double currOdDemand;
                if (destination.idEquals((Object)origin) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0) || bush != null) continue;
                CentroidVertex destinationCentroidVertex = this.findCentroidVertex(destination);
                ConjugateConnectoidNode rootConjugateConnectoidNode = (ConjugateConnectoidNode)centroid2ConjugateNodeMapping.get(destination.getCentroid());
                conjugateBushes[(int)destination.getOdZoneId()] = bush = new ConjugateDestinationBush(this.conjugateNetworkLayer.getLayerIdGroupingToken(), destinationCentroidVertex, rootConjugateConnectoidNode, this.conjugateNetworkLayer.getConjugateLinkSegments().size() + this.conjugateVirtualNetwork.getConjugateConnectoidEdgeSegments().size());
                continue block0;
            }
        }
        return conjugateBushes;
    }

    @Override
    protected void initialiseBush(ConjugateDestinationBush bush, Zoning zoning, OdDemands odDemands, ShortestBushGeneralised shortestBushAlgorithm) {
        Map centroid2ConjugateNodeMapping = this.conjugateVirtualNetwork.createCentroidToConjugateNodeMapping();
        CentroidVertex destinationCentroidVertex = bush.getRootZoneVertex();
        Zone destination = destinationCentroidVertex.getParent().getParentZone();
        Object allToOneResult = null;
        for (OdZone origin : zoning.getOdZones()) {
            Double currOdDemand;
            if (!origin.idEquals((Object)destinationCentroidVertex) && (currOdDemand = (Double)odDemands.getValue((Zone)origin, destination)) != null && !(currOdDemand > 0.0)) continue;
        }
    }

    @Override
    protected PasFlowShiftExecutor createPasFlowShiftExecutor(Pas pas, StaticLtmSettings settings) {
        return null;
    }

    @Override
    protected StaticLtmLoadingBushConjugate createNetworkLoading() {
        return new StaticLtmLoadingBushConjugate(this.getIdGroupingToken(), this.getAssignmentId(), this.getSettings());
    }

    @Override
    protected StaticLtmLoadingBushConjugate getLoading() {
        return (StaticLtmLoadingBushConjugate)super.getLoading();
    }

    @Override
    protected Collection<Pas> updateBushPass(double[] linkSegmentCosts) throws PlanItException {
        return null;
    }

    @Override
    public String getDescription() {
        return "Conjugate destination-based Bush";
    }
}

