/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.conjugate;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.RootedBush;
import org.goplanit.assignment.ltm.sltm.conjugate.ConjugateBushTurnData;
import org.goplanit.graph.directed.acyclic.ConjugateACyclicSubGraphImpl;
import org.goplanit.utils.graph.directed.ConjugateDirectedEdge;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.graph.directed.ConjugateEdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ConjugateACyclicSubGraph;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.ConjugateNode;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNode;

public class ConjugateDestinationBush
extends RootedBush<ConjugateDirectedVertex, ConjugateEdgeSegment> {
    private static final Logger LOGGER = Logger.getLogger(ConjugateDestinationBush.class.getCanonicalName());
    protected final CentroidVertex destination;
    protected final ConjugateBushTurnData bushData;

    private double determineSubPathSendingFlow(double subPathSendingFlow, int index, ConjugateEdgeSegment[] subPathArray) {
        if (index < subPathArray.length && Precision.positive((double)subPathSendingFlow)) {
            ConjugateEdgeSegment turnSegment = subPathArray[index];
            double splittingRate = this.bushData.getSplittingRate(turnSegment);
            if (splittingRate > 0.0) {
                return this.determineSubPathSendingFlow(subPathSendingFlow *= splittingRate, ++index, subPathArray);
            }
            return 0.0;
        }
        return subPathSendingFlow;
    }

    protected ConjugateACyclicSubGraph getDag() {
        return (ConjugateACyclicSubGraph)super.getDag();
    }

    public ConjugateDestinationBush(IdGroupingToken idToken, CentroidVertex destination, ConjugateConnectoidNode rootVertex, int maxSubGraphTurns) {
        super(idToken, (DirectedVertex)rootVertex, true, new ConjugateACyclicSubGraphImpl(idToken, (ConjugateDirectedVertex)rootVertex, true, maxSubGraphTurns));
        this.bushData = new ConjugateBushTurnData();
        this.destination = destination;
    }

    public ConjugateDestinationBush(ConjugateDestinationBush bush, boolean deepCopy) {
        super(bush, deepCopy);
        this.destination = bush.destination;
        this.bushData = bush.bushData.shallowClone();
    }

    @Override
    public MinMaxPathResult computeMinMaxShortestPaths(double[] conjugatelinkSegmentCosts, int totalConjugateVertices) {
        return null;
    }

    public Iterator<ConjugateDirectedVertex> getTopologicalIterator(boolean originDestinationDirection) {
        return null;
    }

    @Override
    public ShortestSearchType getShortestSearchType() {
        return null;
    }

    @Override
    public ConjugateDestinationBush shallowClone() {
        return new ConjugateDestinationBush(this, false);
    }

    @Override
    public ConjugateDestinationBush deepClone() {
        return new ConjugateDestinationBush(this, true);
    }

    public ConjugateEdgeSegment determineIntroduceCycle(ConjugateEdgeSegment[] alternative) {
        return null;
    }

    public double addTurnSendingFlow(ConjugateEdgeSegment turn, double addFlowPcuH) {
        return this.addTurnSendingFlow(turn, addFlowPcuH, false);
    }

    public double addTurnSendingFlow(ConjugateEdgeSegment turn, double addFlowPcuH, boolean allowTurnRemoval) {
        if (addFlowPcuH > 0.0 && !this.containsTurnSegment(turn)) {
            if (this.containsTurnSegment(turn.getOppositeDirectionSegment())) {
                LOGGER.warning(String.format("Trying to add turn flow on bush where the opposite direction is already part of the bush, this break acyclicity", new Object[0]));
            }
            this.getDag().addEdgeSegment((EdgeSegment)turn);
            this.requireTopologicalSortUpdate = true;
        }
        return this.bushData.addTurnSendingFlow(turn, addFlowPcuH, allowTurnRemoval);
    }

    public double getTurnSendingFlow(ConjugateEdgeSegment turn) {
        return this.bushData.getTurnSendingFlowPcuH(turn);
    }

    public double getSendingFlowPcuH(ConjugateNode conjugateNode) {
        return this.bushData.getTotalSendingFlowFromPcuH((ConjugateDirectedVertex)conjugateNode);
    }

    public boolean containsTurnSendingFlow(ConjugateEdgeSegment turn) {
        return this.bushData.getTurnSendingFlowPcuH(turn) > 0.0;
    }

    public double getSplittingRate(ConjugateEdgeSegment turn) {
        return this.bushData.getSplittingRate(turn);
    }

    public double[] getSplittingRates(ConjugateDirectedVertex conjugateVertex) {
        return this.bushData.getSplittingRates(conjugateVertex);
    }

    public void removeTurn(ConjugateEdgeSegment turn) {
        this.bushData.removeTurn(turn);
        this.getDag().removeEdgeSegment((EdgeSegment)turn);
        this.requireTopologicalSortUpdate = true;
    }

    public boolean containsTurnSegment(ConjugateEdgeSegment turnSegment) {
        return this.getDag().containsEdgeSegment((EdgeSegment)turnSegment);
    }

    public boolean containsAnyTurnSegmentOf(ConjugateDirectedEdge conjugateEdge) {
        for (ConjugateEdgeSegment turnSegment : conjugateEdge.getEdgeSegments()) {
            if (!this.getDag().containsEdgeSegment((EdgeSegment)turnSegment)) continue;
            return true;
        }
        return false;
    }

    public Pair<DirectedVertex, Map<DirectedVertex, EdgeSegment>> findBushAlternativeSubpath(DirectedVertex referenceVertex, short[] alternativeSubpathVertexLabels) {
        return null;
    }

    public double computeSubPathSendingFlow(DirectedVertex startVertex, DirectedVertex endVertex, Map<DirectedVertex, EdgeSegment> subPathMap) {
        return Double.NEGATIVE_INFINITY;
    }

    public double computeSubPathAcceptedFlow(DirectedVertex startVertex, DirectedVertex endVertex, EdgeSegment[] subPathArray, double[] linkSegmentAcceptanceFactors) {
        return Double.NEGATIVE_INFINITY;
    }

    public double determineSubPathSendingFlow(EdgeSegment entrySegment, EdgeSegment[] subPathArray) {
        return Double.NEGATIVE_INFINITY;
    }

    public TreeMap<BushFlowLabel, Double> determineProportionalFlowCompositionRates(EdgeSegment edgeSegment, Set<BushFlowLabel> pasFlowCompositionLabels) {
        return null;
    }

    @Override
    public void syncToNetworkFlows(double[] originalNetworkFlowAcceptanceFactors) {
        Iterator<ConjugateDirectedVertex> conjugateVertexIter = this.getTopologicalIterator(true);
        if (conjugateVertexIter == null) {
            LOGGER.severe(String.format("Topologically sorted vertices on bush not available, this shouldn't happen, skip turn flow update", new Object[0]));
            return;
        }
        ConjugateDirectedVertex currConjugateVertex = conjugateVertexIter.next();
        boolean AllowTurnRemoval = false;
        while (conjugateVertexIter.hasNext()) {
            currConjugateVertex = conjugateVertexIter.next();
            double conjugateVertexAcceptedFlow = this.bushData.getTotalAcceptedFlowToPcuH(currConjugateVertex, originalNetworkFlowAcceptanceFactors);
            double[] splittingRates = this.getSplittingRates(currConjugateVertex);
            int index = -1;
            for (ConjugateEdgeSegment turnSegment : currConjugateVertex.getExitEdgeSegments()) {
                double currTurnSplittingRate;
                ++index;
                if (!this.containsTurnSegment(turnSegment) || !((currTurnSplittingRate = splittingRates[index]) > 0.0)) continue;
                double bushTurnLabeledAcceptedFlow = conjugateVertexAcceptedFlow * currTurnSplittingRate;
                this.bushData.setTurnSendingFlow(turnSegment, bushTurnLabeledAcceptedFlow, false);
            }
        }
    }

    public boolean isEmpty() {
        return this.bushData.hasTurnFlows();
    }

    @Override
    public CentroidVertex getRootZoneVertex() {
        return this.destination;
    }
}

