/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.conjugate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.graph.directed.ConjugateEdgeSegment;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;

public class ConjugateBushTurnData {
    private static final Logger LOGGER = Logger.getLogger(ConjugateBushTurnData.class.getCanonicalName());
    private final Map<ConjugateEdgeSegment, Double> turnSendingFlows;

    private void registerTurnSendingFlow(ConjugateEdgeSegment turn, double turnSendingFlow) {
        this.turnSendingFlows.put(turn, turnSendingFlow);
    }

    ConjugateBushTurnData() {
        this.turnSendingFlows = new HashMap<ConjugateEdgeSegment, Double>();
    }

    public ConjugateBushTurnData(ConjugateBushTurnData bushTurnData) {
        this.turnSendingFlows = new HashMap<ConjugateEdgeSegment, Double>(bushTurnData.turnSendingFlows);
    }

    public boolean setTurnSendingFlow(ConjugateEdgeSegment turnSegment, double turnSendingFlow, boolean allowTurnRemoval) {
        if (Double.isNaN(turnSendingFlow)) {
            LOGGER.severe("Turn sending flow is NAN, shouldn't happen - consider identifying issue as turn flow cannot be updated properly, reset to 0.0 flow");
            turnSendingFlow = 0.0;
        } else if (!Precision.positive((double)turnSendingFlow)) {
            if (allowTurnRemoval) {
                this.removeTurn(turnSegment);
                return false;
            }
            if (turnSendingFlow < 0.0) {
                Pair originalEdgeSegments = turnSegment.getOriginalAdjcentEdgeSegments();
                LOGGER.warning(String.format("** Turn (%s to %s) sending flow negative (%.9f), this is not allowed, reset to 0.0 ", ((EdgeSegment)originalEdgeSegments.first()).getXmlId(), ((EdgeSegment)originalEdgeSegments.second()).getXmlId(), turnSendingFlow));
                turnSendingFlow = 0.0;
                return false;
            }
        }
        this.registerTurnSendingFlow(turnSegment, turnSendingFlow);
        return true;
    }

    public double addTurnSendingFlow(ConjugateEdgeSegment turnSegment, double flowPcuH) {
        return this.addTurnSendingFlow(turnSegment, flowPcuH, false);
    }

    public double addTurnSendingFlow(ConjugateEdgeSegment turnSegment, double flowPcuH, boolean allowTurnRemoval) {
        Double newSendingFlow = flowPcuH + this.getTurnSendingFlowPcuH(turnSegment);
        boolean hasRemainingFlow = this.setTurnSendingFlow(turnSegment, newSendingFlow, allowTurnRemoval);
        newSendingFlow = hasRemainingFlow ? newSendingFlow : 0.0;
        return newSendingFlow;
    }

    public void removeTurn(ConjugateEdgeSegment turnSegment) {
        this.turnSendingFlows.remove(turnSegment);
    }

    public double getTurnSendingFlowPcuH(ConjugateEdgeSegment turnSegment) {
        Double existingSendingFlow = this.turnSendingFlows.get(turnSegment);
        if (existingSendingFlow != null) {
            return existingSendingFlow;
        }
        return 0.0;
    }

    public double getTotalSendingFlowFromPcuH(ConjugateDirectedVertex node) {
        double totalSendingFlow = 0.0;
        for (ConjugateEdgeSegment turn : node.getExitEdgeSegments()) {
            double s_ab = this.getTurnSendingFlowPcuH(turn);
            totalSendingFlow += s_ab;
        }
        return totalSendingFlow;
    }

    public double getTotalAcceptedFlowToPcuH(ConjugateDirectedVertex node, double[] originalNetworkSegmentFlowAcceptanceFactors) {
        if (!node.hasEntryEdgeSegments()) {
            return this.getTotalSendingFlowFromPcuH(node);
        }
        double totalAcceptedFlow = 0.0;
        for (ConjugateEdgeSegment turn : node.getEntryEdgeSegments()) {
            double s_ab = this.getTurnSendingFlowPcuH(turn);
            EdgeSegment originalEntrySegment = (EdgeSegment)turn.getOriginalAdjcentEdgeSegments().first();
            double v_ab = s_ab * originalNetworkSegmentFlowAcceptanceFactors[(int)originalEntrySegment.getId()];
            totalAcceptedFlow += v_ab;
        }
        return totalAcceptedFlow;
    }

    public boolean containsTurnSendingFlow(ConjugateEdgeSegment turnSegment) {
        return this.getTurnSendingFlowPcuH(turnSegment) > 0.0;
    }

    public double[] getSplittingRates(ConjugateDirectedVertex conjugateVertex) {
        Iterable turns = conjugateVertex.getExitEdgeSegments();
        double[] splittingRates = new double[conjugateVertex.getNumberOfEdges()];
        double totalSendingFlow = 0.0;
        int index = 0;
        for (ConjugateEdgeSegment turn : turns) {
            double s_ab = this.getTurnSendingFlowPcuH(turn);
            splittingRates[index++] = s_ab;
            totalSendingFlow += s_ab;
        }
        ArrayUtils.divideBy((double[])splittingRates, (double)totalSendingFlow, (double)0.0);
        Arrays.copyOf(splittingRates, index);
        return splittingRates;
    }

    public double getSplittingRate(ConjugateEdgeSegment turnSegment) {
        double turnSendingFlow = this.getTurnSendingFlowPcuH(turnSegment);
        if (turnSendingFlow > 0.0) {
            double totalSendingFlow = this.getTotalSendingFlowFromPcuH(turnSegment.getUpstreamVertex());
            if (totalSendingFlow < turnSendingFlow) {
                Pair originalPair = turnSegment.getOriginalAdjcentEdgeSegments();
                LOGGER.severe(String.format("Total sending flow (%.10f) smaller than turn (%s,%s) sending flow (%.10f), this shouldn't happen", totalSendingFlow, ((EdgeSegment)originalPair.first()).getXmlId(), ((EdgeSegment)originalPair.second()).getXmlId(), turnSendingFlow));
            }
            return turnSendingFlow / totalSendingFlow;
        }
        return 0.0;
    }

    public ConjugateBushTurnData shallowClone() {
        return new ConjugateBushTurnData(this);
    }

    public boolean hasTurnFlows() {
        return this.turnSendingFlows.isEmpty();
    }
}

