/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Arrays;
import java.util.Collection;
import org.goplanit.assignment.SimulationData;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;

public class StaticLtmSimulationData
extends SimulationData {
    private double[][] modeLinkSegmentCost;
    private TimePeriod timePeriod;

    public StaticLtmSimulationData(TimePeriod timePeriod, Collection<Mode> supportedModes, long numberOfTotalLinkSegments) {
        this.timePeriod = timePeriod;
        this.modeLinkSegmentCost = new double[supportedModes.size()][(int)numberOfTotalLinkSegments];
    }

    public StaticLtmSimulationData(StaticLtmSimulationData simulationData) {
        super(simulationData);
        if (simulationData.modeLinkSegmentCost.length > 0) {
            this.modeLinkSegmentCost = new double[simulationData.modeLinkSegmentCost.length][simulationData.modeLinkSegmentCost[0].length];
            for (int index = 0; index < simulationData.modeLinkSegmentCost.length; ++index) {
                this.modeLinkSegmentCost[index] = Arrays.copyOf(simulationData.modeLinkSegmentCost[index], simulationData.modeLinkSegmentCost[index].length);
            }
        } else {
            this.modeLinkSegmentCost = null;
        }
    }

    public void setLinkSegmentTravelTimePcuH(Mode theMode, double[] travelTimeCostHour) {
        this.modeLinkSegmentCost[(int)theMode.getId()] = travelTimeCostHour;
    }

    public double[] getLinkSegmentTravelTimePcuH(Mode theMode) {
        return this.modeLinkSegmentCost[(int)theMode.getId()];
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Override
    public StaticLtmSimulationData shallowClone() {
        return new StaticLtmSimulationData(this);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.modeLinkSegmentCost != null && this.modeLinkSegmentCost.length > 0 && this.modeLinkSegmentCost[0] != null) {
            int numLinkSegments = this.modeLinkSegmentCost[0].length;
            this.modeLinkSegmentCost = new double[this.modeLinkSegmentCost.length][numLinkSegments];
        }
    }
}

