/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.lang.reflect.Field;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.StaticLtmType;

public class StaticLtmSettings {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmSettings.class.getCanonicalName());
    private Boolean disableStorageConstraints = null;
    private Boolean detailedLogging = null;
    private StaticLtmType sLtmType = DEFAULT_SLTM_TYPE;
    private Boolean enforceMaxEntropyFlowSolution = ENFORCE_FLOW_PROPORTIONAL_SOLUTION_DEFAULT;
    public static StaticLtmType DEFAULT_SLTM_TYPE = StaticLtmType.DESTINATION_BUSH_BASED;
    public static boolean ENFORCE_FLOW_PROPORTIONAL_SOLUTION_DEFAULT = false;

    public StaticLtmSettings() {
    }

    public StaticLtmSettings(StaticLtmSettings staticLtmSettings) {
        this.sLtmType = staticLtmSettings.sLtmType;
        this.detailedLogging = (boolean)staticLtmSettings.detailedLogging;
        this.disableStorageConstraints = (boolean)staticLtmSettings.disableStorageConstraints;
        this.enforceMaxEntropyFlowSolution = (boolean)staticLtmSettings.enforceMaxEntropyFlowSolution;
    }

    public boolean validate() {
        boolean valid = true;
        Field[] fields = this.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            field.setAccessible(true);
            try {
                if (field.get(this) != null) continue;
                LOGGER.severe(String.format("%s has not been set as part of sLTM network loading settings, this should not happen", field.getName()));
                valid = false;
                continue;
            }
            catch (Exception e) {
                LOGGER.severe(String.format("Unable to collect field %s from class instance %s, this should not happen", field.getName(), this.getClass().getName()));
                e.printStackTrace();
                valid = false;
            }
        }
        return valid;
    }

    public StaticLtmSettings shallowClone() {
        return new StaticLtmSettings(this);
    }

    public Boolean isDisableStorageConstraints() {
        return this.disableStorageConstraints;
    }

    public void setDisableStorageConstraints(Boolean disableStorageConstraints) {
        this.disableStorageConstraints = disableStorageConstraints;
    }

    public Boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    public void setDetailedLogging(Boolean detailedLogging) {
        this.detailedLogging = detailedLogging;
    }

    public Boolean isBushBased() {
        return this.sLtmType != StaticLtmType.PATH_BASED;
    }

    public void setSltmType(StaticLtmType type) {
        this.sLtmType = type;
    }

    public StaticLtmType getSltmType() {
        return this.sLtmType;
    }

    public Boolean isEnforceMaxEntropyFlowSolution() {
        return this.enforceMaxEntropyFlowSolution;
    }

    public void setEnforceMaxEntropyFlowSolution(Boolean enforceMaxEntropyFlowSolution) {
        this.enforceMaxEntropyFlowSolution = enforceMaxEntropyFlowSolution;
    }
}

