/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathDijkstra;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.StaticLtmAssignmentStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingPath;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingScheme;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.od.path.OdPaths;
import org.goplanit.od.path.OdPathsHashed;
import org.goplanit.path.ManagedDirectedPathFactoryImpl;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.path.ManagedDirectedPath;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class StaticLtmPathStrategy
extends StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmPathStrategy.class.getCanonicalName());
    private OdPaths odPaths;

    private OdPaths createOdPaths(double[] currentSegmentCosts) {
        ShortestPathDijkstra shortestPathAlgorithm = new ShortestPathDijkstra(currentSegmentCosts, this.getTransportNetwork().getNumberOfVerticesAllLayers());
        ManagedDirectedPathFactoryImpl pathFactory = new ManagedDirectedPathFactoryImpl(this.getIdGroupingToken());
        OdPathsHashed odPaths = new OdPathsHashed(this.getIdGroupingToken(), this.getTransportNetwork().getZoning().getOdZones());
        Zoning zoning = this.getTransportNetwork().getZoning();
        OdDemands odDemands = this.getOdDemands();
        for (OdZone origin : zoning.getOdZones()) {
            CentroidVertex originVertex = this.findCentroidVertex(origin);
            ShortestPathResult oneToAllResult = shortestPathAlgorithm.executeOneToAll((DirectedVertex)originVertex);
            for (OdZone destination : zoning.getOdZones()) {
                Double currOdDemand;
                if (destination.idEquals((Object)origin) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0)) continue;
                CentroidVertex destinationVertex = this.findCentroidVertex(destination);
                ManagedDirectedPath path = (ManagedDirectedPath)oneToAllResult.createPath(pathFactory, (DirectedVertex)originVertex, (DirectedVertex)destinationVertex);
                if (path == null) {
                    LOGGER.warning(String.format("%sUnable to create path for OD (%s,%s) with non-zero demand (%.2f)", LoggingUtils.runIdPrefix((long)this.getAssignmentId()), origin.getXmlId(), destination.getXmlId(), currOdDemand));
                    continue;
                }
                odPaths.setValue((Zone)origin, (Zone)destination, path);
            }
        }
        return odPaths;
    }

    @Override
    protected StaticLtmLoadingPath createNetworkLoading() {
        return new StaticLtmLoadingPath(this.getIdGroupingToken(), this.getAssignmentId(), this.getSettings());
    }

    @Override
    protected StaticLtmLoadingPath getLoading() {
        return (StaticLtmLoadingPath)super.getLoading();
    }

    public StaticLtmPathStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
    }

    @Override
    public void createInitialSolution(double[] initialLinkSegmentCosts) {
        try {
            this.odPaths = this.createOdPaths(initialLinkSegmentCosts);
            this.getLoading().updateOdPaths(this.odPaths);
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to create paths for initial solution of path-based sLTM %s", this.getAssignmentId()));
        }
    }

    @Override
    public boolean performIteration(Mode theMode, double[] costsToUpdate, int iterationIndex) {
        try {
            this.executeNetworkLoading();
            boolean updateOnlyPotentiallyBlockingNodeCosts = this.getLoading().getActivatedSolutionScheme().equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
            this.executeNetworkCostsUpdate(theMode, updateOnlyPotentiallyBlockingNodeCosts, costsToUpdate);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to complete sLTM iteration");
            if (this.getSettings().isDetailedLogging().booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "Path-based";
    }
}

