/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestBushGeneralised;
import org.goplanit.algorithms.shortest.ShortestBushResult;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.BushInitialiserHelper;
import org.goplanit.assignment.ltm.sltm.OriginBush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftOriginBasedDestLabelledExecutor;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmBushStrategyRootLabelled;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class StaticLtmOriginBushDestLabelledStrategy
extends StaticLtmBushStrategyRootLabelled {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmOriginBushDestLabelledStrategy.class.getCanonicalName());
    private final BushFlowLabel[] destinationLabels;

    private void initialiseBushForDestination(OriginBush originBush, OdZone destination, Double oDDemandPcuH, ACyclicSubGraph odDag) {
        BushFlowLabel currentLabel = this.destinationLabels[(int)destination.getOdZoneId()];
        Iterator vertexIter = odDag.getTopologicalIterator(true);
        DirectedVertex currVertex = (DirectedVertex)vertexIter.next();
        if (!(currVertex instanceof CentroidVertex)) {
            LOGGER.warning("Root vertex is not a centroid vertex, should not happen");
            return;
        }
        BushInitialiserHelper helper = BushInitialiserHelper.create(originBush, odDag, this.pasManager, this.getSettings().isDetailedLogging());
        helper.executeOdBushInitialisation(currVertex, oDDemandPcuH, vertexIter, currentLabel);
    }

    @Override
    protected void initialiseBush(RootedLabelledBush bush, Zoning zoning, OdDemands odDemands, ShortestBushGeneralised shortestBushAlgorithm) {
        CentroidVertex originVertex = ((OriginBush)bush).getOrigin();
        OdZone origin = (OdZone)originVertex.getParent().getParentZone();
        ShortestBushResult shortestBushResult = null;
        for (OdZone destination : zoning.getOdZones()) {
            Double currOdDemand;
            if (destination.idEquals((Object)origin) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0)) continue;
            if (shortestBushResult == null) {
                shortestBushResult = shortestBushAlgorithm.executeOneToAll((DirectedVertex)originVertex);
            }
            ACyclicSubGraph destinationDag = shortestBushResult.createDirectedAcyclicSubGraph(this.getIdGroupingToken(), (DirectedVertex)originVertex, (DirectedVertex)this.findCentroidVertex(destination));
            ((OriginBush)bush).addOriginDemandPcuH(currOdDemand);
            this.initialiseBushForDestination((OriginBush)bush, destination, currOdDemand, destinationDag);
        }
    }

    protected OriginBush[] createEmptyBushes() {
        Zoning zoning = this.getTransportNetwork().getZoning();
        OriginBush[] originBushes = new OriginBush[(int)zoning.getNumberOfCentroids()];
        OdDemands odDemands = this.getOdDemands();
        block0: for (OdZone origin : zoning.getOdZones()) {
            CentroidVertex originVertex = this.findCentroidVertex(origin);
            for (OdZone destination : zoning.getOdZones()) {
                OriginBush bush;
                Double currOdDemand;
                if (destination.idEquals((Object)origin) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0)) continue;
                originBushes[(int)origin.getOdZoneId()] = bush = new OriginBush(this.getIdGroupingToken(), originVertex, this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers());
                continue block0;
            }
        }
        return originBushes;
    }

    @Override
    protected PasFlowShiftExecutor createPasFlowShiftExecutor(Pas pas, StaticLtmSettings settings) {
        return new PasFlowShiftOriginBasedDestLabelledExecutor(pas, settings);
    }

    public StaticLtmOriginBushDestLabelledStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
        this.destinationLabels = new BushFlowLabel[transportModelNetwork.getZoning().getOdZones().size()];
        for (OdZone odZone : transportModelNetwork.getZoning().getOdZones()) {
            this.destinationLabels[(int)odZone.getOdZoneId()] = BushFlowLabel.create(this.getIdGroupingToken(), odZone.getName() != null ? odZone.getName() : (odZone.getXmlId() != null ? odZone.getXmlId() : String.valueOf(odZone.getId())));
        }
    }

    @Override
    public String getDescription() {
        return "Origin-based bush (destination-labelled)";
    }
}

