/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.List;
import java.util.Optional;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.output.adapter.MacroscopicLinkOutputTypeAdapterImpl;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.time.TimePeriod;

public class StaticLtmLinkOutputTypeAdapter
extends MacroscopicLinkOutputTypeAdapterImpl {
    @Override
    protected StaticLtm getAssignment() {
        return (StaticLtm)super.getAssignment();
    }

    private Optional<Double> getCalculatedSpeed(MacroscopicLinkSegment linkSegment, Mode mode) {
        int id = (int)linkSegment.getId();
        double[] modalLinkSegmentsTravelTimeHour = this.getAssignment().getIterationData().getLinkSegmentTravelTimePcuH(mode);
        double travelTimeHour = modalLinkSegmentsTravelTimeHour[id];
        double length = linkSegment.getParentLink().getLengthKm();
        return Optional.of(length / travelTimeHour);
    }

    private Optional<Double> getInFlowPcuHour(MacroscopicLinkSegment linkSegment, Mode mode) {
        return Optional.of(this.getAssignment().getLinkSegmentInflowPcuHour((LinkSegment)linkSegment));
    }

    private Optional<Double> getOutFlowPcuHour(MacroscopicLinkSegment linkSegment, Mode mode) {
        return Optional.of(this.getAssignment().getLinkSegmentOutflowPcuHour((LinkSegment)linkSegment));
    }

    private Optional<Double> getLinkTravelTimeHour(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalLinkSegmentTravelTimes = this.getAssignment().getIterationData().getLinkSegmentTravelTimePcuH(mode);
        return Optional.of(modalLinkSegmentTravelTimes[id]);
    }

    private Optional<Double> getCostTimesFlow(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        return Optional.of(this.getLinkTravelTimeHour(linkSegment, mode).get() * this.getOutFlowPcuHour(linkSegment, mode).get());
    }

    private Optional<Double> getVcRatio(MacroscopicLinkSegment linkSegment) throws PlanItException {
        double totalFlow = 0.0;
        for (Mode mode : List.of(this.getAssignment().getStrategy().getLoading().getSupportedMode())) {
            totalFlow += this.getInFlowPcuHour(linkSegment, mode).get().doubleValue();
        }
        double capacityPerLane = this.getCapacityPerLanePcuHour(linkSegment).get();
        return Optional.of(totalFlow / ((double)linkSegment.getNumberOfLanes() * capacityPerLane));
    }

    public StaticLtmLinkOutputTypeAdapter(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<Boolean> isFlowPositive(MacroscopicLinkSegment linkSegment, Mode mode) {
        return Optional.of(this.getOutFlowPcuHour(linkSegment, mode).get() > 0.0);
    }

    @Override
    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty outputProperty, MacroscopicLinkSegment linkSegment, Mode mode, TimePeriod timePeriod) {
        Optional<Object> value = Optional.empty();
        try {
            value = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            value = super.getLinkSegmentOutputPropertyValue(outputProperty, linkSegment, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            switch (outputProperty.getOutputPropertyType()) {
                case CALCULATED_SPEED: {
                    value = this.getCalculatedSpeed(linkSegment, mode);
                    break;
                }
                case FLOW: {
                    value = this.getOutFlowPcuHour(linkSegment, mode);
                    break;
                }
                case OUTFLOW: {
                    value = this.getOutFlowPcuHour(linkSegment, mode);
                    break;
                }
                case INFLOW: {
                    value = this.getInFlowPcuHour(linkSegment, mode);
                    break;
                }
                case LINK_SEGMENT_COST: {
                    value = this.getLinkTravelTimeHour(linkSegment, mode);
                    break;
                }
                case VC_RATIO: {
                    value = this.getVcRatio(linkSegment);
                    break;
                }
                case COST_TIMES_FLOW: {
                    value = this.getCostTimesFlow(linkSegment, mode);
                    break;
                }
                default: {
                    throw new PlanItException("Tried to find link property of %s which is not applicable for links", new Object[]{outputProperty.getName()});
                }
            }
            if (outputProperty.supportsUnitOverride() && outputProperty.isUnitOverride()) {
                value = StaticLtmLinkOutputTypeAdapter.createConvertedUnitsValue(outputProperty, value);
            }
        }
        catch (PlanItException e) {
            return Optional.of(e.getMessage());
        }
        return value;
    }
}

