/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestBushGeneralised;
import org.goplanit.algorithms.shortest.ShortestBushResult;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.BushInitialiserHelper;
import org.goplanit.assignment.ltm.sltm.DestinationBush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftDestinationBasedExecutor;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmBushStrategyRootLabelled;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;

public class StaticLtmDestinationBushStrategy
extends StaticLtmBushStrategyRootLabelled {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmDestinationBushStrategy.class.getCanonicalName());
    private final BushFlowLabel dummyLabel = BushFlowLabel.create(this.getIdGroupingToken(), "dummy");

    private void initialiseBushForOrigin(DestinationBush destinationBush, CentroidVertex originCentroidVertex, Double oDDemandPcuH, ACyclicSubGraph odDag, BushFlowLabel destinationLabel) {
        boolean descendingIterator = true;
        Iterator vertexIter = odDag.getTopologicalIterator(true, descendingIterator);
        DirectedVertex currVertex = null;
        while (vertexIter.hasNext() && !originCentroidVertex.equals(currVertex)) {
            currVertex = (DirectedVertex)vertexIter.next();
        }
        BushInitialiserHelper helper = BushInitialiserHelper.create(destinationBush, odDag, this.pasManager, this.getSettings().isDetailedLogging());
        helper.executeOdBushInitialisation(currVertex, oDDemandPcuH, vertexIter, destinationLabel);
    }

    @Override
    protected void initialiseBush(RootedLabelledBush bush, Zoning zoning, OdDemands odDemands, ShortestBushGeneralised shortestBushAlgorithm) {
        CentroidVertex destinationVertex = ((DestinationBush)bush).getDestination();
        OdZone destination = (OdZone)destinationVertex.getParent().getParentZone();
        ShortestBushResult allToOneResult = null;
        for (OdZone origin : zoning.getOdZones()) {
            Double currOdDemand;
            if (origin.idEquals((Object)destination) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0)) continue;
            if (allToOneResult == null) {
                allToOneResult = shortestBushAlgorithm.executeAllToOne((DirectedVertex)destinationVertex);
            }
            CentroidVertex originCentroidVertex = this.findCentroidVertex(origin);
            ACyclicSubGraph originDag = allToOneResult.createDirectedAcyclicSubGraph(this.getIdGroupingToken(), (DirectedVertex)this.findCentroidVertex(origin), (DirectedVertex)destinationVertex);
            if (originDag.isEmpty()) {
                LOGGER.severe(String.format("Unable to create bush connection(s) from origin (%s) to destination %s", origin.getXmlId(), destination.getXmlId()));
                continue;
            }
            bush.addOriginDemandPcuH(originCentroidVertex, currOdDemand);
            this.initialiseBushForOrigin((DestinationBush)bush, originCentroidVertex, currOdDemand, originDag, this.dummyLabel);
        }
    }

    protected DestinationBush[] createEmptyBushes() {
        Zoning zoning = this.getTransportNetwork().getZoning();
        DestinationBush[] destinationBushes = new DestinationBush[(int)zoning.getNumberOfCentroids()];
        OdDemands odDemands = this.getOdDemands();
        block0: for (OdZone destination : zoning.getOdZones()) {
            CentroidVertex destinationVertex = this.findCentroidVertex(destination);
            for (OdZone origin : zoning.getOdZones()) {
                DestinationBush bush;
                Double currOdDemand;
                if (destination.idEquals((Object)origin) || (currOdDemand = (Double)odDemands.getValue((Zone)origin, (Zone)destination)) == null || !(currOdDemand > 0.0)) continue;
                destinationBushes[(int)destination.getOdZoneId()] = bush = new DestinationBush(this.getIdGroupingToken(), destinationVertex, this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers());
                continue block0;
            }
        }
        return destinationBushes;
    }

    @Override
    protected PasFlowShiftExecutor createPasFlowShiftExecutor(Pas pas, StaticLtmSettings settings) {
        return new PasFlowShiftDestinationBasedExecutor(pas, settings, this.dummyLabel);
    }

    public StaticLtmDestinationBushStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
    }

    @Override
    public String getDescription() {
        return "Destination-based Bush (single dummy label)";
    }
}

