/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestPathDijkstra;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmBushStrategyBase;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingBushRooted;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;

public abstract class StaticLtmBushStrategyRootLabelled
extends StaticLtmBushStrategyBase<RootedLabelledBush> {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmBushStrategyRootLabelled.class.getCanonicalName());

    private boolean extendBushWithSuitableExistingPas(RootedLabelledBush bush, DirectedVertex mergeVertex, double reducedCost) {
        boolean bushFlowThroughMergeVertex = false;
        for (EdgeSegment entrySegment : mergeVertex.getEntryEdgeSegments()) {
            for (EdgeSegment exitSegment : mergeVertex.getExitEdgeSegments()) {
                if (!bush.containsTurnSendingFlow(entrySegment, exitSegment)) continue;
                bushFlowThroughMergeVertex = true;
                break;
            }
            if (!bushFlowThroughMergeVertex) continue;
            break;
        }
        if (!bushFlowThroughMergeVertex) {
            LOGGER.warning(String.format("Explored vertex %s for existing PAS match even though bush has no flow passing through it. This should not happen", mergeVertex.getXmlId()));
            return false;
        }
        double[] alphas = this.getLoading().getCurrentFlowAcceptanceFactors();
        Pas effectivePas = this.pasManager.findFirstSuitableExistingPas(bush, mergeVertex, alphas, reducedCost);
        if (effectivePas == null) {
            return false;
        }
        boolean newlyRegistered = effectivePas.registerBush(bush);
        if (newlyRegistered && this.getSettings().isDetailedLogging().booleanValue()) {
            LOGGER.info(String.format("%s %s added to PAS %s", bush.isInverted() ? "Destination" : "Origin", bush.getRootZoneVertex().getXmlId(), effectivePas.toString()));
        }
        return true;
    }

    private Pas extendBushWithNewPas(RootedLabelledBush bush, DirectedVertex reducedCostVertex, ShortestPathResult networkMinPaths) {
        short[] alternativeSegmentVertexLabels = new short[this.getTransportNetwork().getNumberOfVerticesAllLayers()];
        alternativeSegmentVertexLabels[(int)reducedCostVertex.getId()] = 1;
        int numShortestPathEdgeSegments = networkMinPaths.forEachNextEdgeSegment((DirectedVertex)bush.getRootVertex(), reducedCostVertex, edgeSegment -> {
            alternativeSegmentVertexLabels[(int)networkMinPaths.getNextVertexForEdgeSegment((EdgeSegment)edgeSegment).getId()] = -1;
        });
        Pair<DirectedVertex, Map<DirectedVertex, EdgeSegment>> highCostSegment = bush.findBushAlternativeSubpath(reducedCostVertex, alternativeSegmentVertexLabels);
        if (highCostSegment == null) {
            LOGGER.info(String.format("Unable to create new PAS for bush rooted at vertex %s, despite shorter path found on network to vertex %s", bush.getRootVertex().getXmlId(), reducedCostVertex.getXmlId()));
            return null;
        }
        boolean truncateSpareArrayCapacity = true;
        DirectedVertex coincideCloserToRootVertex = (DirectedVertex)highCostSegment.first();
        EdgeSegment[] s1 = PasManager.createSubpathArrayFrom(coincideCloserToRootVertex, reducedCostVertex, networkMinPaths, numShortestPathEdgeSegments, truncateSpareArrayCapacity);
        EdgeSegment cycleInducingSegment = bush.determineIntroduceCycle(s1);
        if (cycleInducingSegment != null) {
            LOGGER.fine(String.format("Newly identified PAS alternative for bush rooted at vertex (%s) would introduce cycle on low cost alternative (edge segment %s), ignore", bush.getRootVertex().toString(), cycleInducingSegment.getXmlId()));
            return null;
        }
        EdgeSegment[] s2 = PasManager.createSubpathArrayFrom(coincideCloserToRootVertex, reducedCostVertex, bush.getShortestSearchType(), (Map)highCostSegment.second(), ((Map)highCostSegment.second()).size(), truncateSpareArrayCapacity);
        Pas exitingPas = this.pasManager.findExistingPas(s1, s2);
        if (exitingPas != null) {
            exitingPas.registerBush(bush);
            return null;
        }
        Pas pas = this.pasManager.createAndRegisterNewPas(bush, s1, s2);
        this.getLoading().activateNodeTrackingFor(pas);
        return pas;
    }

    @Override
    protected Collection<Pas> updateBushPass(double[] linkSegmentCosts) throws PlanItException {
        ArrayList<Pas> newPass = new ArrayList<Pas>();
        ShortestPathDijkstra networkShortestPathAlgo = this.createNetworkShortestPathAlgo(linkSegmentCosts);
        for (int index = 0; index < ((RootedLabelledBush[])this.bushes).length; ++index) {
            RootedLabelledBush bush = ((RootedLabelledBush[])this.bushes)[index];
            if (bush == null) continue;
            MinMaxPathResult minMaxPaths = bush.computeMinMaxShortestPaths(linkSegmentCosts, this.getTransportNetwork().getNumberOfVerticesAllLayers());
            if (minMaxPaths == null) {
                LOGGER.severe(String.format("Unable to obtain min-max paths for bush, this shouldn't happen, skip updateBushPass", new Object[0]));
                continue;
            }
            ShortestPathResult networkMinPaths = networkShortestPathAlgo.execute(bush.getShortestSearchType(), (DirectedVertex)bush.getRootVertex());
            if (networkMinPaths == null) {
                LOGGER.severe(String.format("Unable to obtain network min paths for bush, this shouldn't happen, skip updateBushPass", new Object[0]));
                continue;
            }
            Iterator bushVertexIter = bush.getDirectedVertexIterator();
            while (bushVertexIter.hasNext()) {
                Pas newPas;
                boolean matchFound;
                double reducedCost;
                DirectedVertex bushVertex = (DirectedVertex)bushVertexIter.next();
                EdgeSegment reducedCostSegment = networkMinPaths.getNextEdgeSegmentForVertex((Vertex)bushVertex);
                if (reducedCostSegment == null || !((reducedCost = minMaxPaths.getCostOf((Vertex)bushVertex) - networkMinPaths.getCostOf((Vertex)bushVertex)) > 0.0) || bush.containsAnyEdgeSegmentOf(reducedCostSegment.getParent()) || (matchFound = this.extendBushWithSuitableExistingPas(bush, bushVertex, reducedCost)) || (newPas = this.extendBushWithNewPas(bush, bushVertex, networkMinPaths)) == null) continue;
                newPass.add(newPas);
                newPas.updateCost(linkSegmentCosts);
            }
        }
        return newPass;
    }

    protected StaticLtmBushStrategyRootLabelled(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
    }

    @Override
    protected StaticLtmLoadingBushRooted createNetworkLoading() {
        return new StaticLtmLoadingBushRooted(this.getIdGroupingToken(), this.getAssignmentId(), this.getSettings());
    }

    @Override
    protected StaticLtmLoadingBushRooted getLoading() {
        return (StaticLtmLoadingBushRooted)super.getLoading();
    }
}

