/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestBushGeneralised;
import org.goplanit.algorithms.shortest.ShortestPathDijkstra;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.RootedBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmAssignmentStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.StaticLtmType;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingBushBase;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingScheme;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.zoning.Zoning;

public abstract class StaticLtmBushStrategyBase<B extends RootedBush<?, ?>>
extends StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmBushStrategyBase.class.getCanonicalName());
    protected B[] bushes;
    protected final PasManager pasManager;
    protected Set<Pas> equalFlowDistributedPass;

    private Collection<Pas> shiftFlows(Mode theMode) {
        this.equalFlowDistributedPass.clear();
        ArrayList<Pas> flowShiftedPass = new ArrayList<Pas>((int)this.pasManager.getNumberOfPass());
        ArrayList<Pas> passWithoutOrigins = new ArrayList<Pas>();
        StaticLtmNetworkLoading networkLoading = this.getLoading();
        LinkBasedRelativeDualityGapFunction gapFunction = (LinkBasedRelativeDualityGapFunction)this.getTrafficAssignmentComponent(GapFunction.class);
        AbstractPhysicalCost physicalCost = this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
        AbstractVirtualCost virtualCost = this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
        BitSet linkSegmentsUsed = new BitSet(networkLoading.getCurrentInflowsPcuH().length);
        Collection<Pas> sortedPass = this.pasManager.getPassSortedByReducedCost();
        double factor = 1.0;
        for (Pas pas2 : sortedPass) {
            boolean pasFlowShifted;
            PasFlowShiftExecutor pasFlowShifter = this.createPasFlowShiftExecutor(pas2, this.getSettings());
            pasFlowShifter.initialise();
            if (!(pasFlowShifter.getS2SendingFlow() > 0.0)) {
                pas2.removeAllRegisteredBushes();
                passWithoutOrigins.add(pas2);
                continue;
            }
            this.updateGap(gapFunction, pas2, pasFlowShifter.getS1SendingFlow(), pasFlowShifter.getS2SendingFlow());
            if (pas2.containsAny(linkSegmentsUsed) || !(pasFlowShifted = pasFlowShifter.run(theMode, physicalCost, virtualCost, (StaticLtmLoadingBushBase<?>)networkLoading, factor))) continue;
            flowShiftedPass.add(pas2);
            if (pasFlowShifter.isTowardsEqualAlternativeFlowDistribution()) {
                this.equalFlowDistributedPass.add(pas2);
                continue;
            }
            pas2.forEachEdgeSegment(true, es -> linkSegmentsUsed.set((int)es.getId()));
            pas2.forEachEdgeSegment(false, es -> linkSegmentsUsed.set((int)es.getId()));
            pasFlowShifter.getUsedCongestedEntrySegments().forEach(es -> linkSegmentsUsed.set((int)es.getId()));
            if (pas2.hasRegisteredBushes()) continue;
            passWithoutOrigins.add(pas2);
        }
        if (!passWithoutOrigins.isEmpty()) {
            passWithoutOrigins.forEach(pas -> this.pasManager.removePas((Pas)pas, this.getSettings().isDetailedLogging()));
        }
        return flowShiftedPass;
    }

    protected void updateGap(LinkBasedRelativeDualityGapFunction gapFunction, Pas pas, double s1SendingFlow, double s2SendingFlow) {
        gapFunction.increaseConvexityBound(pas.getAlternativeLowCost() * (s1SendingFlow + s2SendingFlow));
        gapFunction.increaseMeasuredCost(s1SendingFlow * pas.getAlternativeLowCost());
        gapFunction.increaseMeasuredCost(s2SendingFlow * pas.getAlternativeHighCost());
    }

    protected void syncBushFlowsToNetworkFlows() {
        for (B bush : this.bushes) {
            if (bush == null) continue;
            ((RootedBush)bush).syncToNetworkFlows(this.getLoading().getCurrentFlowAcceptanceFactors());
        }
    }

    protected abstract Collection<Pas> updateBushPass(double[] var1) throws PlanItException;

    protected boolean isSolutionFlowEntropyMaximised(double gapEpsilon) {
        StringBuilder remainingPassToMaximiseEntropy = new StringBuilder("PASs not at max entropy: \n");
        boolean entryFound = false;
        for (Pas pas : this.equalFlowDistributedPass) {
            entryFound = true;
            remainingPassToMaximiseEntropy.append("PAS - ");
            remainingPassToMaximiseEntropy.append(pas.toString());
            remainingPassToMaximiseEntropy.append("\n");
        }
        if (entryFound && this.getSettings().isDetailedLogging().booleanValue()) {
            LOGGER.info(remainingPassToMaximiseEntropy.toString());
            return false;
        }
        return true;
    }

    protected StaticLtmBushStrategyBase(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
        boolean registerPassByDiverge = settings.getSltmType() == StaticLtmType.DESTINATION_BUSH_BASED;
        this.pasManager = new PasManager(registerPassByDiverge);
        this.pasManager.setDetailedLogging(settings.isDetailedLogging());
        this.equalFlowDistributedPass = new HashSet<Pas>();
    }

    protected abstract B[] createEmptyBushes();

    protected abstract void initialiseBush(B var1, Zoning var2, OdDemands var3, ShortestBushGeneralised var4);

    protected abstract PasFlowShiftExecutor createPasFlowShiftExecutor(Pas var1, StaticLtmSettings var2);

    protected void initialiseBushes(double[] linkSegmentCosts) throws PlanItException {
        ShortestBushGeneralised shortestBushAlgorithm = this.createNetworkShortestBushAlgo(linkSegmentCosts);
        Zoning zoning = this.getTransportNetwork().getZoning();
        OdDemands odDemands = this.getOdDemands();
        for (int index = 0; index < this.bushes.length; ++index) {
            B bush = this.bushes[index];
            if (bush == null) continue;
            this.initialiseBush(bush, zoning, odDemands, shortestBushAlgorithm);
            if (bush == null || !this.getSettings().isDetailedLogging().booleanValue()) continue;
            LOGGER.info(bush.toString());
        }
    }

    protected ShortestBushGeneralised createNetworkShortestBushAlgo(double[] linkSegmentCosts) {
        int numberOfVertices = this.getTransportNetwork().getNumberOfVerticesAllLayers();
        return new ShortestBushGeneralised(linkSegmentCosts, numberOfVertices);
    }

    protected ShortestPathDijkstra createNetworkShortestPathAlgo(double[] linkSegmentCosts) {
        int numberOfVertices = this.getTransportNetwork().getNumberOfVerticesAllLayers();
        return new ShortestPathDijkstra(linkSegmentCosts, numberOfVertices);
    }

    @Override
    protected abstract StaticLtmLoadingBushBase<B> createNetworkLoading();

    @Override
    protected StaticLtmLoadingBushBase<B> getLoading() {
        return (StaticLtmLoadingBushBase)super.getLoading();
    }

    @Override
    public void createInitialSolution(double[] initialLinkSegmentCosts) {
        try {
            if (this.bushes == null || this.bushes.length == 0) {
                this.bushes = this.createEmptyBushes();
            }
            this.initialiseBushes(initialLinkSegmentCosts);
            this.getLoading().setBushes((Bush[])this.bushes);
            ((StaticLtmLoadingBushBase)this.getLoading()).setPasManager(this.pasManager);
        }
        catch (PlanItException e) {
            LOGGER.severe(String.format("Unable to create initial bushes for sLTM %d", this.getAssignmentId()));
        }
    }

    @Override
    public boolean performIteration(Mode theMode, double[] costsToUpdate, int iterationIndex) {
        try {
            this.executeNetworkLoading();
            boolean updateOnlyPotentiallyBlockingNodeCosts = this.getLoading().getActivatedSolutionScheme().equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
            this.executeNetworkCostsUpdate(theMode, updateOnlyPotentiallyBlockingNodeCosts, costsToUpdate);
            this.pasManager.updateCosts(costsToUpdate);
            LOGGER.info(String.format("** ALPHA: %s", Arrays.toString(this.getLoading().getCurrentFlowAcceptanceFactors())));
            LOGGER.info(String.format("** COSTS: %s", Arrays.toString(costsToUpdate)));
            LOGGER.info(String.format("** INFLOW: %s", Arrays.toString(this.getLoading().getCurrentInflowsPcuH())));
            LOGGER.info(String.format("** OUTFLOW: %s", Arrays.toString(this.getLoading().getCurrentOutflowsPcuH())));
            this.syncBushFlowsToNetworkFlows();
            Collection<Pas> newPass = this.updateBushPass(costsToUpdate);
            Collection<Pas> updatedPass = this.shiftFlows(theMode);
            if (this.getSettings().isDetailedLogging().booleanValue()) {
                ArrayList<Pas> newUsedPass = new ArrayList<Pas>(newPass);
                newUsedPass.retainAll(updatedPass);
                newUsedPass.forEach(p -> LOGGER.info(String.format("Created new PAS and applied flow shift on it: %s", p.toString())));
            }
            newPass.removeAll(updatedPass);
            newPass.forEach(pas -> this.pasManager.removePas((Pas)pas, false));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to complete sLTM iteration");
            if (this.getSettings().isDetailedLogging().booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasConverged(GapFunction gapFunction, int iterationIndex) {
        boolean converged = super.hasConverged(gapFunction, iterationIndex);
        if (converged && this.getSettings().isEnforceMaxEntropyFlowSolution().booleanValue() && !(converged = this.isSolutionFlowEntropyMaximised(gapFunction.getStopCriterion().getEpsilon()))) {
            LOGGER.info("cost convergence: yes - yet one or more PASs flow distribution is not entropy maximised - overall convergence: no");
        }
        return converged;
    }
}

