/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.BitSet;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.gap.GapFunction;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.Zone;

public abstract class StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmAssignmentStrategy.class.getCanonicalName());
    private final IdGroupingToken idGroupingToken;
    private final long assignmentId;
    private final TransportModelNetwork transportModelNetwork;
    private StaticLtmNetworkLoading networkLoading;
    private OdDemands odDemands;
    private final StaticLtmSettings settings;
    private final TrafficAssignmentComponentAccessee taComponents;
    private final BitSet prevIterationPotentiallyBlocking;
    private Map<Zone, CentroidVertex> zone2VertexMapping;

    protected TransportModelNetwork getTransportNetwork() {
        return this.transportModelNetwork;
    }

    protected MacroscopicNetwork getInfrastructureNetwork() {
        return (MacroscopicNetwork)this.getTransportNetwork().getInfrastructureNetwork();
    }

    protected IdGroupingToken getIdGroupingToken() {
        return this.idGroupingToken;
    }

    protected long getAssignmentId() {
        return this.assignmentId;
    }

    protected StaticLtmNetworkLoading getLoading() {
        return this.networkLoading;
    }

    protected StaticLtmSettings getSettings() {
        return this.settings;
    }

    protected OdDemands getOdDemands() {
        return this.odDemands;
    }

    protected void setOdDemands(OdDemands odDemands) {
        this.odDemands = odDemands;
    }

    protected <T> T getTrafficAssignmentComponent(Class<T> taComponentClassKey) {
        return this.taComponents.getTrafficAssignmentComponent(taComponentClassKey);
    }

    protected CentroidVertex findCentroidVertex(OdZone zone) {
        return this.zone2VertexMapping.get(zone);
    }

    protected void verifyNetworkLoadingConvergenceProgress(StaticLtmNetworkLoading networkLoading, int networkLoadingIterationIndex) {
        boolean changedScheme;
        if (!networkLoading.isConverging() && !(changedScheme = networkLoading.activateNextExtension(true))) {
            LOGGER.warning(String.format("%sDetected network loading is not converging as expected (internal loading iteration %d) - unable to activate further extensions, consider aborting", LoggingUtils.runIdPrefix((long)this.getAssignmentId()), networkLoadingIterationIndex));
        }
    }

    protected void executeNetworkLoading() {
        int networkLoadingIterationIndex = 0;
        this.getLoading().stepZeroIterationInitialisation(true);
        do {
            this.verifyNetworkLoadingConvergenceProgress(this.getLoading(), networkLoadingIterationIndex);
            this.getLoading().stepOneSplittingRatesUpdate();
            this.getLoading().stepTwoInflowSendingFlowUpdate();
            this.getLoading().stepThreeSplittingRateUpdate();
            this.getLoading().stepFourOutflowReceivingFlowUpdate();
        } while (!this.getLoading().stepFiveCheckNetworkLoadingConvergence(networkLoadingIterationIndex++));
    }

    protected abstract StaticLtmNetworkLoading createNetworkLoading();

    protected void executeNetworkCostsUpdate(Mode theMode, boolean updateOnlyPotentiallyBlockingNodeCosts, double[] costsToUpdate) throws PlanItException {
        AbstractPhysicalCost physicalCost = this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
        AbstractVirtualCost virtualCost = this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
        SplittingRateData splittingRateData = this.getLoading().getSplittingRateData();
        if (updateOnlyPotentiallyBlockingNodeCosts) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getInfrastructureNetwork().getLayerByMode(theMode);
            VirtualNetwork virtualLayer = this.getTransportNetwork().getZoning().getVirtualNetwork();
            boolean currentlyPotentiallyBlocking = false;
            for (DirectedVertex trackedFlowNode : splittingRateData.getTrackedNodes()) {
                currentlyPotentiallyBlocking = splittingRateData.isPotentiallyBlocking(trackedFlowNode);
                if (!currentlyPotentiallyBlocking && !this.prevIterationPotentiallyBlocking.get((int)trackedFlowNode.getId())) continue;
                networkLayer.getLinkSegments().forEachMatchingIdIn(trackedFlowNode.getEntryEdgeSegments(), es -> {
                    costsToUpdate[(int)es.getId()] = physicalCost.getGeneralisedCost(theMode, (EdgeSegment)((MacroscopicLinkSegment)es));
                });
                virtualLayer.getConnectoidSegments().forEachMatchingIdIn(trackedFlowNode.getEntryEdgeSegments(), es -> {
                    costsToUpdate[(int)es.getId()] = virtualCost.getGeneralisedCost(theMode, (EdgeSegment)((ConnectoidSegment)es));
                });
                this.prevIterationPotentiallyBlocking.set((int)trackedFlowNode.getId(), currentlyPotentiallyBlocking);
            }
        } else {
            virtualCost.populateWithCost(this.getTransportNetwork().getVirtualNetwork(), theMode, costsToUpdate);
            physicalCost.populateWithCost((UntypedPhysicalLayer)this.getInfrastructureNetwork().getLayerByMode(theMode), theMode, costsToUpdate);
        }
    }

    public StaticLtmAssignmentStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        this.transportModelNetwork = transportModelNetwork;
        this.assignmentId = assignmentId;
        this.idGroupingToken = idGroupingToken;
        this.settings = settings;
        this.taComponents = taComponents;
        this.prevIterationPotentiallyBlocking = new BitSet(transportModelNetwork.getNumberOfVerticesAllLayers());
        this.zone2VertexMapping = transportModelNetwork.createZoneToCentroidVertexMapping(true, false);
    }

    public void updateTimePeriod(TimePeriod timePeriod, Mode mode, OdDemands odDemands) {
        this.networkLoading = this.createNetworkLoading();
        this.networkLoading.initialiseInputs(mode, odDemands, this.getTransportNetwork());
        this.setOdDemands(odDemands);
    }

    public boolean hasConverged(GapFunction gapFunction, int iterationIndex) {
        gapFunction.computeGap();
        return gapFunction.hasConverged(iterationIndex);
    }

    public abstract void createInitialSolution(double[] var1);

    public abstract boolean performIteration(Mode var1, double[] var2, int var3);

    public abstract String getDescription();
}

