/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.LtmAssignment;
import org.goplanit.assignment.ltm.sltm.StaticLtmAssignmentStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmDestinationBushStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmLinkOutputTypeAdapter;
import org.goplanit.assignment.ltm.sltm.StaticLtmOriginBushDestLabelledStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmPathStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.StaticLtmSimulationData;
import org.goplanit.assignment.ltm.sltm.StaticLtmType;
import org.goplanit.assignment.ltm.sltm.conjugate.StaticLtmStrategyConjugateBush;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.interactor.LinkInflowOutflowAccessee;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.sdinteraction.smoothing.MSASmoothing;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.reflection.ReflectionUtils;
import org.goplanit.utils.time.TimePeriod;

public class StaticLtm
extends LtmAssignment
implements LinkInflowOutflowAccessee {
    private static final long serialVersionUID = 8485652038791612169L;
    private static final Logger LOGGER = Logger.getLogger(StaticLtm.class.getCanonicalName());
    StaticLtmSettings settings;
    private StaticLtmAssignmentStrategy assignmentStrategy;
    private StaticLtmSimulationData simulationData;

    private StaticLtmAssignmentStrategy createAssignmentStrategy() {
        switch (this.settings.getSltmType()) {
            case ORIGIN_BUSH_BASED: {
                return new StaticLtmOriginBushDestLabelledStrategy(this.getIdGroupingToken(), this.getId(), this.getTransportNetwork(), this.settings, this);
            }
            case DESTINATION_BUSH_BASED: {
                return new StaticLtmDestinationBushStrategy(this.getIdGroupingToken(), this.getId(), this.getTransportNetwork(), this.settings, this);
            }
            case CONJUGATE_DESTINATION_BUSH_BASED: {
                return new StaticLtmStrategyConjugateBush(this.getIdGroupingToken(), this.getId(), this.getTransportNetwork(), this.settings, this);
            }
            case PATH_BASED: {
                return new StaticLtmPathStrategy(this.getIdGroupingToken(), this.getId(), this.getTransportNetwork(), this.settings, this);
            }
        }
        LOGGER.warning(String.format("Unsupported static LTM type chosen %s, aborting", new Object[]{this.settings.getSltmType()}));
        return null;
    }

    private Calendar logBasicIterationInformation(Calendar startTime, LinkBasedRelativeDualityGapFunction gapFunction) {
        Calendar currentTime = Calendar.getInstance();
        LOGGER.info(String.format("%sGap: %.10f (%d ms)", this.createLoggingPrefix(this.getIterationIndex()), gapFunction.getGap(), currentTime.getTimeInMillis() - startTime.getTimeInMillis()));
        return currentTime;
    }

    private StaticLtmSimulationData initialiseTimePeriod(TimePeriod timePeriod, Mode mode, OdDemands odDemands) throws PlanItException {
        this.getPhysicalCost().updateTimePeriod(timePeriod);
        this.getVirtualCost().updateTimePeriod(timePeriod);
        this.assignmentStrategy.updateTimePeriod(timePeriod, mode, odDemands);
        boolean updateOnlyPotentiallyBlockingNodeCosts = false;
        double[] initialLinkSegmentCosts = new double[this.getTotalNumberOfNetworkSegments()];
        this.assignmentStrategy.executeNetworkCostsUpdate(mode, updateOnlyPotentiallyBlockingNodeCosts, initialLinkSegmentCosts);
        StaticLtmSimulationData simulationData = new StaticLtmSimulationData(timePeriod, List.of(mode), this.getTotalNumberOfNetworkSegments());
        simulationData.setLinkSegmentTravelTimePcuH(mode, initialLinkSegmentCosts);
        this.assignmentStrategy.createInitialSolution(initialLinkSegmentCosts);
        return simulationData;
    }

    private void executeTimePeriod(TimePeriod timePeriod, Set<Mode> modes) throws PlanItException {
        if (modes.size() != 1) {
            LOGGER.warning(String.format("%ssLTM only supports a single mode for now, found %s, aborting assignment for time period %s", LoggingUtils.runIdPrefix((long)this.getId()), timePeriod.getXmlId()));
            return;
        }
        Mode theMode = modes.iterator().next();
        this.simulationData = this.initialiseTimePeriod(timePeriod, theMode, this.getDemands().get(theMode, timePeriod));
        boolean converged = false;
        Calendar iterationStartTime = Calendar.getInstance();
        do {
            this.getGapFunction().reset();
            this.assignmentStrategy.getLoading().resetIteration();
            this.simulationData.incrementIterationIndex();
            this.getSmoothing().updateStep(this.simulationData.getIterationIndex());
            double[] prevCosts = this.getIterationData().getLinkSegmentTravelTimePcuH(theMode);
            double[] costsToUpdate = Arrays.copyOf(prevCosts, prevCosts.length);
            boolean success = this.assignmentStrategy.performIteration(theMode, costsToUpdate, this.simulationData.getIterationIndex());
            if (!success) {
                LOGGER.severe("Unable to continue PLANit sLTM run, aborting");
                break;
            }
            this.getIterationData().setLinkSegmentTravelTimePcuH(theMode, costsToUpdate);
            converged = this.assignmentStrategy.hasConverged(this.getGapFunction(), this.simulationData.getIterationIndex());
            this.persistIterationResults(timePeriod, theMode, converged);
            iterationStartTime = this.logBasicIterationInformation(iterationStartTime, (LinkBasedRelativeDualityGapFunction)this.getGapFunction());
        } while (!converged);
    }

    private void persistIterationResults(TimePeriod timePeriod, Mode theMode, boolean converged) throws PlanItException {
        Set<Mode> modes = Set.of(theMode);
        if (this.getOutputManager().isAnyOutputPersisted(timePeriod, modes, converged)) {
            this.assignmentStrategy.getLoading().stepSixFinaliseForPersistence();
            this.getOutputManager().persistOutputData(timePeriod, modes, converged);
            LOGGER.info(String.format("** INFLOW: %s", Arrays.toString(this.assignmentStrategy.getLoading().getCurrentInflowsPcuH())));
            LOGGER.info(String.format("** OUTFLOW: %s", Arrays.toString(this.assignmentStrategy.getLoading().getCurrentOutflowsPcuH())));
            LOGGER.info(String.format("** ALPHA: %s", Arrays.toString(this.assignmentStrategy.getLoading().getCurrentFlowAcceptanceFactors())));
        }
    }

    @Override
    protected void verifyComponentCompatibility() throws PlanItException {
        super.verifyComponentCompatibility();
        PlanItException.throwIf((!(this.getGapFunction() instanceof LinkBasedRelativeDualityGapFunction) ? 1 : 0) != 0, (String)"%sStatic LTM only supports a link based relative gap function (for equilibration) at the moment, but found %s", (Object[])new Object[]{LoggingUtils.runIdPrefix((long)this.getId()), this.getGapFunction().getClass().getCanonicalName()});
        PlanItException.throwIf((!(this.getSmoothing() instanceof MSASmoothing) ? 1 : 0) != 0, (String)"%sStatic LTM only supports MSA smoothing at the moment, but found %s", (Object[])new Object[]{LoggingUtils.runIdPrefix((long)this.getId()), this.getSmoothing().getClass().getCanonicalName()});
    }

    @Override
    protected void initialiseBeforeExecution() throws PlanItException {
        super.initialiseBeforeExecution();
        this.assignmentStrategy = this.createAssignmentStrategy();
        LOGGER.info(String.format("%sstrategy: %s", LoggingUtils.runIdPrefix((long)this.getId()), this.assignmentStrategy.getDescription()));
    }

    @Override
    protected void executeEquilibration() throws PlanItException {
        SortedSet<TimePeriod> timePeriods = this.getDemands().timePeriods.asSortedSetByStartTime();
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + "total time periods: " + timePeriods.size());
        for (TimePeriod timePeriod : timePeriods) {
            Calendar startTime;
            Calendar initialStartTime = startTime = Calendar.getInstance();
            LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.timePeriodPrefix((TimePeriod)timePeriod) + timePeriod.toString());
            this.executeTimePeriod(timePeriod, this.getDemands().getRegisteredModesForTimePeriod(timePeriod));
            LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + String.format("run time: %d milliseconds", startTime.getTimeInMillis() - initialStartTime.getTimeInMillis()));
        }
    }

    protected StaticLtmSimulationData getIterationData() {
        return this.simulationData;
    }

    protected StaticLtmAssignmentStrategy getStrategy() {
        return this.assignmentStrategy;
    }

    public StaticLtm(IdGroupingToken groupId) {
        super(groupId);
        this.settings = new StaticLtmSettings();
    }

    public StaticLtm(StaticLtm sltm) {
        super(sltm, false);
        this.settings = sltm.settings.shallowClone();
        this.simulationData = sltm.simulationData.shallowClone();
    }

    public MacroscopicNetwork getInfrastructureNetwork() {
        return (MacroscopicNetwork)super.getInfrastructureNetwork();
    }

    @Override
    public OutputTypeAdapter createOutputTypeAdapter(OutputType outputType) {
        StaticLtmLinkOutputTypeAdapter outputTypeAdapter = null;
        switch (outputType) {
            case LINK: {
                outputTypeAdapter = new StaticLtmLinkOutputTypeAdapter(outputType, this);
                break;
            }
            case OD: {
                break;
            }
            case PATH: {
                break;
            }
            default: {
                LOGGER.warning(String.format("%s%s is not supported yet", LoggingUtils.runIdPrefix((long)this.getId()), outputType.value()));
            }
        }
        return outputTypeAdapter;
    }

    @Override
    public int getIterationIndex() {
        return this.simulationData.getIterationIndex();
    }

    @Override
    public StaticLtm shallowClone() {
        return new StaticLtm(this);
    }

    @Override
    public StaticLtm deepClone() {
        throw new PlanItRunTimeException("Deep clone not yet implemented");
    }

    public boolean isDisableLinkStorageConstraints() {
        return this.settings.isDisableStorageConstraints();
    }

    public void setDisableLinkStorageConstraints(boolean flag) {
        this.settings.setDisableStorageConstraints(flag);
    }

    public void setActivateDetailedLogging(boolean flag) {
        this.settings.setDetailedLogging(flag);
    }

    public boolean isActivateBushBased() {
        return this.settings.isBushBased();
    }

    public void setType(StaticLtmType type) {
        this.settings.setSltmType(type);
    }

    public boolean isActivateDetailedLogging() {
        return this.settings.isDetailedLogging();
    }

    public boolean isEnforceMaxEntropyFlowSolution() {
        return this.settings.isEnforceMaxEntropyFlowSolution();
    }

    public void setEnforceMaxEntropyFlowSolution(boolean enforceMaxEntropyFlowSolution) {
        this.settings.setEnforceMaxEntropyFlowSolution(enforceMaxEntropyFlowSolution);
    }

    @Override
    public double[] getLinkSegmentInflowsPcuHour() {
        return this.assignmentStrategy.getLoading().getCurrentInflowsPcuH();
    }

    @Override
    public double[] getLinkSegmentOutflowsPcuHour() {
        return this.assignmentStrategy.getLoading().getCurrentOutflowsPcuH();
    }

    @Override
    public void reset() {
        super.reset();
        this.simulationData.reset();
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        Map privateFieldNameValues = ReflectionUtils.declaredFieldsNameValueMap((Object)this.settings, i -> Modifier.isPrivate(i) && !Modifier.isStatic(i));
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        privateFieldNameValues.forEach((k, v) -> keyValueMap.put((String)k, v.toString()));
        return keyValueMap;
    }
}

