/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestPathSearchUtils;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.LabelledBushTurnData;
import org.goplanit.assignment.ltm.sltm.RootedBush;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraphImpl;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;

public abstract class RootedLabelledBush
extends RootedBush<DirectedVertex, EdgeSegment> {
    private static final Logger LOGGER = Logger.getLogger(RootedLabelledBush.class.getCanonicalName());
    protected final LabelledBushTurnData bushData;

    private double determineSubPathSendingFlow(double subPathSendingFlow, BushFlowLabel label, int index, EdgeSegment[] subPathArray) {
        EdgeSegment currEdgeSegment = subPathArray[index++];
        if (index < subPathArray.length && Precision.positive((double)subPathSendingFlow)) {
            EdgeSegment nextEdgeSegment = subPathArray[index];
            TreeSet<BushFlowLabel> exitLabels = this.getFlowCompositionLabels(nextEdgeSegment);
            if (exitLabels == null) {
                return 0.0;
            }
            MultiKeyMap<Object, Double> exitSegmentExitLabelSplittingRates = this.bushData.getSplittingRates(currEdgeSegment, label);
            double remainingSubPathSendingFlow = 0.0;
            for (BushFlowLabel exitLabel : exitLabels) {
                Double currSplittingRate = (Double)exitSegmentExitLabelSplittingRates.get((Object)nextEdgeSegment, (Object)exitLabel);
                if (currSplittingRate == null || currSplittingRate <= 0.0) continue;
                remainingSubPathSendingFlow += subPathSendingFlow * currSplittingRate;
            }
            return this.determineSubPathSendingFlow(remainingSubPathSendingFlow, label, index, subPathArray);
        }
        return subPathSendingFlow;
    }

    protected ACyclicSubGraph getDag() {
        return (ACyclicSubGraph)super.getDag();
    }

    public RootedLabelledBush(IdGroupingToken idToken, DirectedVertex rootVertex, boolean inverted, long maxSubGraphEdgeSegments) {
        super(idToken, rootVertex, inverted, new ACyclicSubGraphImpl(idToken, rootVertex, inverted, (int)maxSubGraphEdgeSegments));
        this.bushData = new LabelledBushTurnData();
    }

    public RootedLabelledBush(RootedLabelledBush bush, boolean deepCopy) {
        super(bush, deepCopy);
        this.bushData = deepCopy ? bush.bushData.deepClone() : bush.bushData.shallowClone();
    }

    @Override
    public abstract MinMaxPathResult computeMinMaxShortestPaths(double[] var1, int var2);

    @Override
    public abstract RootedLabelledBush shallowClone();

    @Override
    public abstract RootedLabelledBush deepClone();

    public String toString() {
        Function getNextVertex;
        StringBuilder sb = new StringBuilder("[");
        Object root = this.getRootVertex();
        PriorityQueue<Object> openVertices = new PriorityQueue<Object>();
        openVertices.add(root);
        HashSet<DirectedVertex> processed = new HashSet<DirectedVertex>();
        Function getNextEdgeSegments = this.isInverted() ? DirectedVertex.getEntryEdgeSegments : DirectedVertex.getExitEdgeSegments;
        Function function = getNextVertex = this.isInverted() ? EdgeSegment.getUpstreamVertex : EdgeSegment.getDownstreamVertex;
        while (!openVertices.isEmpty()) {
            DirectedVertex vertex = (DirectedVertex)openVertices.poll();
            processed.add(vertex);
            for (EdgeSegment nextSegment : (Iterable)getNextEdgeSegments.apply(vertex)) {
                if (!this.containsEdgeSegment(nextSegment)) continue;
                DirectedVertex nextVertex = (DirectedVertex)getNextVertex.apply(nextSegment);
                sb.append(nextSegment.getXmlId() + ",");
                if (processed.contains(nextVertex)) continue;
                openVertices.add(nextVertex);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public EdgeSegment determineIntroduceCycle(EdgeSegment[] alternative) {
        if (alternative == null) {
            LOGGER.severe("Cannot verify if edge segments introduce cycle when parameters are null");
            return null;
        }
        EdgeSegment currSegment = null;
        for (int index = 0; index < alternative.length; ++index) {
            EdgeSegment currEdgeSegment = alternative[index];
            if (currEdgeSegment == null) {
                LOGGER.severe(String.format("Alternative's edge segment at position %d on array is null, this shouldn't happen", index));
                break;
            }
            currSegment = alternative[index].getOppositeDirectionSegment();
            if (currSegment == null || !this.containsEdgeSegment(currSegment)) continue;
            return alternative[index];
        }
        return null;
    }

    public double addTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel, double addFlowPcuH) {
        return this.addTurnSendingFlow(from, fromLabel, to, toLabel, addFlowPcuH, false);
    }

    public double addTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel, double addFlowPcuH, boolean allowTurnRemoval) {
        if (addFlowPcuH > 0.0) {
            if (!this.containsEdgeSegment(from)) {
                if (this.containsEdgeSegment(from.getOppositeDirectionSegment())) {
                    LOGGER.warning(String.format("Trying to add turn flow (%s,%s) on bush where the opposite direction (of segment %s) already is part of the bush, this break acyclicity", from.getXmlId(), to.getXmlId(), from.getXmlId()));
                }
                this.getDag().addEdgeSegment(from);
                this.requireTopologicalSortUpdate = true;
            }
            if (!this.containsEdgeSegment(to)) {
                if (this.containsEdgeSegment(to.getOppositeDirectionSegment())) {
                    LOGGER.warning(String.format("Trying to add turn flow (%s,%s) on bush where the opposite direction (of segment %s) already is part of the bush, this break acyclicity", from.getXmlId(), to.getXmlId(), to.getXmlId()));
                }
                this.getDag().addEdgeSegment(to);
                this.requireTopologicalSortUpdate = true;
            }
        }
        return this.bushData.addTurnSendingFlow(from, fromLabel, to, toLabel, addFlowPcuH, allowTurnRemoval);
    }

    public double getTurnSendingFlow(EdgeSegment from, EdgeSegment to) {
        return this.bushData.getTurnSendingFlowPcuH(from, to);
    }

    public double getTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel) {
        return this.bushData.getTurnSendingFlowPcuH(from, fromLabel, to, toLabel);
    }

    public double getSendingFlowPcuH(EdgeSegment edgeSegment) {
        return this.bushData.getTotalSendingFlowFromPcuH(edgeSegment);
    }

    public double getSendingFlowPcuH(EdgeSegment edgeSegment, BushFlowLabel compositionLabel) {
        return this.bushData.getTotalSendingFlowFromPcuH(edgeSegment, compositionLabel);
    }

    public boolean containsTurnSendingFlow(EdgeSegment from, EdgeSegment to) {
        return this.bushData.getTurnSendingFlowPcuH(from, to) > 0.0;
    }

    public boolean containsTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel) {
        return this.bushData.getTurnSendingFlowPcuH(from, fromLabel, to, toLabel) > 0.0;
    }

    public double getSplittingRate(EdgeSegment from, EdgeSegment to) {
        return this.bushData.getSplittingRate(from, to);
    }

    public double getSplittingRate(EdgeSegment entrySegment, EdgeSegment exitSegment, BushFlowLabel entryExitLabel) {
        return this.bushData.getSplittingRate(entrySegment, exitSegment, entryExitLabel);
    }

    public double[] getSplittingRates(EdgeSegment entrySegment) {
        return this.bushData.getSplittingRates(entrySegment);
    }

    public MultiKeyMap<Object, Double> getSplittingRates(EdgeSegment entrySegment, BushFlowLabel entryLabel) {
        return this.bushData.getSplittingRates(entrySegment, entryLabel);
    }

    public void removeTurn(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        this.bushData.removeTurn(fromEdgeSegment, toEdgeSegment);
        if (!Precision.positive((double)this.getSendingFlowPcuH(fromEdgeSegment))) {
            this.removeEdgeSegment(fromEdgeSegment);
        }
        if (!Precision.positive((double)this.getSendingFlowPcuH(toEdgeSegment))) {
            this.removeEdgeSegment(toEdgeSegment);
        }
        this.requireTopologicalSortUpdate = true;
    }

    public boolean removeEdgeSegment(EdgeSegment edgeSegment) {
        if (!Precision.positive((double)this.getSendingFlowPcuH(edgeSegment))) {
            this.getDag().removeEdgeSegment(edgeSegment);
            return true;
        }
        LOGGER.warning(String.format("Unable to remove edge segment %s from bush (origin %s) unless it has no flow", edgeSegment.getXmlId()));
        return false;
    }

    public boolean containsEdgeSegment(EdgeSegment edgeSegment) {
        return this.getDag().containsEdgeSegment(edgeSegment);
    }

    public boolean containsAnyEdgeSegmentOf(DirectedEdge edge) {
        for (EdgeSegment edgeSegment : edge.getEdgeSegments()) {
            if (!this.getDag().containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    public Pair<DirectedVertex, Map<DirectedVertex, EdgeSegment>> findBushAlternativeSubpath(DirectedVertex referenceVertex, short[] alternativeSubpathVertexLabels) {
        ArrayDeque<Pair> openVertexQueue = new ArrayDeque<Pair>(30);
        TreeMap<DirectedVertex, EdgeSegment> processedVertices = new TreeMap<DirectedVertex, EdgeSegment>();
        boolean invertNextDirection = true;
        Function<DirectedVertex, Iterable<? extends EdgeSegment>> getNextEdgeSegments = ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(this, true);
        Function<EdgeSegment, DirectedVertex> getNextVertex = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(this, true);
        processedVertices.put(referenceVertex, null);
        Iterable<? extends EdgeSegment> nextEdgeSegments = getNextEdgeSegments.apply(referenceVertex);
        for (EdgeSegment edgeSegment : nextEdgeSegments) {
            if (!this.containsEdgeSegment(edgeSegment) || alternativeSubpathVertexLabels[(int)referenceVertex.getId()] == -1) continue;
            openVertexQueue.add(Pair.of((Object)getNextVertex.apply(edgeSegment), (Object)edgeSegment));
        }
        while (!openVertexQueue.isEmpty()) {
            Pair current = (Pair)openVertexQueue.pop();
            DirectedVertex directedVertex = (DirectedVertex)current.first();
            if (processedVertices.containsKey(directedVertex)) continue;
            if (alternativeSubpathVertexLabels[(int)directedVertex.getId()] == -1) {
                processedVertices.put(directedVertex, (EdgeSegment)current.second());
                return Pair.of((Object)((DirectedVertex)current.first()), processedVertices);
            }
            nextEdgeSegments = getNextEdgeSegments.apply(directedVertex);
            for (EdgeSegment edgeSegment : nextEdgeSegments) {
                DirectedVertex nextVertex;
                if (!this.containsEdgeSegment(edgeSegment) || !this.bushData.containsTurnSendingFlow(edgeSegment, (EdgeSegment)current.second()) || processedVertices.containsKey(nextVertex = getNextVertex.apply(edgeSegment))) continue;
                openVertexQueue.add(Pair.of((Object)nextVertex, (Object)edgeSegment));
            }
            processedVertices.put(directedVertex, (EdgeSegment)current.second());
        }
        LOGGER.warning(String.format("Cycle found when finding alternative subpath on bush merging at vertex %s", referenceVertex.getXmlId()));
        return null;
    }

    public double computeSubPathSendingFlow(DirectedVertex startVertex, DirectedVertex endVertex, Map<DirectedVertex, EdgeSegment> subPathMap) {
        EdgeSegment nextEdgeSegment = subPathMap.get(startVertex);
        double subPathSendingFlow = this.bushData.getTotalSendingFlowFromPcuH(nextEdgeSegment);
        if (Precision.positive((double)subPathSendingFlow)) {
            EdgeSegment currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathMap.get(currEdgeSegment.getDownstreamVertex());
            while ((nextEdgeSegment = subPathMap.get((currEdgeSegment = nextEdgeSegment).getDownstreamVertex())) != null && Precision.positive((double)(subPathSendingFlow *= this.bushData.getSplittingRate(currEdgeSegment, nextEdgeSegment)))) {
            }
        }
        return subPathSendingFlow;
    }

    public double computeSubPathAcceptedFlow(DirectedVertex startVertex, DirectedVertex endVertex, EdgeSegment[] subPathArray, double[] linkSegmentAcceptanceFactors) {
        int index = 0;
        EdgeSegment currEdgeSegment = subPathArray[index++];
        double subPathAcceptedFlowPcuH = this.bushData.getTotalSendingFlowFromPcuH(currEdgeSegment);
        EdgeSegment nextEdgeSegment = currEdgeSegment;
        while (index < subPathArray.length && Precision.positive((double)subPathAcceptedFlowPcuH)) {
            currEdgeSegment = nextEdgeSegment;
            nextEdgeSegment = subPathArray[index++];
            subPathAcceptedFlowPcuH *= this.bushData.getSplittingRate(currEdgeSegment, nextEdgeSegment) * linkSegmentAcceptanceFactors[(int)currEdgeSegment.getId()];
        }
        return subPathAcceptedFlowPcuH *= linkSegmentAcceptanceFactors[(int)nextEdgeSegment.getId()];
    }

    public double determineSubPathSendingFlow(EdgeSegment entrySegment, EdgeSegment[] subPathArray) {
        int index = 0;
        TreeSet<BushFlowLabel> usedEntryLabels = this.getFlowCompositionLabels(entrySegment);
        double subPathSendingFlow = 0.0;
        for (BushFlowLabel entryLabel : usedEntryLabels) {
            double labelSendingFlow = this.bushData.getTotalSendingFlowFromPcuH(entrySegment, entryLabel);
            EdgeSegment initialSubPathEdgeSegment = subPathArray[index];
            TreeSet<BushFlowLabel> exitLabels = this.getFlowCompositionLabels(initialSubPathEdgeSegment);
            if (exitLabels == null) {
                return 0.0;
            }
            MultiKeyMap<Object, Double> exitSegmentExitLabelSplittingRates = this.bushData.getSplittingRates(entrySegment, entryLabel);
            double remainingSubPathSendingFlow = 0.0;
            for (BushFlowLabel exitLabel : exitLabels) {
                Double currSplittingRate = (Double)exitSegmentExitLabelSplittingRates.get((Object)initialSubPathEdgeSegment, (Object)exitLabel);
                if (currSplittingRate == null || currSplittingRate <= 0.0) continue;
                remainingSubPathSendingFlow += labelSendingFlow * currSplittingRate;
            }
            labelSendingFlow = this.determineSubPathSendingFlow(remainingSubPathSendingFlow, entryLabel, index, subPathArray);
            subPathSendingFlow += labelSendingFlow;
        }
        return subPathSendingFlow;
    }

    public TreeMap<BushFlowLabel, Double> determineProportionalFlowCompositionRates(EdgeSegment edgeSegment, Set<BushFlowLabel> pasFlowCompositionLabels) {
        double totalSendingFlow = 0.0;
        TreeMap<BushFlowLabel, Double> rateMap = new TreeMap<BushFlowLabel, Double>();
        for (BushFlowLabel bushFlowLabel : pasFlowCompositionLabels) {
            double labelFlow = this.bushData.getTotalSendingFlowFromPcuH(edgeSegment, bushFlowLabel);
            rateMap.put(bushFlowLabel, labelFlow);
            totalSendingFlow += labelFlow;
        }
        for (Map.Entry entry : rateMap.entrySet()) {
            entry.setValue((Double)entry.getValue() / totalSendingFlow);
        }
        return rateMap;
    }

    public TreeSet<BushFlowLabel> getFlowCompositionLabels(EdgeSegment edgeSegment) {
        return this.bushData.getFlowCompositionLabels(edgeSegment);
    }

    public BushFlowLabel getFirstFlowCompositionLabel(EdgeSegment edgeSegment) {
        return this.hasFlowCompositionLabel(edgeSegment) ? this.bushData.getFlowCompositionLabels(edgeSegment).first() : null;
    }

    public boolean hasFlowCompositionLabel(EdgeSegment edgeSegment) {
        return this.bushData.hasFlowCompositionLabel(edgeSegment);
    }

    public boolean hasFlowCompositionLabel(EdgeSegment edgeSegment, BushFlowLabel compositionLabel) {
        return this.bushData.hasFlowCompositionLabel(edgeSegment, compositionLabel);
    }

    public double relabel(EdgeSegment fromSegment, BushFlowLabel oldFromLabel, EdgeSegment toSegment, BushFlowLabel oldToLabel, BushFlowLabel newFromToLabel) {
        return this.bushData.relabel(fromSegment, oldFromLabel, toSegment, oldToLabel, newFromToLabel);
    }

    public double relabelFrom(EdgeSegment fromSegment, BushFlowLabel oldFromLabel, EdgeSegment toSegment, BushFlowLabel toLabel, BushFlowLabel newFromLabel) {
        return this.bushData.relabelFrom(fromSegment, oldFromLabel, toSegment, toLabel, newFromLabel);
    }

    public double relabelTo(EdgeSegment fromSegment, BushFlowLabel fromLabel, EdgeSegment toSegment, BushFlowLabel oldToLabel, BushFlowLabel newToLabel) {
        return this.bushData.relabelTo(fromSegment, fromLabel, toSegment, oldToLabel, newToLabel);
    }

    @Override
    public void syncToNetworkFlows(double[] flowAcceptanceFactors) {
        Iterator<? extends DirectedVertex> vertexIter = this.getTopologicalIterator(true);
        if (vertexIter == null) {
            LOGGER.severe(String.format("Topologically sorted vertices on bush not available, this shouldn't happen, skip turn flow update", new Object[0]));
            return;
        }
        DirectedVertex currVertex = vertexIter.next();
        boolean AllowTurnRemoval = false;
        while (vertexIter.hasNext()) {
            currVertex = vertexIter.next();
            for (EdgeSegment entrySegment : currVertex.getEntryEdgeSegments()) {
                TreeSet<BushFlowLabel> usedLabels;
                if (!this.containsEdgeSegment(entrySegment) || (usedLabels = this.getFlowCompositionLabels(entrySegment)) == null) continue;
                for (BushFlowLabel entrylabel : usedLabels) {
                    double entryLabelAcceptedFlow = this.bushData.getTotalAcceptedFlowToPcuH(entrySegment, entrylabel, flowAcceptanceFactors);
                    MultiKeyMap<Object, Double> splittingRates = this.getSplittingRates(entrySegment, entrylabel);
                    for (EdgeSegment exitSegment : currVertex.getExitEdgeSegments()) {
                        TreeSet<BushFlowLabel> exitLabels;
                        if (!this.containsEdgeSegment(exitSegment) || (exitLabels = this.getFlowCompositionLabels(exitSegment)) == null) continue;
                        for (BushFlowLabel exitLabel : exitLabels) {
                            Double bushExitSegmentLabelSplittingRate = (Double)splittingRates.get((Object)exitSegment, (Object)exitLabel);
                            if (bushExitSegmentLabelSplittingRate == null || !Precision.positive((double)bushExitSegmentLabelSplittingRate)) continue;
                            double bushTurnLabeledAcceptedFlow = entryLabelAcceptedFlow * bushExitSegmentLabelSplittingRate;
                            this.bushData.setTurnSendingFlow(entrySegment, entrylabel, exitSegment, exitLabel, bushTurnLabeledAcceptedFlow, false);
                        }
                    }
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.bushData.hasTurnFlows();
    }
}

