/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.UntypedACyclicSubGraph;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;

public abstract class RootedBush<V extends DirectedVertex, ES extends EdgeSegment>
implements Bush {
    private static final Logger LOGGER = Logger.getLogger(RootedBush.class.getCanonicalName());
    private final UntypedACyclicSubGraph<V, ES> dag;
    protected Map<CentroidVertex, Double> originDemandsPcuH;
    protected final IdGroupingToken bushGroupingToken;
    protected boolean requireTopologicalSortUpdate = false;

    protected void addOriginDemandPcuH(CentroidVertex originCentroidVertex, double demandPcuH) {
        double currentDemandPcuH = this.originDemandsPcuH.getOrDefault(originCentroidVertex, 0.0);
        this.originDemandsPcuH.put(originCentroidVertex, currentDemandPcuH + demandPcuH);
    }

    protected UntypedACyclicSubGraph<V, ES> getDag() {
        return this.dag;
    }

    public abstract void syncToNetworkFlows(double[] var1);

    public RootedBush(IdGroupingToken idToken, DirectedVertex rootVertex, boolean inverted, UntypedACyclicSubGraph<V, ES> dag) {
        this.dag = dag;
        this.bushGroupingToken = IdGenerator.createIdGroupingToken((Object)this, (long)dag.getId());
        this.originDemandsPcuH = new HashMap<CentroidVertex, Double>();
    }

    public RootedBush(RootedBush<V, ES> other, boolean deepCopy) {
        this.originDemandsPcuH = new HashMap<CentroidVertex, Double>(other.originDemandsPcuH);
        this.requireTopologicalSortUpdate = other.requireTopologicalSortUpdate;
        this.bushGroupingToken = other.bushGroupingToken;
        this.dag = deepCopy ? other.getDag().deepClone() : other.dag.shallowClone();
    }

    public abstract MinMaxPathResult computeMinMaxShortestPaths(double[] var1, int var2);

    @Override
    public abstract RootedBush<V, ES> shallowClone();

    @Override
    public abstract RootedBush<V, ES> deepClone();

    public long getId() {
        return this.dag.getId();
    }

    public V getRootVertex() {
        return (V)((DirectedVertex)this.dag.getRootVertices().iterator().next());
    }

    public boolean isInverted() {
        return this.dag.isDirectionInverted();
    }

    public Set<CentroidVertex> getOriginVertices() {
        return this.originDemandsPcuH.keySet();
    }

    public Double getOriginDemandPcuH(CentroidVertex originVertex) {
        return this.originDemandsPcuH.get(originVertex);
    }

    public Iterator<V> getDirectedVertexIterator() {
        return this.getDag().iterator();
    }

    protected abstract CentroidVertex getRootZoneVertex();
}

