/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.algorithms.shortest.ShortestPathSearchUtils;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;

public class PasManager {
    private static final Logger LOGGER = Logger.getLogger(PasManager.class.getCanonicalName());
    private static final double MU = 0.5;
    private static final double NU = 0.25;
    private Map<DirectedVertex, Collection<Pas>> passByVertex;
    private final boolean registerByDiverge;
    private Function<Pas, DirectedVertex> getReferenceVertex;
    private static final Comparator<Pas> PAS_REDUCED_COST_COMPARATOR = new Comparator<Pas>(){

        @Override
        public int compare(Pas p1, Pas p2) {
            if (Precision.greater((double)p1.getReducedCost(), (double)p2.getReducedCost(), (double)1.0E-15)) {
                return -1;
            }
            if (Precision.smaller((double)p1.getReducedCost(), (double)p2.getReducedCost(), (double)1.0E-15)) {
                return 1;
            }
            return 0;
        }
    };
    private boolean detailedLogging = false;
    public static final boolean DETAILED_LOGGING = false;

    private boolean isFlowEffective(Pas pas, RootedLabelledBush originBush, double[] flowAcceptanceFactors) {
        boolean lowCostPath = true;
        double s2SubPathAcceptedFlowOnBush = pas.computeOverlappingAcceptedFlow(originBush, !lowCostPath, flowAcceptanceFactors);
        EdgeSegment s2LastEdgeSegment = pas.getLastEdgeSegment(!lowCostPath);
        double s2LastSegmentSendingFlowOnBush = originBush.getSendingFlowPcuH(s2LastEdgeSegment);
        double s2LastSegmentAcceptedFlowOnBush = s2LastSegmentSendingFlowOnBush * flowAcceptanceFactors[(int)s2LastEdgeSegment.getId()];
        return Precision.greater((double)s2SubPathAcceptedFlowOnBush, (double)(0.25 * s2LastSegmentAcceptedFlowOnBush));
    }

    private boolean isPasEffectiveForBush(Pas pas, RootedLabelledBush originBush, double[] flowAcceptanceFactors, double reducedCost) {
        return PasManager.isCostEffective(pas.getAlternativeHighCost(), pas.getAlternativeLowCost(), reducedCost) && this.isFlowEffective(pas, originBush, flowAcceptanceFactors);
    }

    private DirectedVertex getReferenceVertexFromAlternative(List<EdgeSegment> alternative) {
        DirectedVertex referenceVertex = null;
        referenceVertex = this.registerByDiverge ? alternative.get(0).getUpstreamVertex() : alternative.get(alternative.size() - 1).getDownstreamVertex();
        return referenceVertex;
    }

    private DirectedVertex getReferenceVertexFromAlternative(EdgeSegment[] alternative) {
        DirectedVertex referenceVertex = null;
        referenceVertex = this.registerByDiverge ? alternative[0].getUpstreamVertex() : alternative[alternative.length - 1].getDownstreamVertex();
        return referenceVertex;
    }

    public static boolean isCostEffective(double alternativeHighCost, double alternativeLowCost, double reducedCost) {
        return Precision.greater((double)(alternativeHighCost - alternativeLowCost), (double)(0.5 * reducedCost));
    }

    public static EdgeSegment[] createSubpathArrayFrom(DirectedVertex closestToSearchRoot, DirectedVertex furthestFromSearchRoot, ShortestPathResult searchResultTree, int arrayLength, boolean truncateArray) {
        EdgeSegment currEdgeSegment = null;
        EdgeSegment[] edgeSegmentArray = new EdgeSegment[arrayLength];
        DirectedVertex currVertex = furthestFromSearchRoot;
        boolean searchInverted = searchResultTree.getSearchType().isInverted();
        int index = arrayLength - 1;
        if (searchInverted) {
            index = 0;
        }
        do {
            edgeSegmentArray[index] = currEdgeSegment = searchResultTree.getNextEdgeSegmentForVertex((Vertex)currVertex);
            if (currEdgeSegment == null) {
                LOGGER.warning(String.format("Unable to extract subpath from start vertex %s to end vertex %s, no incoming edge segment available at intermediate vertex %s", closestToSearchRoot.getXmlId(), furthestFromSearchRoot.getXmlId(), currVertex.getXmlId()));
                return null;
            }
            currVertex = searchResultTree.getNextVertexForEdgeSegment(currEdgeSegment);
            if (searchInverted) {
                ++index;
                continue;
            }
            --index;
        } while (!currVertex.idEquals((Object)closestToSearchRoot));
        if (truncateArray) {
            if (!searchInverted && index > 0) {
                return Arrays.copyOfRange(edgeSegmentArray, index + 1, edgeSegmentArray.length);
            }
            if (searchInverted && index < arrayLength) {
                return Arrays.copyOfRange(edgeSegmentArray, 0, index);
            }
        }
        return edgeSegmentArray;
    }

    public static EdgeSegment[] createSubpathArrayFrom(DirectedVertex closestToSearchRoot, DirectedVertex furthestFromSearchRoot, ShortestSearchType shortestSearchType, Map<DirectedVertex, EdgeSegment> invertedBfSearchResultTree, int arrayLength, boolean truncateArray) {
        boolean searchInverted = shortestSearchType.isInverted();
        EdgeSegment[] edgeSegmentArray = new EdgeSegment[arrayLength];
        EdgeSegment currEdgeSegment = null;
        Function<EdgeSegment, DirectedVertex> getNextVertex = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(shortestSearchType);
        int index = 0;
        DirectedVertex currVertex = closestToSearchRoot;
        if (searchInverted) {
            index = arrayLength - 1;
        }
        boolean nextAvailable = true;
        do {
            edgeSegmentArray[index] = currEdgeSegment = invertedBfSearchResultTree.get(currVertex);
            if (currEdgeSegment == null) {
                LOGGER.warning(String.format("Unable to extract subpath between vertices (%s, %s), no edge segment available at intermediate vertex %s", closestToSearchRoot.getXmlId(), furthestFromSearchRoot.getXmlId(), currVertex.getXmlId()));
                return null;
            }
            currVertex = getNextVertex.apply(currEdgeSegment);
            if (searchInverted) {
                nextAvailable = --index >= 0;
                continue;
            }
            boolean bl = nextAvailable = ++index < arrayLength;
        } while (!currVertex.idEquals((Object)furthestFromSearchRoot) && nextAvailable);
        if (!currVertex.idEquals((Object)furthestFromSearchRoot)) {
            LOGGER.warning(String.format("Unable to create subpath array between nodes (%s, %s) from given pathTree", closestToSearchRoot.toString(), furthestFromSearchRoot.toString()));
            return null;
        }
        if (truncateArray && nextAvailable) {
            if (searchInverted) {
                return Arrays.copyOfRange(edgeSegmentArray, index + 1, arrayLength);
            }
            return Arrays.copyOfRange(edgeSegmentArray, 0, index);
        }
        return edgeSegmentArray;
    }

    public PasManager(boolean registerByDiverge) {
        this.registerByDiverge = registerByDiverge;
        this.getReferenceVertex = registerByDiverge ? p -> p.getDivergeVertex() : p -> p.getMergeVertex();
        this.passByVertex = new HashMap<DirectedVertex, Collection<Pas>>();
    }

    public Pas createAndRegisterNewPas(RootedLabelledBush bush, EdgeSegment[] s1, EdgeSegment[] s2) {
        Pas newPas = Pas.create(s1, s2);
        if (newPas == null) {
            return null;
        }
        newPas.registerBush(bush);
        this.passByVertex.putIfAbsent(this.getReferenceVertex.apply(newPas), new ArrayList());
        this.passByVertex.get(this.getReferenceVertex.apply(newPas)).add(newPas);
        return newPas;
    }

    public Pas createAndRegisterNewPas(RootedLabelledBush bush, Collection<EdgeSegment> s1, Collection<EdgeSegment> s2) {
        return this.createAndRegisterNewPas(bush, s1.toArray(new EdgeSegment[s1.size()]), s2.toArray(new EdgeSegment[s2.size()]));
    }

    public void removePas(Pas pas, boolean logRemovedPas) {
        this.passByVertex.get(this.getReferenceVertex.apply(pas)).remove(pas);
        if (logRemovedPas) {
            LOGGER.info(String.format("Removed existing PAS: %s", pas.toString()));
        }
    }

    public Collection<Pas> getPassByReferenceVertex(DirectedVertex referenceVertex) {
        return this.passByVertex.get(referenceVertex);
    }

    public Pas findExistingPas(List<EdgeSegment> alternative1, List<EdgeSegment> alternative2) {
        if (alternative1 == null || alternative2 == null) {
            LOGGER.severe("one or more alternatives of potential PAS are null");
            return null;
        }
        if (alternative1.isEmpty() || alternative2.isEmpty()) {
            LOGGER.severe("one or more alternatives of potential PAS are empty");
            return null;
        }
        Collection<Pas> potentialPass = this.getPassByReferenceVertex(this.getReferenceVertexFromAlternative(alternative1));
        if (potentialPass == null) {
            return null;
        }
        for (Pas potentialPas : potentialPass) {
            if (potentialPas.isAlternativeEqual(alternative1, true) && potentialPas.isAlternativeEqual(alternative2, false)) {
                return potentialPas;
            }
            if (!potentialPas.isAlternativeEqual(alternative2, true) || !potentialPas.isAlternativeEqual(alternative1, false)) continue;
            return potentialPas;
        }
        return null;
    }

    public Pas findExistingPas(EdgeSegment[] alternative1, EdgeSegment[] alternative2) {
        if (alternative1 == null || alternative2 == null) {
            LOGGER.severe("one or more alternatives of potential PAS are null");
            return null;
        }
        Collection<Pas> potentialPass = this.getPassByReferenceVertex(this.getReferenceVertexFromAlternative(alternative1));
        if (potentialPass == null) {
            return null;
        }
        for (Pas potentialPas : potentialPass) {
            if (potentialPas.isAlternativeEqual(alternative1, true) && potentialPas.isAlternativeEqual(alternative2, false)) {
                return potentialPas;
            }
            if (!potentialPas.isAlternativeEqual(alternative2, true) || !potentialPas.isAlternativeEqual(alternative1, false)) continue;
            return potentialPas;
        }
        return null;
    }

    public boolean isRegisteredOnAnyPasAtReferenceVertex(RootedLabelledBush bush, DirectedVertex referenceVertex) {
        Collection<Pas> potentialPass = this.getPassByReferenceVertex(referenceVertex);
        if (potentialPass == null) {
            return false;
        }
        for (Pas pas : potentialPass) {
            if (!pas.hasRegisteredBush(bush)) continue;
            return true;
        }
        return false;
    }

    public Pas findFirstSuitableExistingPas(RootedLabelledBush bush, DirectedVertex referenceVertex, double[] flowAcceptanceFactors, double reducedCost) {
        Collection<Pas> potentialPass = this.getPassByReferenceVertex(referenceVertex);
        if (potentialPass == null) {
            return null;
        }
        Pas matchedPas = null;
        for (Pas pas : potentialPass) {
            if (pas.hasRegisteredBush(bush)) continue;
            boolean pasPotentialMatch = false;
            for (EdgeSegment pasFirstExitSegment : pas.getDivergeVertex().getExitEdgeSegments()) {
                if (!bush.containsEdgeSegment(pasFirstExitSegment)) continue;
                pasPotentialMatch = true;
                break;
            }
            if (!pasPotentialMatch) continue;
            for (EdgeSegment pasLastEntrySegment : pas.getMergeVertex().getEntryEdgeSegments()) {
                if (!bush.containsEdgeSegment(pasLastEntrySegment)) continue;
                pasPotentialMatch = true;
                break;
            }
            if (!pasPotentialMatch || !this.isPasEffectiveForBush(pas, bush, flowAcceptanceFactors, reducedCost) || bush.determineIntroduceCycle(pas.getAlternative(true)) != null) continue;
            matchedPas = pas;
            break;
        }
        return matchedPas;
    }

    public void updateCosts(double[] linkSegmentCosts) {
        for (Collection<Pas> pass : this.passByVertex.values()) {
            this.updateCosts(pass, linkSegmentCosts);
        }
    }

    public void updateCosts(Collection<Pas> pass, double[] linkSegmentCosts) {
        for (Pas pas : pass) {
            pas.updateCost(linkSegmentCosts);
        }
    }

    public Collection<Pas> getPassSortedByReducedCost() {
        ArrayList<Pas> sortedList = new ArrayList<Pas>((int)this.getNumberOfPass());
        this.forEachPas(pas -> sortedList.add((Pas)pas));
        Collections.sort(sortedList, PAS_REDUCED_COST_COMPARATOR);
        return sortedList;
    }

    public void forEachPas(Consumer<Pas> pasConsumer) {
        this.passByVertex.forEach((v, pc) -> pc.forEach(pasConsumer));
    }

    public long getNumberOfPass() {
        long numPass = 0L;
        for (Collection<Pas> pass : this.passByVertex.values()) {
            numPass += (long)pass.size();
        }
        return numPass;
    }

    public boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    public void setDetailedLogging(boolean detailedLogging) {
        this.detailedLogging = detailedLogging;
    }
}

