/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.CollectionUtils;

public class PasFlowShiftOriginBasedSmartLabelledExecutor
extends PasFlowShiftExecutor {
    private static final Logger LOGGER = Logger.getLogger(PasFlowShiftOriginBasedSmartLabelledExecutor.class.getCanonicalName());
    protected final Map<RootedLabelledBush, List<LinkedList<BushFlowLabel>>> s2ReverseLabelChains;
    protected final Map<RootedLabelledBush, List<LinkedList<BushFlowLabel>>> s1ReverseLabelChains = new HashMap<RootedLabelledBush, List<LinkedList<BushFlowLabel>>>();

    private TreeMap<BushFlowLabel, Double> initialiseS1Labelling(RootedLabelledBush origin, List<LinkedList<BushFlowLabel>> s1UsedLabelChainsToFill) {
        BushFlowLabel pasS1Label = BushFlowLabel.create(origin.bushGroupingToken);
        LinkedList<BushFlowLabel> s1LabelChain = new LinkedList<BushFlowLabel>();
        s1LabelChain.addFirst(pasS1Label);
        s1UsedLabelChainsToFill.add(s1LabelChain);
        TreeMap<BushFlowLabel, Double> pasS1EndLabelRates = new TreeMap<BushFlowLabel, Double>();
        pasS1EndLabelRates.put(pasS1Label, 1.0);
        return pasS1EndLabelRates;
    }

    private List<LinkedList<BushFlowLabel>> determineUsedLabelChains(RootedLabelledBush origin, EdgeSegment[] subPath) {
        TreeSet<BushFlowLabel> edgeSegmentCompositionLabels = origin.getFlowCompositionLabels(subPath[0]);
        ArrayList<LinkedList<BushFlowLabel>> pasCompositionLabels = new ArrayList<LinkedList<BushFlowLabel>>();
        if (edgeSegmentCompositionLabels == null || edgeSegmentCompositionLabels.isEmpty()) {
            return pasCompositionLabels;
        }
        Iterator<BushFlowLabel> labelIter = edgeSegmentCompositionLabels.iterator();
        while (labelIter.hasNext()) {
            BushFlowLabel firstSegmentLabel;
            BushFlowLabel currentLabel = firstSegmentLabel = labelIter.next();
            LinkedList<BushFlowLabel> transitionLabels = new LinkedList<BushFlowLabel>();
            transitionLabels.add(firstSegmentLabel);
            EdgeSegment currentSegment = subPath[0];
            EdgeSegment succeedingSegment = null;
            for (int index = 1; index < subPath.length; ++index) {
                succeedingSegment = subPath[index];
                if (!origin.containsTurnSendingFlow(currentSegment, currentLabel, succeedingSegment, currentLabel)) {
                    BushFlowLabel transitionLabel = null;
                    TreeSet<BushFlowLabel> potentialLabelTransitions = origin.getFlowCompositionLabels(succeedingSegment);
                    if (potentialLabelTransitions != null) {
                        for (BushFlowLabel potentialLabel : potentialLabelTransitions) {
                            if (!origin.containsTurnSendingFlow(currentSegment, currentLabel, succeedingSegment, potentialLabel)) continue;
                            transitionLabel = potentialLabel;
                            transitionLabels.addFirst(transitionLabel);
                        }
                    }
                    if (transitionLabel == null) {
                        transitionLabels = null;
                        break;
                    }
                    currentLabel = transitionLabel;
                }
                currentSegment = succeedingSegment;
            }
            if (CollectionUtils.nullOrEmpty(transitionLabels)) continue;
            pasCompositionLabels.add(transitionLabels);
        }
        return pasCompositionLabels;
    }

    private MultiKeyMap<Object, Double> createS2DivergeProportionsByTurnLabels(RootedLabelledBush origin, List<LinkedList<BushFlowLabel>> pasS2UsedLabelChains, Map<BushFlowLabel, Double> pasS2EndLabelRates, double[] flowAcceptanceFactors) {
        EdgeSegment firstS2EdgeSegment = this.pas.getFirstEdgeSegment(false);
        MultiKeyMap s2DivergeTurnLabelProportionsToPopulate = new MultiKeyMap();
        double s2InitialSegmentTotalFlow = 0.0;
        for (EdgeSegment entrySegment : this.pas.getDivergeVertex().getEntryEdgeSegments()) {
            if (!origin.containsEdgeSegment(entrySegment)) continue;
            double alpha = flowAcceptanceFactors[(int)entrySegment.getId()];
            TreeSet<BushFlowLabel> entryLabels = origin.getFlowCompositionLabels(entrySegment);
            for (BushFlowLabel entryLabel : entryLabels) {
                for (LinkedList<BushFlowLabel> usedLabelPredecessors : pasS2UsedLabelChains) {
                    BushFlowLabel s2EndLabel;
                    double s2CompatiblePortion;
                    double s2CompatibleTurnAcceptedFlow;
                    double turnSendingFlow = origin.getTurnSendingFlow(entrySegment, entryLabel, firstS2EdgeSegment, usedLabelPredecessors.getLast());
                    if (!Precision.positive((double)turnSendingFlow) || !Precision.positive((double)(s2CompatibleTurnAcceptedFlow = turnSendingFlow * (s2CompatiblePortion = pasS2EndLabelRates.get(s2EndLabel = usedLabelPredecessors.getFirst()).doubleValue()) * alpha))) continue;
                    Double currentFlow = (Double)s2DivergeTurnLabelProportionsToPopulate.get((Object)entrySegment, (Object)entryLabel);
                    if (currentFlow == null) {
                        currentFlow = 0.0;
                    }
                    s2DivergeTurnLabelProportionsToPopulate.put((Object)entrySegment, (Object)entryLabel, (Object)(currentFlow + s2CompatibleTurnAcceptedFlow));
                    s2InitialSegmentTotalFlow += s2CompatibleTurnAcceptedFlow;
                }
            }
        }
        MapIterator iter = s2DivergeTurnLabelProportionsToPopulate.mapIterator();
        while (iter.hasNext()) {
            iter.next();
            iter.setValue((Object)((Double)iter.getValue() / s2InitialSegmentTotalFlow));
        }
        return s2DivergeTurnLabelProportionsToPopulate;
    }

    private void relabelIfNotTerminating(RootedLabelledBush origin, DirectedVertex vertex, EdgeSegment exitSegment, MultiKeyMap<Object, Double> eligibleLabels) {
        if (!this.pas.getDivergeVertex().hasEntryEdgeSegments()) {
            return;
        }
        MultiKeyMap updatedLabels = new MultiKeyMap();
        MapIterator iter = eligibleLabels.mapIterator();
        MultiKey multiKey = null;
        while (iter.hasNext()) {
            BushFlowLabel currEntryLabel;
            EdgeSegment entrySegment;
            iter.next();
            Double portion = (Double)iter.getValue();
            if (portion == null || !Precision.positive((double)portion) || !Precision.positive((double)origin.getTurnSendingFlow(entrySegment = (EdgeSegment)(multiKey = (MultiKey)iter.getKey()).getKey(0), currEntryLabel = (BushFlowLabel)multiKey.getKey(1), exitSegment, currEntryLabel))) continue;
            BushFlowLabel newLabel = BushFlowLabel.create(origin.bushGroupingToken);
            origin.relabelFrom(entrySegment, currEntryLabel, exitSegment, currEntryLabel, newLabel);
            this.relabelWhileNotTerminatingWith(origin, entrySegment.getUpstreamVertex(), entrySegment, currEntryLabel, newLabel);
            updatedLabels.put((Object)entrySegment, (Object)newLabel, (Object)portion);
            iter.remove();
        }
        if (!updatedLabels.isEmpty()) {
            eligibleLabels.putAll((Map)updatedLabels);
        }
    }

    private void relabelWhileNotTerminatingWith(RootedLabelledBush origin, DirectedVertex vertex, EdgeSegment exitSegment, BushFlowLabel oldLabel, BushFlowLabel newLabel) {
        for (EdgeSegment entrySegment : vertex.getEntryEdgeSegments()) {
            if (!origin.containsEdgeSegment(entrySegment)) continue;
            if (Precision.positive((double)origin.getTurnSendingFlow(entrySegment, oldLabel, exitSegment, oldLabel))) {
                origin.relabel(entrySegment, oldLabel, exitSegment, oldLabel, newLabel);
                this.relabelWhileNotTerminatingWith(origin, entrySegment.getUpstreamVertex(), entrySegment, oldLabel, newLabel);
                continue;
            }
            TreeSet<BushFlowLabel> entryLabels = origin.getFlowCompositionLabels(entrySegment);
            for (BushFlowLabel entryLabel : entryLabels) {
                if (!Precision.positive((double)origin.getTurnSendingFlow(entrySegment, entryLabel, exitSegment, oldLabel))) continue;
                origin.relabelTo(entrySegment, entryLabel, exitSegment, oldLabel, newLabel);
            }
        }
    }

    private void executeBushLabeledS2FlowShiftEndMerge(RootedLabelledBush origin, BushFlowLabel finalSegmentLabel, double s2FinalLabeledFlowShift, Map<BushFlowLabel, double[]> exitShiftedSendingFlowToPopulate) {
        EdgeSegment lastS2Segment = this.pas.getLastEdgeSegment(false);
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            MultiKeyMap<Object, Double> splittingRates = origin.getSplittingRates(lastS2Segment, finalSegmentLabel);
            int index = 0;
            for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                if (origin.containsEdgeSegment(exitSegment)) {
                    TreeSet<BushFlowLabel> exitLabels = origin.getFlowCompositionLabels(exitSegment);
                    for (BushFlowLabel exitLabel : exitLabels) {
                        double[] exitLabelExitSegmentShiftedSendingFlow;
                        Double labeledSplittingRate = (Double)splittingRates.get((Object)exitSegment, (Object)exitLabel);
                        if (labeledSplittingRate == null || !Precision.positive((double)labeledSplittingRate)) continue;
                        double s2FlowShift = s2FinalLabeledFlowShift * labeledSplittingRate;
                        double newLabelledTurnFlow = origin.addTurnSendingFlow(lastS2Segment, finalSegmentLabel, exitSegment, exitLabel, s2FlowShift, this.isPasS2RemovalAllowed());
                        if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12) && !Precision.positive((double)origin.getTurnSendingFlow(lastS2Segment, exitSegment), (double)1.0E-12)) {
                            origin.removeTurn(lastS2Segment, exitSegment);
                        }
                        if ((exitLabelExitSegmentShiftedSendingFlow = exitShiftedSendingFlowToPopulate.get(exitLabel)) == null) {
                            exitLabelExitSegmentShiftedSendingFlow = new double[this.pasMergeVertexNumExitSegments];
                            exitShiftedSendingFlowToPopulate.put(exitLabel, exitLabelExitSegmentShiftedSendingFlow);
                        }
                        int n = index;
                        exitLabelExitSegmentShiftedSendingFlow[n] = exitLabelExitSegmentShiftedSendingFlow[n] + -s2FlowShift;
                    }
                }
                ++index;
            }
        }
    }

    private void executeBushLabeledS1FlowShiftEndMerge(RootedLabelledBush origin, BushFlowLabel finalSegmentLabel, double s1FinalLabeledFlowShift, Map<BushFlowLabel, double[]> usedLabelSplittingRates) {
        EdgeSegment lastS1Segment = this.pas.getLastEdgeSegment(true);
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            for (Map.Entry<BushFlowLabel, double[]> entry : usedLabelSplittingRates.entrySet()) {
                BushFlowLabel exitLabel = entry.getKey();
                double[] exitLabelSplittingRates = entry.getValue();
                int index = 0;
                for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                    double s1FlowShift;
                    double newLabelledTurnFlow;
                    double splittingRate = exitLabelSplittingRates[index];
                    if (Precision.positive((double)splittingRate) && !Precision.positive((double)(newLabelledTurnFlow = origin.addTurnSendingFlow(lastS1Segment, finalSegmentLabel, exitSegment, exitLabel, s1FlowShift = s1FinalLabeledFlowShift * splittingRate)), (double)1.0E-12)) {
                        LOGGER.severe("Flow shift towards cheaper S1 alternative should always result in non-negative remaining flow, but this was not found, this shouldn't happen");
                    }
                    ++index;
                }
            }
        }
    }

    private void executeBushLabeledS2FlowShiftStartDiverge(RootedLabelledBush origin, BushFlowLabel startSegmentLabel, double s2StartLabeledFlowShift, MultiKeyMap<Object, Double> s2DivergeProportionsByTurnLabels, double[] flowAcceptanceFactors) {
        EdgeSegment firstS2Segment = this.pas.getFirstEdgeSegment(false);
        for (EdgeSegment entrySegment : this.pas.getDivergeVertex().getEntryEdgeSegments()) {
            if (!origin.containsEdgeSegment(entrySegment)) continue;
            TreeSet<BushFlowLabel> entryLabels = origin.getFlowCompositionLabels(entrySegment);
            for (BushFlowLabel entryLabel : entryLabels) {
                Double portion = (Double)s2DivergeProportionsByTurnLabels.get((Object)entrySegment, (Object)entryLabel);
                if (portion == null) continue;
                double existingTotalTurnLabeledSendingFlow = origin.getTurnSendingFlow(entrySegment, entryLabel, firstS2Segment, startSegmentLabel);
                if (!Precision.positive((double)existingTotalTurnLabeledSendingFlow)) {
                    LOGGER.severe("Expected available turn sending flow for given label combination, found none, skip flow shift at PAS s2 diverge");
                    continue;
                }
                double s2DivergeEntryLabeledFlowShift = s2StartLabeledFlowShift * portion * (1.0 / flowAcceptanceFactors[(int)entrySegment.getId()]);
                double newLabelledTurnFlow = origin.addTurnSendingFlow(entrySegment, entryLabel, firstS2Segment, startSegmentLabel, s2DivergeEntryLabeledFlowShift, this.isPasS2RemovalAllowed());
                if (!this.isPasS2RemovalAllowed() || Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12) || Precision.positive((double)origin.getTurnSendingFlow(entrySegment, firstS2Segment), (double)1.0E-12)) continue;
                origin.removeTurn(entrySegment, firstS2Segment);
            }
        }
    }

    private void executeBushLabeledS1FlowShiftStartDiverge(RootedLabelledBush origin, BushFlowLabel startSegmentLabel, double s1StartLabeledFlowShift, MultiKeyMap<Object, Double> divergeProportionsByTurnLabels, double[] flowAcceptanceFactors) {
        EdgeSegment firstS1Segment = this.pas.getFirstEdgeSegment(true);
        for (EdgeSegment entrySegment : this.pas.getDivergeVertex().getEntryEdgeSegments()) {
            if (!origin.containsEdgeSegment(entrySegment)) continue;
            TreeSet<BushFlowLabel> entryLabels = origin.getFlowCompositionLabels(entrySegment);
            for (BushFlowLabel entryLabel : entryLabels) {
                Double portion = (Double)divergeProportionsByTurnLabels.get((Object)entrySegment, (Object)entryLabel);
                if (portion == null) continue;
                double s1DivergeEntryLabeledFlowShift = s1StartLabeledFlowShift * portion * (1.0 / flowAcceptanceFactors[(int)entrySegment.getId()]);
                if (Precision.negative((double)s1DivergeEntryLabeledFlowShift)) {
                    LOGGER.severe("Expected non-negative shift on s1 turn for given label combination, skip flow shift at PAS s1 diverge");
                    continue;
                }
                double newLabelledTurnFlow = origin.addTurnSendingFlow(entrySegment, entryLabel, firstS1Segment, startSegmentLabel, s1DivergeEntryLabeledFlowShift);
                if (Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12)) continue;
                LOGGER.severe("Flow shift towards cheaper S1 alternative should always result in non-negative remaining flow, but this was not found, this shouldn't happen");
            }
        }
    }

    private double executeBushLabeledAlternativeFlowShift(RootedLabelledBush origin, List<BushFlowLabel> reverseOrderCompositionLabels, double flowShiftPcuH, EdgeSegment[] pasSegment, double[] flowAcceptanceFactors, boolean forceInitialLabel) {
        BushFlowLabel currCompositionLabel;
        int index = 0;
        EdgeSegment currentSegment = null;
        EdgeSegment nextSegment = pasSegment[index];
        ReverseListIterator reverseLabelIter = new ReverseListIterator(reverseOrderCompositionLabels);
        BushFlowLabel nextCompositionLabel = currCompositionLabel = (BushFlowLabel)reverseLabelIter.next();
        while (++index < pasSegment.length) {
            currentSegment = nextSegment;
            nextSegment = pasSegment[index];
            double turnSendingFlow = origin.getTurnSendingFlow(currentSegment, currCompositionLabel, nextSegment, currCompositionLabel);
            if (!forceInitialLabel && !Precision.positive((double)turnSendingFlow)) {
                BushFlowLabel bushFlowLabel = nextCompositionLabel = reverseLabelIter.hasNext() ? (BushFlowLabel)reverseLabelIter.next() : null;
                if (nextCompositionLabel != null && origin.containsTurnSendingFlow(currentSegment, currCompositionLabel, nextSegment, nextCompositionLabel)) {
                    turnSendingFlow = origin.getTurnSendingFlow(currentSegment, currCompositionLabel, nextSegment, nextCompositionLabel);
                } else {
                    LOGGER.warning("Unable to trace PAS s2 flow through alternative with the given flow composition chain, aborting flow shift");
                }
            }
            double newLabelledTurnFlow = origin.addTurnSendingFlow(currentSegment, currCompositionLabel, nextSegment, nextCompositionLabel, flowShiftPcuH, this.isPasS2RemovalAllowed());
            if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12) && !Precision.positive((double)origin.getTurnSendingFlow(currentSegment, nextSegment), (double)1.0E-12)) {
                origin.removeTurn(currentSegment, nextSegment);
            }
            flowShiftPcuH *= flowAcceptanceFactors[(int)currentSegment.getId()];
            currCompositionLabel = nextCompositionLabel;
        }
        return flowShiftPcuH;
    }

    @Override
    protected void executeBushFlowShift(RootedLabelledBush origin, EdgeSegment entrySegment, double bushFlowShift, double[] flowAcceptanceFactors) {
        EdgeSegment lastS1Segment = this.pas.getLastEdgeSegment(true);
        EdgeSegment lastS2Segment = this.pas.getLastEdgeSegment(false);
        EdgeSegment firstS2Segment = this.pas.getFirstEdgeSegment(false);
        EdgeSegment[] s2 = this.pas.getAlternative(false);
        EdgeSegment[] s1 = this.pas.getAlternative(true);
        List<LinkedList<BushFlowLabel>> bushS2ReverseLabelChains = this.s2ReverseLabelChains.get(origin);
        Set<BushFlowLabel> bushS2UsedEndLabels = bushS2ReverseLabelChains.stream().map(chain -> (BushFlowLabel)chain.get(0)).collect(Collectors.toSet());
        List<LinkedList<BushFlowLabel>> bushS1ReverseLabelChains = this.s1ReverseLabelChains.get(origin);
        boolean s1SegmentNotUsedYet = bushS1ReverseLabelChains.isEmpty();
        TreeMap<BushFlowLabel, Double> bushS2LastSegmentLabelPortions = origin.determineProportionalFlowCompositionRates(lastS2Segment, bushS2UsedEndLabels);
        MultiKeyMap<Object, Double> s2DivergeProportionsByTurnLabels = null;
        if (this.pas.getDivergeVertex().hasEntryEdgeSegments()) {
            s2DivergeProportionsByTurnLabels = this.createS2DivergeProportionsByTurnLabels(origin, bushS2ReverseLabelChains, bushS2LastSegmentLabelPortions, flowAcceptanceFactors);
        }
        TreeMap<BushFlowLabel, double[]> bushS2MergeExitShiftedSendingFlows = new TreeMap<BushFlowLabel, double[]>();
        for (LinkedList<BushFlowLabel> s2UsedReverseLabelChain : bushS2ReverseLabelChains) {
            Iterator finalS2Label = s2UsedReverseLabelChain.getFirst();
            BushFlowLabel startS2Label = s2UsedReverseLabelChain.getLast();
            double s2StartLabeledFlowShift = -bushS2LastSegmentLabelPortions.get(finalS2Label).doubleValue() * bushFlowShift;
            double s2FinalLabeledFlowShift = this.executeBushLabeledAlternativeFlowShift(origin, s2UsedReverseLabelChain, s2StartLabeledFlowShift, s2, flowAcceptanceFactors, false);
            LOGGER.info(String.format("** S2 SHIFT: label start %d, end %d, flow shift start %.10f, end %.10f", startS2Label.getLabelId(), ((BushFlowLabel)((Object)finalS2Label)).getLabelId(), s2StartLabeledFlowShift, s2FinalLabeledFlowShift));
            this.executeBushLabeledS2FlowShiftEndMerge(origin, (BushFlowLabel)((Object)finalS2Label), s2FinalLabeledFlowShift, (Map<BushFlowLabel, double[]>)bushS2MergeExitShiftedSendingFlows);
            if (s2DivergeProportionsByTurnLabels.isEmpty()) continue;
            this.executeBushLabeledS2FlowShiftStartDiverge(origin, startS2Label, s2StartLabeledFlowShift, s2DivergeProportionsByTurnLabels, flowAcceptanceFactors);
        }
        Set usedExitLabels = bushS2MergeExitShiftedSendingFlows.keySet();
        double[] exitSegmentTotalShiftedFlows = new double[this.pasMergeVertexNumExitSegments];
        for (BushFlowLabel exitLabel : usedExitLabels) {
            ArrayUtils.addTo((double[])exitSegmentTotalShiftedFlows, (double[])((double[])bushS2MergeExitShiftedSendingFlows.get(exitLabel)));
        }
        for (BushFlowLabel exitLabel : usedExitLabels) {
            ArrayUtils.divideBy((double[])((double[])bushS2MergeExitShiftedSendingFlows.get(exitLabel)), (double[])exitSegmentTotalShiftedFlows, (double)0.0);
        }
        TreeMap<BushFlowLabel, double[]> bushS2MergeExitShiftedSplittingRates = bushS2MergeExitShiftedSendingFlows;
        bushS2MergeExitShiftedSendingFlows = null;
        TreeMap<BushFlowLabel, Double> bushS1UsedEndLabelRates = null;
        if (s1SegmentNotUsedYet) {
            bushS1UsedEndLabelRates = this.initialiseS1Labelling(origin, bushS1ReverseLabelChains);
            this.relabelIfNotTerminating(origin, this.pas.getDivergeVertex(), firstS2Segment, s2DivergeProportionsByTurnLabels);
        } else {
            Set<BushFlowLabel> s1EndLabelPerChain = bushS1ReverseLabelChains.stream().map(chain -> (BushFlowLabel)chain.get(0)).collect(Collectors.toSet());
            bushS1UsedEndLabelRates = origin.determineProportionalFlowCompositionRates(lastS1Segment, s1EndLabelPerChain);
        }
        for (LinkedList<BushFlowLabel> s1UsedLabelChain : bushS1ReverseLabelChains) {
            BushFlowLabel finalSegmentLabel = s1UsedLabelChain.getFirst();
            BushFlowLabel initialSegmentLabel = s1UsedLabelChain.getLast();
            double s1StartLabeledFlowShift = (Double)bushS1UsedEndLabelRates.get(finalSegmentLabel) * bushFlowShift;
            double s1FinalLabeledFlowShift = this.executeBushLabeledAlternativeFlowShift(origin, s1UsedLabelChain, s1StartLabeledFlowShift, s1, flowAcceptanceFactors, s1SegmentNotUsedYet);
            LOGGER.info(String.format("** S1 SHIFT: label start %d, end %d, flow shift start %.10f, end %.10f", initialSegmentLabel.getLabelId(), finalSegmentLabel.getLabelId(), s1StartLabeledFlowShift, s1FinalLabeledFlowShift));
            this.executeBushLabeledS1FlowShiftEndMerge(origin, finalSegmentLabel, s1FinalLabeledFlowShift, bushS2MergeExitShiftedSplittingRates);
            if (s2DivergeProportionsByTurnLabels.isEmpty()) continue;
            this.executeBushLabeledS1FlowShiftStartDiverge(origin, initialSegmentLabel, s1StartLabeledFlowShift, s2DivergeProportionsByTurnLabels, flowAcceptanceFactors);
        }
    }

    protected PasFlowShiftOriginBasedSmartLabelledExecutor(Pas pas, StaticLtmSettings settings) {
        super(pas, settings);
        this.s2ReverseLabelChains = new HashMap<RootedLabelledBush, List<LinkedList<BushFlowLabel>>>();
    }

    @Override
    public void initialise() {
        super.initialise();
        EdgeSegment[] s2 = this.pas.getAlternative(false);
        EdgeSegment[] s1 = this.pas.getAlternative(true);
        for (RootedLabelledBush origin : this.pas.getRegisteredBushes()) {
            List<LinkedList<BushFlowLabel>> s2BushLabelChains = this.determineUsedLabelChains(origin, s2);
            this.s2ReverseLabelChains.put(origin, s2BushLabelChains);
            List<LinkedList<BushFlowLabel>> s1BushLabelChains = this.determineUsedLabelChains(origin, s1);
            this.s1ReverseLabelChains.put(origin, s1BushLabelChains);
        }
    }
}

