/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;

public class PasFlowShiftOriginBasedDestLabelledExecutor
extends PasFlowShiftExecutor {
    private static final Logger LOGGER = Logger.getLogger(PasFlowShiftOriginBasedDestLabelledExecutor.class.getCanonicalName());

    private double executeTurnFlowShift(RootedLabelledBush origin, EdgeSegment turnEntry, EdgeSegment turnExit, BushFlowLabel label, double flowShiftPcuH) {
        double newLabelledTurnFlow = origin.addTurnSendingFlow(turnEntry, label, turnExit, label, flowShiftPcuH, this.isPasS2RemovalAllowed());
        if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12) && !Precision.positive((double)origin.getTurnSendingFlow(turnEntry, turnExit), (double)1.0E-12)) {
            origin.removeTurn(turnEntry, turnExit);
            newLabelledTurnFlow = 0.0;
        }
        return newLabelledTurnFlow;
    }

    private Map<BushFlowLabel, Double> determineUsedLabelAcceptedFlows(RootedLabelledBush origin, EdgeSegment[] subPath, double[] flowAcceptanceFactors) {
        TreeSet<BushFlowLabel> edgeSegmentCompositionLabels = origin.getFlowCompositionLabels(subPath[0]);
        HashMap<BushFlowLabel, Double> pasCompositionLabelledSendingFlows = new HashMap<BushFlowLabel, Double>();
        if (edgeSegmentCompositionLabels == null || edgeSegmentCompositionLabels.isEmpty()) {
            return pasCompositionLabelledSendingFlows;
        }
        block0: for (BushFlowLabel currLabel : edgeSegmentCompositionLabels) {
            EdgeSegment currentSegment = subPath[0];
            double labelledS2AcceptedFlow = origin.getSendingFlowPcuH(currentSegment, currLabel);
            EdgeSegment succeedingSegment = currentSegment;
            for (int index = 1; index < subPath.length; ++index) {
                succeedingSegment = subPath[index];
                double currSplittingRate = origin.getSplittingRate(currentSegment, succeedingSegment, currLabel);
                if (!Precision.positive((double)currSplittingRate)) continue block0;
                currentSegment = succeedingSegment;
                labelledS2AcceptedFlow *= flowAcceptanceFactors[(int)currentSegment.getId()] * currSplittingRate;
            }
            pasCompositionLabelledSendingFlows.put(currLabel, labelledS2AcceptedFlow *= flowAcceptanceFactors[(int)succeedingSegment.getId()]);
        }
        return pasCompositionLabelledSendingFlows;
    }

    private void executeBushDestinationLabeledS2FlowShiftEndMerge(RootedLabelledBush origin, BushFlowLabel destinationLabel, double s2FinalLabeledFlowShift, MultiKeyMap<Object, Double> s2MergeExitSplittingRates, Map<BushFlowLabel, double[]> exitShiftedSendingFlowToPopulate) {
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            EdgeSegment lastS2Segment = this.pas.getLastEdgeSegment(false);
            double[] destinationLabelExitSegmentShiftedSendingFlows = new double[this.pasMergeVertexNumExitSegments];
            exitShiftedSendingFlowToPopulate.put(destinationLabel, destinationLabelExitSegmentShiftedSendingFlows);
            int index = 0;
            for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                if (origin.containsEdgeSegment(exitSegment)) {
                    Double labeledSplittingRate = (Double)s2MergeExitSplittingRates.get((Object)exitSegment, (Object)destinationLabel);
                    if (labeledSplittingRate == null || !Precision.positive((double)labeledSplittingRate, (double)1.0E-12)) {
                        ++index;
                        continue;
                    }
                    double s2FlowShift = s2FinalLabeledFlowShift * labeledSplittingRate;
                    double newLabelledTurnFlow = origin.addTurnSendingFlow(lastS2Segment, destinationLabel, exitSegment, destinationLabel, s2FlowShift, this.isPasS2RemovalAllowed());
                    if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newLabelledTurnFlow, (double)1.0E-12) && !Precision.positive((double)origin.getTurnSendingFlow(lastS2Segment, exitSegment), (double)1.0E-12)) {
                        origin.removeTurn(lastS2Segment, exitSegment);
                    }
                    int n = index;
                    destinationLabelExitSegmentShiftedSendingFlows[n] = destinationLabelExitSegmentShiftedSendingFlows[n] + -s2FlowShift;
                }
                ++index;
            }
        }
    }

    private void executeBushDestinationLabeledS1FlowShiftEndMerge(RootedLabelledBush origin, BushFlowLabel destinationLabel, double s1FinalLabeledFlowShift, double[] destinationLabelExitSegmentSplittingRates) {
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            EdgeSegment lastS1Segment = this.pas.getLastEdgeSegment(true);
            int index = 0;
            for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                double s1FlowShift;
                double newLabelledTurnFlow;
                double splittingRate = destinationLabelExitSegmentSplittingRates[index];
                if (Precision.positive((double)splittingRate) && !Precision.positive((double)(newLabelledTurnFlow = origin.addTurnSendingFlow(lastS1Segment, destinationLabel, exitSegment, destinationLabel, s1FlowShift = s1FinalLabeledFlowShift * splittingRate)), (double)1.0E-12)) {
                    LOGGER.severe("Flow shift towards cheaper S1 alternative should always result in non-negative remaining flow, but this was not found, this shouldn't happen");
                }
                ++index;
            }
        }
    }

    private double executeBushDestinationLabeledFlowShift(RootedLabelledBush origin, EdgeSegment entrySegment, BushFlowLabel label, double flowShiftPcuH, EdgeSegment[] pasSegment, double[] flowAcceptanceFactors) {
        int index = 0;
        EdgeSegment currentSegment = entrySegment;
        EdgeSegment nextSegment = pasSegment[index];
        this.executeTurnFlowShift(origin, entrySegment, nextSegment, label, flowShiftPcuH);
        flowShiftPcuH *= flowAcceptanceFactors[(int)entrySegment.getId()];
        while (++index < pasSegment.length) {
            currentSegment = nextSegment;
            nextSegment = pasSegment[index];
            this.executeTurnFlowShift(origin, currentSegment, nextSegment, label, flowShiftPcuH);
            flowShiftPcuH *= flowAcceptanceFactors[(int)currentSegment.getId()];
        }
        return flowShiftPcuH;
    }

    @Override
    protected void executeBushFlowShift(RootedLabelledBush origin, EdgeSegment entrySegment, double bushFlowShift, double[] flowAcceptanceFactors) {
        EdgeSegment[] s2 = this.pas.getAlternative(false);
        EdgeSegment[] s1 = this.pas.getAlternative(true);
        Map<BushFlowLabel, Double> s2DestinationLabelledAcceptedFlows = this.determineUsedLabelAcceptedFlows(origin, s2, flowAcceptanceFactors);
        TreeMap<BushFlowLabel, Double> bushAlternativeRelativeLabelProportions = new TreeMap<BushFlowLabel, Double>(s2DestinationLabelledAcceptedFlows);
        double sumOfS2LabelledAcceptedFlows = bushAlternativeRelativeLabelProportions.values().stream().collect(Collectors.summingDouble(d -> d));
        bushAlternativeRelativeLabelProportions.entrySet().forEach(e -> e.setValue((Double)e.getValue() / sumOfS2LabelledAcceptedFlows));
        TreeMap<BushFlowLabel, double[]> bushS2MergeExitShiftedSendingFlows = new TreeMap<BushFlowLabel, double[]>();
        for (Map.Entry<BushFlowLabel, Double> labelPortionPair : bushAlternativeRelativeLabelProportions.entrySet()) {
            BushFlowLabel currLabel = labelPortionPair.getKey();
            Double currLabelPortion = labelPortionPair.getValue();
            MultiKeyMap<Object, Double> s2MergeExitSplittingRates = origin.getSplittingRates(this.pas.getLastEdgeSegment(false), currLabel);
            double s2StartLabeledFlowShift = -currLabelPortion.doubleValue() * bushFlowShift;
            double s2FinalLabeledFlowShift = this.executeBushDestinationLabeledFlowShift(origin, entrySegment, currLabel, s2StartLabeledFlowShift, s2, flowAcceptanceFactors);
            LOGGER.info(String.format("** S2 SHIFT: dest-label %d, shift-link [start,end]: [%.10f, %.10f]", currLabel.getLabelId(), s2StartLabeledFlowShift, s2FinalLabeledFlowShift));
            this.executeBushDestinationLabeledS2FlowShiftEndMerge(origin, currLabel, s2FinalLabeledFlowShift, s2MergeExitSplittingRates, bushS2MergeExitShiftedSendingFlows);
        }
        bushS2MergeExitShiftedSendingFlows.forEach((label, flows) -> ArrayUtils.divideBySum((double[])flows, (int)0));
        TreeMap<BushFlowLabel, double[]> bushS2MergeExitShiftedSplittingRates = bushS2MergeExitShiftedSendingFlows;
        bushS2MergeExitShiftedSendingFlows = null;
        for (Map.Entry<BushFlowLabel, Double> labelPortionPair : bushAlternativeRelativeLabelProportions.entrySet()) {
            BushFlowLabel currLabel = labelPortionPair.getKey();
            Double currLabelPortion = labelPortionPair.getValue();
            double s1StartLabeledFlowShift = currLabelPortion * bushFlowShift;
            double s1FinalLabeledFlowShift = this.executeBushDestinationLabeledFlowShift(origin, entrySegment, currLabel, s1StartLabeledFlowShift, s1, flowAcceptanceFactors);
            LOGGER.info(String.format("** S1 SHIFT: dest-label %d, shift-link [start,end]: [%.10f, %.10f]", currLabel.getLabelId(), s1StartLabeledFlowShift, s1FinalLabeledFlowShift));
            this.executeBushDestinationLabeledS1FlowShiftEndMerge(origin, currLabel, s1FinalLabeledFlowShift, bushS2MergeExitShiftedSplittingRates.get(currLabel));
        }
    }

    protected PasFlowShiftOriginBasedDestLabelledExecutor(Pas pas, StaticLtmSettings settings) {
        super(pas, settings);
    }
}

