/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.consumer.NMRCollectMostRestrictingTurnConsumer;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingBushBase;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.pcu.PcuCapacitated;
import org.ojalgo.array.Array1D;

public abstract class PasFlowShiftExecutor {
    private static final Logger LOGGER = Logger.getLogger(PasFlowShiftExecutor.class.getCanonicalName());
    private boolean allowPasRemoval;
    boolean towardsEqualAlternativeFlowDistribution;
    protected static final double EPSILON = 1.0E-12;
    protected static final double PAS_MIN_S2_FLOW_THRESHOLD = 1.0;
    protected final Pas pas;
    protected final StaticLtmSettings settings;
    protected Map<EdgeSegment, Pair<Double, Double>> totalEntrySegmentS1S2Flow;
    protected final Map<RootedLabelledBush, Map<EdgeSegment, Pair<Double, Double>>> bushEntrySegmentS1S2SendingFlows;
    protected final Set<EdgeSegment> usedCongestedEntryEdgeSegments;
    protected final int pasMergeVertexNumExitSegments;

    private static double getDTravelTimeDFlow(Mode theMode, AbstractPhysicalCost physicalCost, AbstractVirtualCost virtualCost, EdgeSegment edgeSegment) {
        if (edgeSegment instanceof MacroscopicLinkSegment) {
            return physicalCost.getDTravelTimeDFlow(false, theMode, (EdgeSegment)((MacroscopicLinkSegment)edgeSegment));
        }
        if (edgeSegment instanceof ConnectoidSegment) {
            return virtualCost.getDTravelTimeDFlow(false, theMode, (EdgeSegment)((ConnectoidSegment)edgeSegment));
        }
        LOGGER.severe(String.format("Unsupported edge segment (%s) to obtain derivative of cost towards flow from", edgeSegment.getXmlId()));
        return 0.0;
    }

    private static EdgeSegment identifyMostRestrictingOutEdgeSegment(EdgeSegment entrySegment, StaticLtmLoadingBushBase<?> networkLoading) {
        NMRCollectMostRestrictingTurnConsumer consumer = new NMRCollectMostRestrictingTurnConsumer(entrySegment);
        StaticLtmNetworkLoading.performNodeModelUpdate(entrySegment.getDownstreamVertex(), consumer, networkLoading);
        EdgeSegment mostRestrictingOutSegment = consumer.getMostRestrictingOutSegment();
        if (mostRestrictingOutSegment == null) {
            LOGGER.severe(String.format("Expected most restricting our segment to be present given that incoming segment (%s) is congested, but not found, this shouldn't happen", entrySegment.getXmlId()));
        }
        return mostRestrictingOutSegment;
    }

    private Pair<EdgeSegment, EdgeSegment> populateFirstCongestedEdgeSegmentOnPasAlternative(EdgeSegment entrySegment, StaticLtmLoadingBushBase<?> networkLoading) {
        Predicate<EdgeSegment> firstCongestedLinkSegment = es -> networkLoading.getCurrentFlowAcceptanceFactors()[(int)es.getId()] < 1.0;
        EdgeSegment firstS1CongestedLinkSegment = this.pas.matchFirst(true, firstCongestedLinkSegment);
        EdgeSegment firstS2CongestedLinkSegment = this.pas.matchFirst(false, firstCongestedLinkSegment);
        double entrySegmentAlpha = networkLoading.getCurrentFlowAcceptanceFactors()[(int)entrySegment.getId()];
        if (Precision.smaller((double)entrySegmentAlpha, (double)1.0, (double)1.0E-12)) {
            EdgeSegment mostRestrictingOutSegment = PasFlowShiftExecutor.identifyMostRestrictingOutEdgeSegment(entrySegment, networkLoading);
            if (mostRestrictingOutSegment.idEquals((Object)this.pas.getFirstEdgeSegment(true))) {
                firstS1CongestedLinkSegment = entrySegment;
            } else if (mostRestrictingOutSegment.idEquals((Object)this.pas.getFirstEdgeSegment(false))) {
                firstS2CongestedLinkSegment = entrySegment;
            }
        }
        return Pair.of((Object)firstS1CongestedLinkSegment, (Object)firstS2CongestedLinkSegment);
    }

    private double adjustFlowShiftBasedOnS1SlackFlow(double proposedFlowShift, double s1SlackFlow) {
        if (proposedFlowShift <= s1SlackFlow) {
            return proposedFlowShift;
        }
        if (Precision.smaller((double)proposedFlowShift, (double)10.0)) {
            return proposedFlowShift;
        }
        double assumedCongestedShift = proposedFlowShift - s1SlackFlow;
        double portion = 1.0 - this.pas.getAlternativeLowCost() / this.pas.getAlternativeHighCost();
        return s1SlackFlow + assumedCongestedShift * portion;
    }

    private double adjustFlowShiftBasedOnS2SlackFlow(double proposedFlowShift, double s2SlackFlow) {
        if (proposedFlowShift <= s2SlackFlow) {
            return proposedFlowShift;
        }
        double assumedUncongestedShift = proposedFlowShift - s2SlackFlow;
        double portion = 1.0 - this.pas.getAlternativeLowCost() / this.pas.getAlternativeHighCost();
        return s2SlackFlow + assumedUncongestedShift * portion;
    }

    private double determinePasAlternativeSlackFlow(StaticLtmLoadingBushBase<?> networkLoading, boolean lowCost) {
        EdgeSegment lastAlternativeSegment = this.pas.getLastEdgeSegment(lowCost);
        double slackFlow = Double.POSITIVE_INFINITY;
        Array1D<Double> splittingRates = networkLoading.getSplittingRateData().getSplittingRates(lastAlternativeSegment);
        int index = 0;
        int linkSegmentId = -1;
        for (EdgeSegment exitSegment : lastAlternativeSegment.getDownstreamVertex().getExitEdgeSegments()) {
            double splittingRate = (Double)splittingRates.get(index);
            if (splittingRate > 0.0) {
                linkSegmentId = (int)exitSegment.getId();
                double nextInflow = networkLoading.getCurrentInflowsPcuH()[(int)exitSegment.getId()];
                double currSlackFlow = ((PcuCapacitated)exitSegment).getCapacityOrDefaultPcuH() - nextInflow;
                slackFlow = Math.min(slackFlow, currSlackFlow);
            }
            ++index;
        }
        if (!Precision.positive((double)slackFlow, (double)1.0E-12)) {
            return slackFlow;
        }
        EdgeSegment alternativeEdgeSegment = null;
        EdgeSegment[] alternativeEdgeSegments = this.pas.getAlternative(lowCost);
        for (index = 0; index < alternativeEdgeSegments.length; ++index) {
            alternativeEdgeSegment = alternativeEdgeSegments[index];
            linkSegmentId = (int)alternativeEdgeSegment.getId();
            double inflow = networkLoading.getCurrentInflowsPcuH()[linkSegmentId];
            double currSlackFlow = ((PcuCapacitated)alternativeEdgeSegment).getCapacityOrDefaultPcuH() - inflow;
            slackFlow = Math.min(slackFlow, currSlackFlow);
        }
        return slackFlow;
    }

    protected void activatePasS2RemovalIf(boolean flag) {
        this.allowPasRemoval = flag;
    }

    protected boolean isPasS2RemovalAllowed() {
        return this.allowPasRemoval;
    }

    protected PasFlowShiftExecutor(Pas pas, StaticLtmSettings settings) {
        this.pas = pas;
        this.settings = settings;
        this.bushEntrySegmentS1S2SendingFlows = new HashMap<RootedLabelledBush, Map<EdgeSegment, Pair<Double, Double>>>();
        this.usedCongestedEntryEdgeSegments = new HashSet<EdgeSegment>();
        this.pasMergeVertexNumExitSegments = pas.getMergeVertex().getNumberOfExitEdgeSegments();
    }

    protected abstract void executeBushFlowShift(RootedLabelledBush var1, EdgeSegment var2, double var3, double[] var5);

    protected double determineEntrySegmentFlowShift(EdgeSegment entrySegment, Mode theMode, AbstractPhysicalCost physicalCost, AbstractVirtualCost virtualCost, StaticLtmLoadingBushBase<?> networkLoading) {
        Pair<EdgeSegment, EdgeSegment> firstCongestedSegmentPair = this.populateFirstCongestedEdgeSegmentOnPasAlternative(entrySegment, networkLoading);
        EdgeSegment firstS1CongestedLinkSegment = (EdgeSegment)firstCongestedSegmentPair.first();
        EdgeSegment firstS2CongestedLinkSegment = (EdgeSegment)firstCongestedSegmentPair.second();
        boolean sharedCongestedEntry = entrySegment == firstS1CongestedLinkSegment || entrySegment == firstS2CongestedLinkSegment;
        double denominatorS2 = 0.0;
        double denominatorS1 = 0.0;
        if (firstS1CongestedLinkSegment != null) {
            denominatorS1 = PasFlowShiftExecutor.getDTravelTimeDFlow(theMode, physicalCost, virtualCost, firstS1CongestedLinkSegment);
        }
        if (firstS2CongestedLinkSegment != null) {
            denominatorS2 = PasFlowShiftExecutor.getDTravelTimeDFlow(theMode, physicalCost, virtualCost, firstS2CongestedLinkSegment);
        }
        Pair<Double, Double> s1S2SubPathSendingFlowPair = this.totalEntrySegmentS1S2Flow.get(entrySegment);
        double s1WithEntrySendingFlow = (Double)s1S2SubPathSendingFlowPair.first();
        double s2WithEntrySendingFlow = (Double)s1S2SubPathSendingFlowPair.second();
        double flowShift = 0.0;
        boolean pasCostEqual = this.pas.isCostEqual(1.0E-12);
        boolean pasUncongested = firstS1CongestedLinkSegment == null && firstS2CongestedLinkSegment == null;
        double slackFlowEstimate = this.determinePasAlternativeSlackFlow(networkLoading, true);
        if (pasUncongested && !pasCostEqual) {
            LOGGER.info("** uncongested - towards S1 - unequal cost");
            double proposedFlowShift = Math.min(s2WithEntrySendingFlow - 10.0, slackFlowEstimate) + 10.0;
            return this.adjustFlowShiftBasedOnS1SlackFlow(proposedFlowShift, slackFlowEstimate);
        }
        if (pasCostEqual) {
            LOGGER.info("** one or both alternatives congested - towards S1 - near equal cost (<10^-12)");
        } else {
            LOGGER.info("** one or both alternatives congested - towards S1 - unequal cost");
        }
        double denominator = denominatorS2 + denominatorS1;
        double numerator = this.pas.getAlternativeHighCost() - this.pas.getAlternativeLowCost();
        if (numerator != 0.0) {
            flowShift = numerator / denominator;
            double diff = this.pas.getAlternativeLowCost() + denominatorS1 * flowShift - (this.pas.getAlternativeHighCost() + denominatorS2 * -flowShift);
            if (Precision.notEqual((double)diff, (double)0.0)) {
                LOGGER.severe("Computation of using derivatives to shift flows between PAS segments does not result in equal travel time after shift, this should not happen");
            }
            if (firstS1CongestedLinkSegment == null) {
                flowShift = this.adjustFlowShiftBasedOnS1SlackFlow(flowShift, slackFlowEstimate);
            }
            if (firstS2CongestedLinkSegment != null) {
                double s2SlackFlowEstimate = this.getS2SendingFlow() * (1.0 - networkLoading.getCurrentFlowAcceptanceFactors()[(int)firstS2CongestedLinkSegment.getId()]);
                flowShift = this.adjustFlowShiftBasedOnS2SlackFlow(flowShift, s2SlackFlowEstimate);
            }
        }
        if (flowShift == 0.0) {
            if (!this.settings.isEnforceMaxEntropyFlowSolution().booleanValue()) {
                LOGGER.info("** equal cost/ equal (link) derivative/non-equal flow - no max entropy required - skip flow shift");
                return flowShift;
            }
            boolean allowCongestedEqualFlowDistribution = sharedCongestedEntry && (firstS1CongestedLinkSegment == null || firstS2CongestedLinkSegment == null);
            boolean bl = this.towardsEqualAlternativeFlowDistribution = pasCostEqual && (pasUncongested || allowCongestedEqualFlowDistribution);
            if (this.towardsEqualAlternativeFlowDistribution) {
                boolean pasAlternativeFlowsEqual = Precision.equal((double)s1WithEntrySendingFlow, (double)s2WithEntrySendingFlow, (double)1.0E-12);
                if (pasAlternativeFlowsEqual) {
                    LOGGER.info("** proportional distribution exists under equal cost - skip flow shift");
                    return flowShift;
                }
                LOGGER.info("** towards proportional distribution - equal cost/ equal (link) derivative/non-equal flow");
                double proportionalFlow = (s2WithEntrySendingFlow + s1WithEntrySendingFlow) / 2.0;
                flowShift = s2WithEntrySendingFlow - proportionalFlow;
            }
        }
        return flowShift;
    }

    public void initialise() {
        EdgeSegment[] s2 = this.pas.getAlternative(false);
        EdgeSegment[] s1 = this.pas.getAlternative(true);
        this.totalEntrySegmentS1S2Flow = new HashMap<EdgeSegment, Pair<Double, Double>>();
        for (EdgeSegment entrySegment : this.pas.getDivergeVertex().getEntryEdgeSegments()) {
            this.totalEntrySegmentS1S2Flow.put(entrySegment, (Pair<Double, Double>)Pair.of((Object)0.0, (Object)0.0));
            for (RootedLabelledBush bush : this.pas.getRegisteredBushes()) {
                Pair<Double, Double> currTotalS1S2Flow = this.totalEntrySegmentS1S2Flow.get(entrySegment);
                if (!bush.containsEdgeSegment(entrySegment)) continue;
                this.bushEntrySegmentS1S2SendingFlows.putIfAbsent(bush, new HashMap());
                Map<EdgeSegment, Pair<Double, Double>> entrySegmentS1S2SendingFlows = this.bushEntrySegmentS1S2SendingFlows.get(bush);
                double s2BushSendingFlow = bush.determineSubPathSendingFlow(entrySegment, s2);
                double newS2Total = (Double)currTotalS1S2Flow.second() + s2BushSendingFlow;
                double s1BushSendingFlow = bush.determineSubPathSendingFlow(entrySegment, s1);
                double newS1Total = (Double)currTotalS1S2Flow.first() + s1BushSendingFlow;
                this.totalEntrySegmentS1S2Flow.put(entrySegment, (Pair<Double, Double>)Pair.of((Object)newS1Total, (Object)newS2Total));
                entrySegmentS1S2SendingFlows.put(entrySegment, (Pair<Double, Double>)Pair.of((Object)s1BushSendingFlow, (Object)s2BushSendingFlow));
            }
        }
    }

    public boolean run(Mode theMode, AbstractPhysicalCost physicalCost, AbstractVirtualCost virtualCost, StaticLtmLoadingBushBase<?> networkLoading, double factor) {
        double totalS2SendingFlow = this.getS2SendingFlow();
        LOGGER.info("******************* PAS FLOW shift " + this.pas.toString() + "S2 Sending flow: " + totalS2SendingFlow + " cost-diff: " + this.pas.getReducedCost() + " *****************************");
        if (!Precision.positive((double)totalS2SendingFlow)) {
            LOGGER.warning("no flow on S2 segment of selected PAS, PAS should not exist anymore, this shouldn't happen");
        }
        boolean flowShifted = false;
        for (EdgeSegment entrySegment : this.pas.getDivergeVertex().getEntryEdgeSegments()) {
            Pair<Double, Double> totalEntrySegmentS1S1SendingFlow = this.totalEntrySegmentS1S2Flow.get(entrySegment);
            double totalEntrySegmentS2Flow = (Double)totalEntrySegmentS1S1SendingFlow.second();
            if (totalEntrySegmentS2Flow <= 0.0) {
                this.totalEntrySegmentS1S2Flow.remove(entrySegment);
                continue;
            }
            double proposedPasflowShift = this.determineEntrySegmentFlowShift(entrySegment, theMode, physicalCost, virtualCost, networkLoading);
            if (Math.abs(proposedPasflowShift) == 0.0) continue;
            double entrySegmentPortion = totalEntrySegmentS2Flow / totalS2SendingFlow;
            double proposedProportionalPasflowShift = proposedPasflowShift * entrySegmentPortion * factor;
            this.activatePasS2RemovalIf(Precision.greaterEqual((double)proposedProportionalPasflowShift, (double)totalEntrySegmentS2Flow, (double)1.0E-12) || Precision.greaterEqual((double)1.0, (double)totalEntrySegmentS2Flow, (double)1.0E-12));
            if (this.isPasS2RemovalAllowed()) {
                LOGGER.info(String.format("** Allow removal, proposed shift %.10f exceeds available s2 sending flow %.10f", proposedProportionalPasflowShift, totalEntrySegmentS2Flow));
                this.totalEntrySegmentS1S2Flow.remove(entrySegment);
                proposedProportionalPasflowShift = totalEntrySegmentS2Flow;
            }
            for (RootedLabelledBush bush : this.pas.getRegisteredBushes()) {
                if (!bush.containsTurnSendingFlow(entrySegment, this.pas.getFirstEdgeSegment(false))) continue;
                Map<EdgeSegment, Pair<Double, Double>> bushEntrySegmentS1S2Flows = this.bushEntrySegmentS1S2SendingFlows.get(bush);
                Double bushEntrySegmentS2Flow = (Double)bushEntrySegmentS1S2Flows.get(entrySegment).second();
                double bushS2Portion = bushEntrySegmentS2Flow / totalEntrySegmentS2Flow;
                double entrySegmentPasflowShift = proposedProportionalPasflowShift * bushS2Portion;
                LOGGER.info(String.format("** Entry segment (" + entrySegment.toString() + ") - Zone (" + bush.getRootZoneVertex().getXmlId() + ") - start flow shift: %.10f", entrySegmentPasflowShift));
                this.executeBushFlowShift(bush, entrySegment, entrySegmentPasflowShift, networkLoading.getCurrentFlowAcceptanceFactors());
                flowShifted = true;
                if (Precision.smaller((double)networkLoading.getCurrentFlowAcceptanceFactors()[(int)entrySegment.getId()], (double)1.0, (double)1.0E-12)) {
                    this.usedCongestedEntryEdgeSegments.add(entrySegment);
                }
                if (!this.isPasS2RemovalAllowed()) continue;
                bushEntrySegmentS1S2Flows.remove(entrySegment);
            }
        }
        Iterator<RootedLabelledBush> iter = this.pas.getRegisteredBushes().iterator();
        while (iter.hasNext()) {
            RootedLabelledBush bush = iter.next();
            Map<EdgeSegment, Pair<Double, Double>> entrySegmentS1S2Flows = this.bushEntrySegmentS1S2SendingFlows.get(bush);
            if (entrySegmentS1S2Flows == null || !entrySegmentS1S2Flows.isEmpty()) continue;
            iter.remove();
        }
        return flowShifted;
    }

    public double getS2SendingFlow() {
        double totalS2 = 0.0;
        for (Map.Entry<EdgeSegment, Pair<Double, Double>> entry : this.totalEntrySegmentS1S2Flow.entrySet()) {
            totalS2 += ((Double)entry.getValue().second()).doubleValue();
        }
        return totalS2;
    }

    public double getS1SendingFlow() {
        double totalS1 = 0.0;
        for (Map.Entry<EdgeSegment, Pair<Double, Double>> entry : this.totalEntrySegmentS1S2Flow.entrySet()) {
            totalS1 += ((Double)entry.getValue().first()).doubleValue();
        }
        return totalS1;
    }

    public boolean isTowardsEqualAlternativeFlowDistribution() {
        return this.towardsEqualAlternativeFlowDistribution;
    }

    public Set<EdgeSegment> getUsedCongestedEntrySegments() {
        return this.usedCongestedEntryEdgeSegments;
    }
}

