/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasFlowShiftExecutor;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;

public class PasFlowShiftDestinationBasedExecutor
extends PasFlowShiftExecutor {
    private static final Logger LOGGER = Logger.getLogger(PasFlowShiftDestinationBasedExecutor.class.getCanonicalName());
    private final BushFlowLabel dummyLabel;

    private double executeTurnFlowShift(RootedLabelledBush bush, EdgeSegment turnEntry, EdgeSegment turnExit, double flowShiftPcuH) {
        double newTurnFlow = bush.addTurnSendingFlow(turnEntry, this.dummyLabel, turnExit, this.dummyLabel, flowShiftPcuH, this.isPasS2RemovalAllowed());
        if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newTurnFlow, (double)1.0E-12) && !Precision.positive((double)bush.getTurnSendingFlow(turnEntry, turnExit), (double)1.0E-12)) {
            bush.removeTurn(turnEntry, turnExit);
            newTurnFlow = 0.0;
        }
        return newTurnFlow;
    }

    private double[] executeBushS2FlowShiftEndMerge(RootedLabelledBush bush, double s2FinalFlowShift, MultiKeyMap<Object, Double> s2MergeExitSplittingRates) {
        double[] exitShiftedSendingFlows = new double[this.pasMergeVertexNumExitSegments];
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            EdgeSegment lastS2Segment = this.pas.getLastEdgeSegment(false);
            int index = 0;
            for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                if (bush.containsEdgeSegment(exitSegment)) {
                    Double splittingRate = (Double)s2MergeExitSplittingRates.get((Object)exitSegment, (Object)this.dummyLabel);
                    if (splittingRate == null || !Precision.positive((double)splittingRate, (double)1.0E-12)) {
                        ++index;
                        continue;
                    }
                    double s2FlowShift = s2FinalFlowShift * splittingRate;
                    double newturnFlow = bush.addTurnSendingFlow(lastS2Segment, this.dummyLabel, exitSegment, this.dummyLabel, s2FlowShift, this.isPasS2RemovalAllowed());
                    if (this.isPasS2RemovalAllowed() && !Precision.positive((double)newturnFlow, (double)1.0E-12) && !Precision.positive((double)bush.getTurnSendingFlow(lastS2Segment, exitSegment), (double)1.0E-12)) {
                        bush.removeTurn(lastS2Segment, exitSegment);
                    }
                    int n = index;
                    exitShiftedSendingFlows[n] = exitShiftedSendingFlows[n] + -s2FlowShift;
                }
                ++index;
            }
        }
        return exitShiftedSendingFlows;
    }

    private void executeBushS1FlowShiftEndMerge(RootedLabelledBush bush, double s1FinalFlowShift, double[] exitSegmentSplittingRates) {
        if (this.pas.getMergeVertex().hasExitEdgeSegments()) {
            EdgeSegment lastS1Segment = this.pas.getLastEdgeSegment(true);
            int index = 0;
            for (EdgeSegment exitSegment : this.pas.getMergeVertex().getExitEdgeSegments()) {
                double s1FlowShift;
                double newLabelledTurnFlow;
                double splittingRate = exitSegmentSplittingRates[index];
                if (Precision.positive((double)splittingRate, (double)1.0E-12) && !Precision.positive((double)(newLabelledTurnFlow = bush.addTurnSendingFlow(lastS1Segment, this.dummyLabel, exitSegment, this.dummyLabel, s1FlowShift = s1FinalFlowShift * splittingRate)), (double)1.0E-12)) {
                    LOGGER.severe("Flow shift towards cheaper S1 alternative should always result in non-negative remaining flow, but this was not found, this shouldn't happen");
                }
                ++index;
            }
        }
    }

    private double executeBushPasFlowShift(RootedLabelledBush origin, EdgeSegment entrySegment, double flowShiftPcuH, EdgeSegment[] pasSegment, double[] flowAcceptanceFactors) {
        int index = 0;
        EdgeSegment currentSegment = entrySegment;
        EdgeSegment nextSegment = pasSegment[index];
        this.executeTurnFlowShift(origin, entrySegment, nextSegment, flowShiftPcuH);
        flowShiftPcuH *= flowAcceptanceFactors[(int)entrySegment.getId()];
        while (++index < pasSegment.length) {
            currentSegment = nextSegment;
            nextSegment = pasSegment[index];
            this.executeTurnFlowShift(origin, currentSegment, nextSegment, flowShiftPcuH);
            flowShiftPcuH *= flowAcceptanceFactors[(int)currentSegment.getId()];
        }
        return flowShiftPcuH;
    }

    @Override
    protected void executeBushFlowShift(RootedLabelledBush bush, EdgeSegment entrySegment, double bushFlowShift, double[] flowAcceptanceFactors) {
        EdgeSegment[] s2 = this.pas.getAlternative(false);
        EdgeSegment[] s1 = this.pas.getAlternative(true);
        MultiKeyMap<Object, Double> s2MergeExitSplittingRates = bush.getSplittingRates(this.pas.getLastEdgeSegment(false), this.dummyLabel);
        double s2StartLabeledFlowShift = -bushFlowShift;
        double s2FinalLabeledFlowShift = this.executeBushPasFlowShift(bush, entrySegment, s2StartLabeledFlowShift, s2, flowAcceptanceFactors);
        double[] bushS2MergeExitShiftedSendingFlows = this.executeBushS2FlowShiftEndMerge(bush, s2FinalLabeledFlowShift, s2MergeExitSplittingRates);
        ArrayUtils.divideBySum((double[])bushS2MergeExitShiftedSendingFlows, (int)0);
        double[] bushS2MergeExitShiftedSplittingRates = bushS2MergeExitShiftedSendingFlows;
        bushS2MergeExitShiftedSendingFlows = null;
        double s1StartLabeledFlowShift = bushFlowShift;
        double s1FinalLabeledFlowShift = this.executeBushPasFlowShift(bush, entrySegment, s1StartLabeledFlowShift, s1, flowAcceptanceFactors);
        this.executeBushS1FlowShiftEndMerge(bush, s1FinalLabeledFlowShift, bushS2MergeExitShiftedSplittingRates);
    }

    protected PasFlowShiftDestinationBasedExecutor(Pas pas, StaticLtmSettings settings, BushFlowLabel dummyLabel) {
        super(pas, settings);
        this.dummyLabel = dummyLabel;
    }
}

