/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.CollectionUtils;

public class Pas {
    private static final Logger LOGGER = Logger.getLogger(Pas.class.getCanonicalName());
    private EdgeSegment[] s1;
    private EdgeSegment[] s2;
    private double s1Cost;
    private double s2Cost;
    private final Set<RootedLabelledBush> registeredBushes;

    private Pas(EdgeSegment[] s1, EdgeSegment[] s2) {
        this.s1 = s1;
        this.s2 = s2;
        this.registeredBushes = new HashSet<RootedLabelledBush>();
    }

    protected void updateCost(double[] edgeSegmentCosts, boolean updateS1) {
        EdgeSegment[] alternative = updateS1 ? this.s1 : this.s2;
        double cost = 0.0;
        for (int index = 0; index < alternative.length; ++index) {
            cost += edgeSegmentCosts[(int)alternative[index].getId()];
        }
        if (updateS1) {
            this.s1Cost = cost;
        } else {
            this.s2Cost = cost;
        }
    }

    protected static Pas create(EdgeSegment[] s1, EdgeSegment[] s2) {
        if (s1 == null || s2 == null) {
            LOGGER.warning("Unable to create new PAS, one or both alternative segments are null");
            return null;
        }
        return new Pas(s1, s2);
    }

    public DirectedVertex getMergeVertex() {
        return this.s2[this.s2.length - 1].getDownstreamVertex();
    }

    public DirectedVertex getDivergeVertex() {
        return this.s2[0].getUpstreamVertex();
    }

    public boolean registerBush(RootedLabelledBush bush) {
        return this.registeredBushes.add(bush);
    }

    public boolean hasRegisteredBush(RootedLabelledBush bush) {
        return this.registeredBushes.contains(bush);
    }

    public Set<RootedLabelledBush> getRegisteredBushes() {
        return this.registeredBushes;
    }

    public boolean hasRegisteredBushes() {
        return !this.registeredBushes.isEmpty();
    }

    public void removeAllRegisteredBushes() {
        this.registeredBushes.clear();
    }

    public void removeBushes(List<RootedLabelledBush> bushes) {
        bushes.forEach(bush -> this.removeBush((RootedLabelledBush)bush));
    }

    public void removeBush(RootedLabelledBush bush) {
        this.registeredBushes.remove(bush);
    }

    public double computeOverlappingAcceptedFlow(RootedLabelledBush bush, boolean lowCost, double[] linkSegmentFlowAcceptanceFactors) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        return bush.computeSubPathAcceptedFlow(this.getDivergeVertex(), this.getMergeVertex(), alternative, linkSegmentFlowAcceptanceFactors);
    }

    public boolean isOverlappingWith(ShortestPathResult pathSearchResult, boolean lowCost) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        EdgeSegment currEdgeSegment = null;
        EdgeSegment matchingEdgeSegment = null;
        if (pathSearchResult.isInverted()) {
            for (int index = 0; index < alternative.length; ++index) {
                currEdgeSegment = alternative[index];
                matchingEdgeSegment = pathSearchResult.getNextEdgeSegmentForVertex((Vertex)currEdgeSegment.getUpstreamVertex());
                if (currEdgeSegment.idEquals((Object)matchingEdgeSegment)) continue;
                return false;
            }
        } else {
            for (int index = alternative.length - 1; index >= 0; --index) {
                currEdgeSegment = alternative[index];
                matchingEdgeSegment = pathSearchResult.getNextEdgeSegmentForVertex((Vertex)currEdgeSegment.getDownstreamVertex());
                if (currEdgeSegment.idEquals((Object)matchingEdgeSegment)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAlternativeEqual(EdgeSegment[] pathToVerify, boolean lowCost) {
        Object[] alternative = lowCost ? this.s1 : this.s2;
        return Arrays.equals(alternative, pathToVerify);
    }

    public boolean isAlternativeEqual(Collection<EdgeSegment> pathToVerify, boolean lowCost) {
        Object[] alternative = lowCost ? this.s1 : this.s2;
        return CollectionUtils.equals(pathToVerify, (Object[])alternative);
    }

    public boolean containsAny(BitSet linkSegments, boolean lowCost) {
        EdgeSegment[] alternative = lowCost ? this.s1 : this.s2;
        EdgeSegment currEdgeSegment = null;
        for (int index = alternative.length - 1; index >= 0; --index) {
            currEdgeSegment = alternative[index];
            if (!linkSegments.get((int)currEdgeSegment.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(BitSet linkSegments) {
        return this.containsAny(linkSegments, true) || this.containsAny(linkSegments, false);
    }

    public boolean updateCost(double[] edgeSegmentCosts) {
        this.updateCost(edgeSegmentCosts, true);
        this.updateCost(edgeSegmentCosts, false);
        if (this.s1Cost > this.s2Cost) {
            double tempCost = this.s1Cost;
            this.s1Cost = this.s2Cost;
            this.s2Cost = tempCost;
            EdgeSegment[] tempSegment = this.s1;
            this.s1 = this.s2;
            this.s2 = tempSegment;
            return true;
        }
        return false;
    }

    public void forEachVertex(boolean lowCostSegment, Consumer<DirectedVertex> vertexConsumer) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            vertexConsumer.accept(alternative[index].getUpstreamVertex());
        }
        vertexConsumer.accept(alternative[alternative.length - 1].getDownstreamVertex());
    }

    public void forEachEdgeSegment(boolean lowCostSegment, Consumer<EdgeSegment> edgeSegmentConsumer) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            edgeSegmentConsumer.accept(alternative[index]);
        }
    }

    public double getAlternativeHighCost() {
        return this.s2Cost;
    }

    public double getAlternativeLowCost() {
        return this.s1Cost;
    }

    public EdgeSegment getLastEdgeSegment(boolean lowCostSegment) {
        return lowCostSegment ? this.s1[this.s1.length - 1] : this.s2[this.s2.length - 1];
    }

    public EdgeSegment getFirstEdgeSegment(boolean lowCostSegment) {
        return lowCostSegment ? this.s1[0] : this.s2[0];
    }

    public EdgeSegment[] getAlternative(boolean lowCostSegment) {
        return lowCostSegment ? this.s1 : this.s2;
    }

    public double getReducedCost() {
        return this.s2Cost - this.s1Cost;
    }

    public double getNormalisedReducedCost() {
        return (this.s2Cost - this.s1Cost) / (double)(this.s1.length + this.s2.length);
    }

    public EdgeSegment matchFirst(boolean lowCostSegment, Predicate<EdgeSegment> predicate) {
        EdgeSegment[] alternative = this.getAlternative(lowCostSegment);
        for (int index = 0; index < alternative.length; ++index) {
            if (!predicate.test(alternative[index])) continue;
            return alternative[index];
        }
        return null;
    }

    public boolean isCostEqual(double epsilon) {
        return Precision.equal((double)this.s2Cost, (double)this.s1Cost, (double)epsilon);
    }

    public int hashCode() {
        return Objects.hash(this.s1, this.s2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pas)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Pas objPas = (Pas)obj;
        return Arrays.equals(objPas.s1, this.s1) && Arrays.equals(objPas.s2, this.s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Consumer<EdgeSegment> consumer = ls -> {
            if (ls == null) {
                LOGGER.warning("edgeSegment null on PAS alternative, shouldn't happen");
                sb.append("null,");
                return;
            }
            sb.append((String)(ls.getXmlId() != null ? ls.getXmlId() : String.valueOf(ls.getId()) + "*")).append(",");
        };
        sb.append("s1: [");
        if (this.s1 != null && this.s1.length > 0) {
            Arrays.stream(this.s1).forEach(consumer);
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        sb.append("] s2: [");
        if (this.s2 != null && this.s2.length > 0) {
            Arrays.stream(this.s2).forEach(consumer);
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        sb.append("]");
        return sb.toString();
    }
}

