/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestPathAcyclicMinMaxGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;

public class OriginBush
extends RootedLabelledBush {
    private static final Logger LOGGER = Logger.getLogger(OriginBush.class.getCanonicalName());

    public OriginBush(IdGroupingToken idToken, CentroidVertex origin, long maxSubGraphEdgeSegments) {
        this(idToken, origin, 0.0, maxSubGraphEdgeSegments);
    }

    public OriginBush(IdGroupingToken idToken, CentroidVertex origin, double originDemandPcuH, long maxSubGraphEdgeSegments) {
        super(idToken, (DirectedVertex)origin, false, maxSubGraphEdgeSegments);
        this.addOriginDemandPcuH(origin, originDemandPcuH);
    }

    public OriginBush(OriginBush other, boolean deepCopy) {
        super(other, deepCopy);
    }

    @Override
    public MinMaxPathResult computeMinMaxShortestPaths(double[] linkSegmentCosts, int totalTransportNetworkVertices) {
        ShortestPathAcyclicMinMaxGeneralised minMaxBushPaths = new ShortestPathAcyclicMinMaxGeneralised(this.getDag(), this.requireTopologicalSortUpdate, linkSegmentCosts, totalTransportNetworkVertices);
        try {
            return minMaxBushPaths.executeOneToAll((DirectedVertex)this.getRootVertex());
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to complete minmax path three for origin-bush rooted at origin %s", this.getOrigin().getXmlId()));
            return null;
        }
    }

    @Override
    public ShortestSearchType getShortestSearchType() {
        return ShortestSearchType.ONE_TO_ALL;
    }

    public Iterator<DirectedVertex> getTopologicalIterator(boolean originDestinationDirection) {
        return this.getDag().getTopologicalIterator(this.requireTopologicalSortUpdate, !originDestinationDirection);
    }

    @Override
    public CentroidVertex getRootZoneVertex() {
        return this.getOrigin();
    }

    @Override
    public OriginBush shallowClone() {
        return new OriginBush(this, false);
    }

    @Override
    public OriginBush deepClone() {
        return new OriginBush(this, true);
    }

    @Override
    public String toString() {
        String result = super.toString();
        return "Bush: origin zone: " + this.getOrigin().getXmlId() + "\n" + result;
    }

    public CentroidVertex getOrigin() {
        return (CentroidVertex)this.originDemandsPcuH.keySet().iterator().next();
    }

    public void addOriginDemandPcuH(double demandPcuH) {
        this.addOriginDemandPcuH(this.getOrigin(), demandPcuH);
    }

    public Double getOriginDemandPcuH() {
        return this.getOriginDemandPcuH(this.getOrigin());
    }
}

