/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.network.virtual.CentroidVertex;

public class LabelledBushTurnData {
    private static final Logger LOGGER = Logger.getLogger(LabelledBushTurnData.class.getCanonicalName());
    private final HashMap<EdgeSegment, TreeSet<BushFlowLabel>> linkSegmentCompositionLabels;
    private final MultiKeyMap<Object, Double> compositionTurnSendingFlows;

    private void pruneCompositionLabels(DirectedVertex node) {
        HashMap<EdgeSegment, TreeSet> identifiedExitCompositionLabelMap = new HashMap<EdgeSegment, TreeSet>();
        for (EdgeSegment entrySegment : node.getEntryEdgeSegments()) {
            TreeSet<BushFlowLabel> existingEntryLabels = this.linkSegmentCompositionLabels.get(entrySegment);
            if (existingEntryLabels == null) continue;
            TreeSet<BushFlowLabel> remainingEntryLabels = new TreeSet<BushFlowLabel>();
            for (BushFlowLabel entryComposition : existingEntryLabels) {
                for (EdgeSegment exitSegment2 : node.getExitEdgeSegments()) {
                    TreeSet<BushFlowLabel> exitLabels = this.linkSegmentCompositionLabels.get(exitSegment2);
                    if (exitLabels == null) continue;
                    TreeSet<BushFlowLabel> identifiedExitCompositionLabels = (TreeSet<BushFlowLabel>)identifiedExitCompositionLabelMap.get(exitSegment2);
                    if (identifiedExitCompositionLabels == null) {
                        identifiedExitCompositionLabels = new TreeSet<BushFlowLabel>();
                        identifiedExitCompositionLabelMap.put(exitSegment2, identifiedExitCompositionLabels);
                    }
                    for (BushFlowLabel exitComposition : exitLabels) {
                        Double labelledTurnFlow = (Double)this.compositionTurnSendingFlows.get((Object)entrySegment, (Object)entryComposition, (Object)exitSegment2, (Object)exitComposition);
                        if (labelledTurnFlow == null) continue;
                        if (Precision.positive((double)labelledTurnFlow)) {
                            remainingEntryLabels.add(entryComposition);
                            identifiedExitCompositionLabels.add(exitComposition);
                            continue;
                        }
                        this.compositionTurnSendingFlows.removeMultiKey((Object)entrySegment, (Object)entryComposition, (Object)exitSegment2, (Object)exitComposition);
                    }
                }
            }
            if (remainingEntryLabels.isEmpty()) {
                this.linkSegmentCompositionLabels.remove(entrySegment);
                continue;
            }
            this.linkSegmentCompositionLabels.put(entrySegment, remainingEntryLabels);
        }
        identifiedExitCompositionLabelMap.forEach((exitSegment, remainingExitLabels) -> {
            if (remainingExitLabels.isEmpty()) {
                this.linkSegmentCompositionLabels.remove(exitSegment);
            } else {
                this.linkSegmentCompositionLabels.put((EdgeSegment)exitSegment, (TreeSet<BushFlowLabel>)remainingExitLabels);
            }
        });
    }

    private void registerEdgeSegmentCompositionLabel(EdgeSegment edgeSegment, BushFlowLabel compositionLabel) {
        TreeSet<BushFlowLabel> existingLabels = this.linkSegmentCompositionLabels.get(edgeSegment);
        if (existingLabels == null) {
            existingLabels = new TreeSet();
            this.linkSegmentCompositionLabels.put(edgeSegment, existingLabels);
        }
        if (!existingLabels.contains(compositionLabel)) {
            existingLabels.add(compositionLabel);
        }
    }

    private void registerLabelledTurnSendingFlow(EdgeSegment fromSegment, BushFlowLabel fromComposition, EdgeSegment toSegment, BushFlowLabel toComposition, double turnSendingFlow) {
        this.compositionTurnSendingFlows.put((Object)fromSegment, (Object)fromComposition, (Object)toSegment, (Object)toComposition, (Object)turnSendingFlow);
        this.registerEdgeSegmentCompositionLabel(fromSegment, fromComposition);
        this.registerEdgeSegmentCompositionLabel(toSegment, toComposition);
    }

    private double relabel(EdgeSegment fromSegment, BushFlowLabel oldFromLabel, EdgeSegment toSegment, BushFlowLabel oldToLabel, BushFlowLabel newFromLabel, BushFlowLabel newToLabel) {
        double flowToRelabel = this.getTurnSendingFlowPcuH(fromSegment, oldFromLabel, toSegment, oldToLabel);
        this.removeTurnFlow(fromSegment, oldFromLabel, toSegment, oldToLabel);
        if (flowToRelabel > 0.0) {
            this.addTurnSendingFlow(fromSegment, newFromLabel, toSegment, newToLabel, flowToRelabel);
        }
        return flowToRelabel;
    }

    LabelledBushTurnData() {
        this.compositionTurnSendingFlows = new MultiKeyMap();
        this.linkSegmentCompositionLabels = new HashMap();
    }

    public LabelledBushTurnData(LabelledBushTurnData other, boolean deepCopy) {
        this.compositionTurnSendingFlows = other.compositionTurnSendingFlows.clone();
        this.linkSegmentCompositionLabels = new HashMap();
        for (Map.Entry<EdgeSegment, TreeSet<BushFlowLabel>> entry : other.linkSegmentCompositionLabels.entrySet()) {
            TreeSet<BushFlowLabel> toFill = new TreeSet<BushFlowLabel>();
            this.linkSegmentCompositionLabels.put(entry.getKey(), toFill);
            for (BushFlowLabel otherValue : entry.getValue()) {
                toFill.add(deepCopy ? new BushFlowLabel(otherValue) : otherValue);
            }
        }
    }

    public boolean setTurnSendingFlow(EdgeSegment fromSegment, BushFlowLabel fromComposition, EdgeSegment toSegment, BushFlowLabel toComposition, double turnSendingFlow, boolean allowTurnRemoval) {
        if (Double.isNaN(turnSendingFlow)) {
            LOGGER.severe("Turn (%s to %s) sending flow is NAN, shouldn't happen - consider identifying issue as turn flow cannot be updated properly, reset to 0.0 flow");
            turnSendingFlow = 0.0;
        } else if (!Precision.positive((double)turnSendingFlow)) {
            if (allowTurnRemoval) {
                this.removeTurnFlow(fromSegment, fromComposition, toSegment, toComposition);
                return false;
            }
            if (turnSendingFlow < 0.0) {
                LOGGER.warning(String.format("** Turn (%s to %s) sending flow negative (%.9f), this is not allowed, reset to 0.0 for label (%s,%s)", fromSegment.getXmlId(), toSegment.getXmlId(), turnSendingFlow, fromComposition.getLabelId(), toComposition.getLabelId()));
                turnSendingFlow = 0.0;
                return false;
            }
        }
        this.registerLabelledTurnSendingFlow(fromSegment, fromComposition, toSegment, toComposition, turnSendingFlow);
        return true;
    }

    public double addTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel, double flowPcuH) {
        return this.addTurnSendingFlow(from, fromLabel, to, toLabel, flowPcuH, false);
    }

    public double addTurnSendingFlow(EdgeSegment from, BushFlowLabel fromLabel, EdgeSegment to, BushFlowLabel toLabel, double flowPcuH, boolean allowTurnRemoval) {
        Double newSendingFlow = flowPcuH + this.getTurnSendingFlowPcuH(from, fromLabel, to, toLabel);
        boolean hasRemainingFlow = this.setTurnSendingFlow(from, fromLabel, to, toLabel, newSendingFlow, allowTurnRemoval);
        newSendingFlow = hasRemainingFlow ? newSendingFlow : 0.0;
        return newSendingFlow;
    }

    public void removeTurn(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        TreeSet<BushFlowLabel> fromLabels = this.linkSegmentCompositionLabels.get(fromEdgeSegment);
        TreeSet<BushFlowLabel> toLabels = this.linkSegmentCompositionLabels.get(toEdgeSegment);
        if (fromLabels != null && toLabels != null) {
            fromLabels.forEach(fromComposition -> toLabels.forEach(toComposition -> this.compositionTurnSendingFlows.removeMultiKey((Object)fromEdgeSegment, fromComposition, (Object)toEdgeSegment, toComposition)));
        }
        this.pruneCompositionLabels(fromEdgeSegment.getDownstreamVertex());
    }

    public void removeTurnFlow(EdgeSegment fromEdgeSegment, BushFlowLabel fromLabel, EdgeSegment toEdgeSegment, BushFlowLabel toLabel) {
        if (fromLabel == null || toLabel == null || fromEdgeSegment == null || toEdgeSegment == null) {
            LOGGER.severe("One or more inputs required to remove turn flow from bush data registration is null, unable to remove turn flow");
            return;
        }
        this.compositionTurnSendingFlows.removeMultiKey((Object)fromEdgeSegment, (Object)fromLabel, (Object)toEdgeSegment, (Object)toLabel);
        this.pruneCompositionLabels(fromEdgeSegment.getDownstreamVertex());
    }

    public double getTurnSendingFlowPcuH(EdgeSegment fromSegment, BushFlowLabel fromComposition, EdgeSegment toSegment, BushFlowLabel toComposition) {
        Double existingSendingFlow = (Double)this.compositionTurnSendingFlows.get((Object)fromSegment, (Object)fromComposition, (Object)toSegment, (Object)toComposition);
        if (existingSendingFlow != null) {
            return existingSendingFlow;
        }
        return 0.0;
    }

    public double getTurnSendingFlowPcuH(EdgeSegment fromSegment, EdgeSegment toSegment) {
        double totalTurnSendingFlow = 0.0;
        TreeSet<BushFlowLabel> fromLabels = this.linkSegmentCompositionLabels.get(fromSegment);
        if (fromLabels == null) {
            return totalTurnSendingFlow;
        }
        TreeSet<BushFlowLabel> toLabels = this.linkSegmentCompositionLabels.get(toSegment);
        if (toLabels == null) {
            return totalTurnSendingFlow;
        }
        for (BushFlowLabel fromComposition : fromLabels) {
            for (BushFlowLabel toComposition : toLabels) {
                double s_ab = this.getTurnSendingFlowPcuH(fromSegment, fromComposition, toSegment, toComposition);
                totalTurnSendingFlow += s_ab;
            }
        }
        return totalTurnSendingFlow;
    }

    public double getTotalSendingFlowFromPcuH(EdgeSegment edgeSegment) {
        double totalSendingFlow = 0.0;
        TreeSet<BushFlowLabel> fromLabels = this.linkSegmentCompositionLabels.get(edgeSegment);
        if (fromLabels == null) {
            return totalSendingFlow;
        }
        for (BushFlowLabel fromComposition : fromLabels) {
            for (EdgeSegment exitSegment : edgeSegment.getDownstreamVertex().getExitEdgeSegments()) {
                TreeSet<BushFlowLabel> toLabels = this.linkSegmentCompositionLabels.get(exitSegment);
                if (toLabels == null) continue;
                for (BushFlowLabel toComposition : toLabels) {
                    double s_ab = this.getTurnSendingFlowPcuH(edgeSegment, fromComposition, exitSegment, toComposition);
                    totalSendingFlow += s_ab;
                }
            }
        }
        return totalSendingFlow;
    }

    public double getTotalSendingFlowFromPcuH(EdgeSegment edgeSegment, BushFlowLabel compositionLabel) {
        if (!this.hasFlowCompositionLabel(edgeSegment, compositionLabel)) {
            return 0.0;
        }
        double totalSendingFlow = 0.0;
        for (EdgeSegment exitSegment : edgeSegment.getDownstreamVertex().getExitEdgeSegments()) {
            TreeSet<BushFlowLabel> toLabels = this.linkSegmentCompositionLabels.get(exitSegment);
            if (toLabels == null) continue;
            for (BushFlowLabel toComposition : toLabels) {
                double s_ab = this.getTurnSendingFlowPcuH(edgeSegment, compositionLabel, exitSegment, toComposition);
                totalSendingFlow += s_ab;
            }
        }
        return totalSendingFlow;
    }

    public double getTotalAcceptedFlowToPcuH(EdgeSegment edgeSegment, BushFlowLabel compositionLabel, double[] flowAcceptanceFactors) {
        if (!this.hasFlowCompositionLabel(edgeSegment, compositionLabel)) {
            return 0.0;
        }
        if (edgeSegment.getUpstreamVertex() instanceof CentroidVertex) {
            return this.getTotalSendingFlowFromPcuH(edgeSegment, compositionLabel);
        }
        double totalAcceptedFlow = 0.0;
        for (EdgeSegment entrySegment : edgeSegment.getUpstreamVertex().getEntryEdgeSegments()) {
            TreeSet<BushFlowLabel> fromLabels = this.linkSegmentCompositionLabels.get(entrySegment);
            if (fromLabels == null) continue;
            for (BushFlowLabel fromLabel : fromLabels) {
                double s_ab = this.getTurnSendingFlowPcuH(entrySegment, fromLabel, edgeSegment, compositionLabel);
                double v_ab = s_ab * flowAcceptanceFactors[(int)entrySegment.getId()];
                totalAcceptedFlow += v_ab;
            }
        }
        return totalAcceptedFlow;
    }

    public boolean containsTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment) {
        TreeSet<BushFlowLabel> fromLabels = this.linkSegmentCompositionLabels.get(fromSegment);
        if (fromLabels == null) {
            return false;
        }
        for (BushFlowLabel fromComposition : fromLabels) {
            for (EdgeSegment exitSegment : fromSegment.getDownstreamVertex().getExitEdgeSegments()) {
                TreeSet<BushFlowLabel> toLabels = this.linkSegmentCompositionLabels.get(exitSegment);
                if (toLabels == null) continue;
                for (BushFlowLabel toComposition : toLabels) {
                    if (!this.containsTurnSendingFlow(fromSegment, fromComposition, exitSegment, toComposition)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsTurnSendingFlow(EdgeSegment fromSegment, BushFlowLabel fromComposition, EdgeSegment toSegment, BushFlowLabel toComposition) {
        return this.getTurnSendingFlowPcuH(fromSegment, fromComposition, toSegment, toComposition) > 0.0;
    }

    public double[] getSplittingRates(EdgeSegment fromSegment) {
        Iterable exitEdgeSegments = fromSegment.getDownstreamVertex().getExitEdgeSegments();
        double[] splittingRates = new double[fromSegment.getDownstreamVertex().getNumberOfEdges()];
        double totalSendingFlow = 0.0;
        int index = 0;
        for (EdgeSegment exitSegment : exitEdgeSegments) {
            double s_ab = this.getTurnSendingFlowPcuH(fromSegment, exitSegment);
            splittingRates[index++] = s_ab;
            totalSendingFlow += s_ab;
        }
        ArrayUtils.divideBy((double[])splittingRates, (double)totalSendingFlow, (double)0.0);
        Arrays.copyOf(splittingRates, index);
        return splittingRates;
    }

    public double[] getSplittingRates(EdgeSegment fromSegment, BushFlowLabel fromLabel, BushFlowLabel toLabel) {
        Iterable exitEdgeSegments = fromSegment.getDownstreamVertex().getExitEdgeSegments();
        double[] splittingRates = new double[fromSegment.getDownstreamVertex().getNumberOfEdges()];
        double totalSendingFlow = 0.0;
        int index = 0;
        for (EdgeSegment exitSegment : exitEdgeSegments) {
            double s_ab = this.getTurnSendingFlowPcuH(fromSegment, fromLabel, exitSegment, toLabel);
            splittingRates[index++] = s_ab;
            totalSendingFlow += s_ab;
        }
        ArrayUtils.divideBy((double[])splittingRates, (double)totalSendingFlow, (double)0.0);
        Arrays.copyOf(splittingRates, index);
        return splittingRates;
    }

    public MultiKeyMap<Object, Double> getSplittingRates(EdgeSegment fromSegment, BushFlowLabel fromLabel) {
        Iterable exitEdgeSegments = fromSegment.getDownstreamVertex().getExitEdgeSegments();
        MultiKeyMap splittingRatesByExitSegmentLabel = new MultiKeyMap();
        double totalSendingFlow = this.getTotalSendingFlowFromPcuH(fromSegment, fromLabel);
        if (totalSendingFlow <= 0.0) {
            return splittingRatesByExitSegmentLabel;
        }
        for (EdgeSegment exitSegment : exitEdgeSegments) {
            TreeSet<BushFlowLabel> toLabels = this.getFlowCompositionLabels(exitSegment);
            if (toLabels == null) continue;
            for (BushFlowLabel toLabel : toLabels) {
                double s_ab = this.getTurnSendingFlowPcuH(fromSegment, fromLabel, exitSegment, toLabel);
                if (!(s_ab > 0.0)) continue;
                splittingRatesByExitSegmentLabel.put((Object)exitSegment, (Object)toLabel, (Object)(s_ab / totalSendingFlow));
            }
        }
        return splittingRatesByExitSegmentLabel;
    }

    public double getSplittingRate(EdgeSegment fromSegment, EdgeSegment toSegment) {
        double turnSendingFlow = this.getTurnSendingFlowPcuH(fromSegment, toSegment);
        if (turnSendingFlow > 0.0) {
            double totalSendingFlow = this.getTotalSendingFlowFromPcuH(fromSegment);
            if (totalSendingFlow < turnSendingFlow) {
                LOGGER.severe(String.format("Total sending flow (%.10f) smaller than turn (%s,%s) sending flow (%.10f), this shouldn't happen", totalSendingFlow, fromSegment.getXmlId(), toSegment.getXmlId(), turnSendingFlow));
            }
            return turnSendingFlow / totalSendingFlow;
        }
        return 0.0;
    }

    public double getSplittingRate(EdgeSegment fromSegment, EdgeSegment toSegment, BushFlowLabel entryExitLabel) {
        double turnSendingFlow = this.getTurnSendingFlowPcuH(fromSegment, entryExitLabel, toSegment, entryExitLabel);
        if (turnSendingFlow > 0.0) {
            double totalSendingFlow = this.getTotalSendingFlowFromPcuH(fromSegment, entryExitLabel);
            if (totalSendingFlow < turnSendingFlow) {
                LOGGER.severe(String.format("Total sending flow (%.10f) smaller than turn (%s,%s) sending flow (%.10f) for label (%d,%d), this shouldn't happen", totalSendingFlow, fromSegment.getXmlId(), toSegment.getXmlId(), turnSendingFlow, entryExitLabel.getLabelId(), entryExitLabel.getLabelId()));
            }
            return turnSendingFlow / this.getTotalSendingFlowFromPcuH(fromSegment, entryExitLabel);
        }
        return 0.0;
    }

    public TreeSet<BushFlowLabel> getFlowCompositionLabels(EdgeSegment edgeSegment) {
        return this.linkSegmentCompositionLabels.get(edgeSegment);
    }

    public boolean hasFlowCompositionLabel(EdgeSegment edgeSegment) {
        TreeSet<BushFlowLabel> labels = this.getFlowCompositionLabels(edgeSegment);
        return labels != null && !labels.isEmpty();
    }

    public boolean hasFlowCompositionLabel(EdgeSegment edgeSegment, BushFlowLabel compositionLabel) {
        TreeSet<BushFlowLabel> labels = this.getFlowCompositionLabels(edgeSegment);
        if (labels != null) {
            return labels.contains(compositionLabel);
        }
        return false;
    }

    public double relabel(EdgeSegment fromSegment, BushFlowLabel oldFromLabel, EdgeSegment toSegment, BushFlowLabel oldToLabel, BushFlowLabel newFromToLabel) {
        return this.relabel(fromSegment, oldFromLabel, toSegment, oldToLabel, newFromToLabel, newFromToLabel);
    }

    public double relabelFrom(EdgeSegment fromSegment, BushFlowLabel oldFromLabel, EdgeSegment toSegment, BushFlowLabel toLabel, BushFlowLabel newFromLabel) {
        return this.relabel(fromSegment, oldFromLabel, toSegment, toLabel, newFromLabel, toLabel);
    }

    public double relabelTo(EdgeSegment fromSegment, BushFlowLabel fromLabel, EdgeSegment toSegment, BushFlowLabel oldToLabel, BushFlowLabel newToLabel) {
        return this.relabel(fromSegment, fromLabel, toSegment, oldToLabel, fromLabel, newToLabel);
    }

    public LabelledBushTurnData shallowClone() {
        return new LabelledBushTurnData(this, false);
    }

    public LabelledBushTurnData deepClone() {
        return new LabelledBushTurnData(this, true);
    }

    public boolean hasTurnFlows() {
        return this.compositionTurnSendingFlows.isEmpty();
    }
}

