/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestPathAcyclicMinMaxGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;

public class DestinationBush
extends RootedLabelledBush {
    private static final Logger LOGGER = Logger.getLogger(DestinationBush.class.getCanonicalName());
    protected final CentroidVertex destination;

    public DestinationBush(IdGroupingToken idToken, CentroidVertex destination, long maxSubGraphEdgeSegments) {
        super(idToken, (DirectedVertex)destination, true, maxSubGraphEdgeSegments);
        this.destination = destination;
    }

    public DestinationBush(DestinationBush bush, boolean deepCopy) {
        super(bush, deepCopy);
        this.destination = bush.destination;
    }

    @Override
    public MinMaxPathResult computeMinMaxShortestPaths(double[] linkSegmentCosts, int totalTransportNetworkVertices) {
        ShortestPathAcyclicMinMaxGeneralised minMaxBushPaths = new ShortestPathAcyclicMinMaxGeneralised(this.getDag(), this.requireTopologicalSortUpdate, linkSegmentCosts, totalTransportNetworkVertices);
        try {
            return minMaxBushPaths.executeAllToOne((DirectedVertex)this.getRootVertex());
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to complete minmax path three for destination-based bush ending at destination %s", this.getDestination().getXmlId()));
            return null;
        }
    }

    @Override
    public ShortestSearchType getShortestSearchType() {
        return ShortestSearchType.ALL_TO_ONE;
    }

    public Iterator<DirectedVertex> getTopologicalIterator(boolean originDestinationDirection) {
        return this.getDag().getTopologicalIterator(this.requireTopologicalSortUpdate, originDestinationDirection);
    }

    @Override
    public CentroidVertex getRootZoneVertex() {
        return this.getDestination();
    }

    @Override
    public DestinationBush shallowClone() {
        return new DestinationBush(this, false);
    }

    @Override
    public DestinationBush deepClone() {
        return new DestinationBush(this, true);
    }

    @Override
    public String toString() {
        String result = super.toString();
        return "Bush: destination zone: " + this.getDestination().getParent().getParentZone().getXmlId() + "\n" + result;
    }

    public CentroidVertex getDestination() {
        return this.destination;
    }

    @Override
    public void addOriginDemandPcuH(CentroidVertex originCentroidVertex, double demandPcuH) {
        super.addOriginDemandPcuH(originCentroidVertex, demandPcuH);
    }
}

