/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.network.virtual.CentroidVertex;

public class BushTurnData {
    private static final Logger LOGGER = Logger.getLogger(BushTurnData.class.getCanonicalName());
    private final MultiKeyMap<Object, Double> compositionTurnSendingFlows;

    private void registerTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment, double turnSendingFlow) {
        this.compositionTurnSendingFlows.put((Object)fromSegment, (Object)toSegment, (Object)turnSendingFlow);
    }

    BushTurnData() {
        this.compositionTurnSendingFlows = new MultiKeyMap();
    }

    public BushTurnData(BushTurnData bushTurnData) {
        this.compositionTurnSendingFlows = bushTurnData.compositionTurnSendingFlows.clone();
    }

    public boolean setTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment, double turnSendingFlow, boolean allowTurnRemoval) {
        if (Double.isNaN(turnSendingFlow)) {
            LOGGER.severe("Turn (%s to %s) sending flow is NAN, shouldn't happen - consider identifying issue as turn flow cannot be updated properly, reset to 0.0 flow");
            turnSendingFlow = 0.0;
        } else if (!Precision.positive((double)turnSendingFlow)) {
            if (allowTurnRemoval) {
                this.removeTurn(fromSegment, toSegment);
                return false;
            }
            if (turnSendingFlow < 0.0) {
                LOGGER.warning(String.format("** Turn (%s to %s) sending flow negative (%.9f), this is not allowed, reset to 0.0 ", fromSegment.getXmlId(), toSegment.getXmlId(), turnSendingFlow));
                turnSendingFlow = 0.0;
                return false;
            }
        }
        this.registerTurnSendingFlow(fromSegment, toSegment, turnSendingFlow);
        return true;
    }

    public double addTurnSendingFlow(EdgeSegment from, EdgeSegment to, double flowPcuH) {
        return this.addTurnSendingFlow(from, to, flowPcuH, false);
    }

    public double addTurnSendingFlow(EdgeSegment from, EdgeSegment to, double flowPcuH, boolean allowTurnRemoval) {
        Double newSendingFlow = flowPcuH + this.getTurnSendingFlowPcuH(from, to);
        boolean hasRemainingFlow = this.setTurnSendingFlow(from, to, newSendingFlow, allowTurnRemoval);
        newSendingFlow = hasRemainingFlow ? newSendingFlow : 0.0;
        return newSendingFlow;
    }

    public void removeTurn(EdgeSegment fromEdgeSegment, EdgeSegment toEdgeSegment) {
        this.compositionTurnSendingFlows.removeMultiKey((Object)fromEdgeSegment, (Object)toEdgeSegment);
    }

    public double getTurnSendingFlowPcuH(EdgeSegment fromSegment, EdgeSegment toSegment) {
        Double existingSendingFlow = (Double)this.compositionTurnSendingFlows.get((Object)fromSegment, (Object)toSegment);
        if (existingSendingFlow != null) {
            return existingSendingFlow;
        }
        return 0.0;
    }

    public double getTotalSendingFlowFromPcuH(EdgeSegment edgeSegment) {
        double totalSendingFlow = 0.0;
        for (EdgeSegment exitSegment : edgeSegment.getDownstreamVertex().getExitEdgeSegments()) {
            double s_ab = this.getTurnSendingFlowPcuH(edgeSegment, exitSegment);
            totalSendingFlow += s_ab;
        }
        return totalSendingFlow;
    }

    public double getTotalAcceptedFlowToPcuH(EdgeSegment edgeSegment, double[] flowAcceptanceFactors) {
        if (edgeSegment.getUpstreamVertex() instanceof CentroidVertex) {
            return this.getTotalSendingFlowFromPcuH(edgeSegment);
        }
        double totalAcceptedFlow = 0.0;
        for (EdgeSegment entrySegment : edgeSegment.getUpstreamVertex().getEntryEdgeSegments()) {
            double s_ab = this.getTurnSendingFlowPcuH(entrySegment, edgeSegment);
            double v_ab = s_ab * flowAcceptanceFactors[(int)entrySegment.getId()];
            totalAcceptedFlow += v_ab;
        }
        return totalAcceptedFlow;
    }

    public boolean containsTurnSendingFlow(EdgeSegment fromSegment, EdgeSegment toSegment) {
        return this.getTurnSendingFlowPcuH(fromSegment, toSegment) > 0.0;
    }

    public double[] getSplittingRates(EdgeSegment fromSegment) {
        Iterable exitEdgeSegments = fromSegment.getDownstreamVertex().getExitEdgeSegments();
        double[] splittingRates = new double[fromSegment.getDownstreamVertex().getNumberOfEdges()];
        double totalSendingFlow = 0.0;
        int index = 0;
        for (EdgeSegment exitSegment : exitEdgeSegments) {
            double s_ab = this.getTurnSendingFlowPcuH(fromSegment, exitSegment);
            splittingRates[index++] = s_ab;
            totalSendingFlow += s_ab;
        }
        ArrayUtils.divideBy((double[])splittingRates, (double)totalSendingFlow, (double)0.0);
        Arrays.copyOf(splittingRates, index);
        return splittingRates;
    }

    public double getSplittingRate(EdgeSegment fromSegment, EdgeSegment toSegment) {
        double turnSendingFlow = this.getTurnSendingFlowPcuH(fromSegment, toSegment);
        if (turnSendingFlow > 0.0) {
            double totalSendingFlow = this.getTotalSendingFlowFromPcuH(fromSegment);
            if (totalSendingFlow < turnSendingFlow) {
                LOGGER.severe(String.format("Total sending flow (%.10f) smaller than turn (%s,%s) sending flow (%.10f), this shouldn't happen", totalSendingFlow, fromSegment.getXmlId(), toSegment.getXmlId(), turnSendingFlow));
            }
            return turnSendingFlow / totalSendingFlow;
        }
        return 0.0;
    }

    public boolean hasTurnFlows() {
        return this.compositionTurnSendingFlows.isEmpty();
    }
}

