/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.BushFlowLabel;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.assignment.ltm.sltm.PasManager;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.math.Precision;

public class BushInitialiserHelper {
    private static final Logger LOGGER = Logger.getLogger(BushInitialiserHelper.class.getCanonicalName());
    private final RootedLabelledBush bush;
    private final ACyclicSubGraph odDag;
    private final PasManager pasManager;
    private final boolean logNewPass;

    private static void registerUnfinishedPasOnEdgeSegment(EdgeSegment edgeSegmentToAdd, DirectedVertex unfinishedPasDivergeVertex, int alternativeIndex, Map<EdgeSegment, Map<DirectedVertex, Integer>> containerToRegisterOn) {
        Map<DirectedVertex, Integer> unfinishedPassThroughSegment = containerToRegisterOn.get(edgeSegmentToAdd);
        if (unfinishedPassThroughSegment == null) {
            unfinishedPassThroughSegment = new HashMap<DirectedVertex, Integer>();
            containerToRegisterOn.put(edgeSegmentToAdd, unfinishedPassThroughSegment);
        }
        unfinishedPassThroughSegment.put(unfinishedPasDivergeVertex, alternativeIndex);
    }

    private static int extendUnfinishedPasAlternativeWithEdgeSegment(EdgeSegment edgeSegmentToAdd, DirectedVertex unfinishedPasDiverge, int alternativeIndex, Map<DirectedVertex, List<List<EdgeSegment>>> containerToAddTo) {
        List alternatives = containerToAddTo.get(unfinishedPasDiverge);
        if (alternatives == null) {
            alternatives = containerToAddTo.put(unfinishedPasDiverge, new ArrayList());
        }
        ArrayList alternative = null;
        if (alternativeIndex < 0 || alternatives.size() < alternativeIndex) {
            alternative = new ArrayList(5);
            if (alternativeIndex < 0) {
                alternatives.add(alternative);
            } else {
                ((ArrayList)alternatives).ensureCapacity(alternativeIndex + 1);
                alternatives.set(alternativeIndex, alternative);
            }
        } else {
            alternative = (ArrayList)alternatives.get(alternativeIndex);
        }
        alternative.add(edgeSegmentToAdd);
        return alternatives.size() - 1;
    }

    private static void removeFinishedPasAlternativeTracking(List<EdgeSegment> pasAlternative, List<List<EdgeSegment>> allOriginVertexAlternatives, Map<EdgeSegment, Map<DirectedVertex, Integer>> edgeSegmentPasOriginVertexAlternativeIndex, List<EdgeSegment> entrySegmentsWithUnfinishedPas) {
        DirectedVertex originVertex = pasAlternative.get(0).getUpstreamVertex();
        allOriginVertexAlternatives.remove(pasAlternative);
        for (EdgeSegment segment : pasAlternative) {
            Map<DirectedVertex, Integer> edgeSegmentUnfinishedPass = edgeSegmentPasOriginVertexAlternativeIndex.get(segment);
            edgeSegmentUnfinishedPass.remove(originVertex);
            if (!edgeSegmentUnfinishedPass.isEmpty()) continue;
            edgeSegmentPasOriginVertexAlternativeIndex.remove(segment);
        }
        entrySegmentsWithUnfinishedPas.remove(pasAlternative.get(pasAlternative.size() - 1));
    }

    private static void addNewUnfinishedPass(DirectedVertex pasDivergeVertex, ACyclicSubGraph currentDestinationDag, Map<EdgeSegment, Map<DirectedVertex, Integer>> edgeSegmentPasOriginVertexAlternativeIndex, Map<DirectedVertex, List<List<EdgeSegment>>> originVertexAlternatives) {
        ArrayList pasAlternatives = new ArrayList();
        originVertexAlternatives.put(pasDivergeVertex, pasAlternatives);
        for (EdgeSegment exitSegment : pasDivergeVertex.getExitEdgeSegments()) {
            if (!currentDestinationDag.containsEdgeSegment(exitSegment)) continue;
            int pasAlternativeIndex = BushInitialiserHelper.extendUnfinishedPasAlternativeWithEdgeSegment(exitSegment, pasDivergeVertex, -1, originVertexAlternatives);
            BushInitialiserHelper.registerUnfinishedPasOnEdgeSegment(exitSegment, pasDivergeVertex, pasAlternativeIndex, edgeSegmentPasOriginVertexAlternativeIndex);
        }
    }

    private static void extendUnfinishedPass(EdgeSegment exitSegment, List<EdgeSegment> entrySegmentsWithUnfinishedPas, Map<EdgeSegment, Map<DirectedVertex, Integer>> edgeSegmentUnfinishedPasAlternativeIndices, Map<DirectedVertex, List<List<EdgeSegment>>> unfinishedPasAlternatives) {
        for (EdgeSegment entrySegmentWithUnfinishedPas : entrySegmentsWithUnfinishedPas) {
            Map<DirectedVertex, Integer> unfinishedPassForEntrySegment = edgeSegmentUnfinishedPasAlternativeIndices.get(entrySegmentWithUnfinishedPas);
            for (Map.Entry<DirectedVertex, Integer> unfinishedPasEntry : unfinishedPassForEntrySegment.entrySet()) {
                BushInitialiserHelper.extendUnfinishedPasAlternativeWithEdgeSegment(exitSegment, unfinishedPasEntry.getKey(), unfinishedPasEntry.getValue(), unfinishedPasAlternatives);
                BushInitialiserHelper.registerUnfinishedPasOnEdgeSegment(exitSegment, unfinishedPasEntry.getKey(), unfinishedPasEntry.getValue(), edgeSegmentUnfinishedPasAlternativeIndices);
            }
        }
    }

    private void finishInitialBushPassAtMerge(List<EdgeSegment> entrySegmentsWithUnfinishedPas, Map<DirectedVertex, List<List<EdgeSegment>>> originVertexAlternatives, Map<EdgeSegment, Map<DirectedVertex, Integer>> edgeSegmentPasOriginVertexAlternativeIndex) {
        HashMap<DirectedVertex, ArrayList<List<EdgeSegment>>> localPasAlternatives = new HashMap<DirectedVertex, ArrayList<List<EdgeSegment>>>();
        for (EdgeSegment edgeSegment : entrySegmentsWithUnfinishedPas) {
            Map<DirectedVertex, Integer> entrySegmentUnfinishedPass = edgeSegmentPasOriginVertexAlternativeIndex.get(edgeSegment);
            ArrayList<List<EdgeSegment>> currEntryPasAlternatives = null;
            for (Map.Entry<DirectedVertex, Integer> entry : entrySegmentUnfinishedPass.entrySet()) {
                currEntryPasAlternatives = (ArrayList<List<EdgeSegment>>)localPasAlternatives.get(entry.getKey());
                if (currEntryPasAlternatives == null) {
                    currEntryPasAlternatives = new ArrayList<List<EdgeSegment>>();
                    localPasAlternatives.put(entry.getKey(), currEntryPasAlternatives);
                }
                currEntryPasAlternatives.add(originVertexAlternatives.get(entry.getKey()).get(entry.getValue()));
            }
        }
        for (Map.Entry entry : localPasAlternatives.entrySet()) {
            DirectedVertex originVertex = (DirectedVertex)entry.getKey();
            List alternatives = (List)entry.getValue();
            List<List<EdgeSegment>> allOriginVertexAlternatives = originVertexAlternatives.get(originVertex);
            if (alternatives.size() < 2 || alternatives.size() < 2) continue;
            Iterator iter = alternatives.iterator();
            List referenceAlternative = (List)iter.next();
            while (iter.hasNext()) {
                List pasAlternative = (List)iter.next();
                Pas pas = this.pasManager.findExistingPas(referenceAlternative, pasAlternative);
                if (pas == null) {
                    pas = this.pasManager.createAndRegisterNewPas(this.bush, referenceAlternative, pasAlternative);
                    if (this.logNewPass) {
                        LOGGER.info(String.format("Created new PAS: %s", pas.toString()));
                    }
                } else {
                    pas.registerBush(this.bush);
                }
                BushInitialiserHelper.removeFinishedPasAlternativeTracking(pasAlternative, allOriginVertexAlternatives, edgeSegmentPasOriginVertexAlternativeIndex, entrySegmentsWithUnfinishedPas);
            }
            BushInitialiserHelper.removeFinishedPasAlternativeTracking(referenceAlternative, allOriginVertexAlternatives, edgeSegmentPasOriginVertexAlternativeIndex, entrySegmentsWithUnfinishedPas);
            if (!allOriginVertexAlternatives.isEmpty()) continue;
            originVertexAlternatives.remove(originVertex);
        }
    }

    protected BushInitialiserHelper(RootedLabelledBush bush, ACyclicSubGraph odDag, PasManager pasManager, boolean logNewPass) {
        this.bush = bush;
        this.odDag = odDag;
        this.pasManager = pasManager;
        this.logNewPass = logNewPass;
    }

    public static BushInitialiserHelper create(RootedLabelledBush bush, ACyclicSubGraph odDag, PasManager pasManager, boolean logNewPass) {
        return new BushInitialiserHelper(bush, odDag, pasManager, logNewPass);
    }

    public void executeOdBushInitialisation(DirectedVertex originVertex, Double oDDemandPcuH, Iterator<DirectedVertex> vertexIter, BushFlowLabel entryExitLabel) {
        HashMap<EdgeSegment, Double> odDagFlows = new HashMap<EdgeSegment, Double>();
        int numUsedOdExitSegments = this.odDag.getNumberOfEdgeSegments(originVertex, true);
        for (EdgeSegment exitEdgeSegment : originVertex.getExitEdgeSegments()) {
            odDagFlows.put(exitEdgeSegment, oDDemandPcuH / (double)numUsedOdExitSegments);
        }
        HashMap<DirectedVertex, List<List<EdgeSegment>>> originVertexAlternatives = new HashMap<DirectedVertex, List<List<EdgeSegment>>>();
        HashMap<EdgeSegment, Map<DirectedVertex, Integer>> edgeSegmentPasOriginVertexAlternativeIndex = new HashMap<EdgeSegment, Map<DirectedVertex, Integer>>();
        ArrayList<EdgeSegment> entrySegmentsWithUnfinishedPas = new ArrayList<EdgeSegment>(5);
        while (vertexIter.hasNext()) {
            DirectedVertex currVertex = vertexIter.next();
            double vertexOdSendingFlow = 0.0;
            entrySegmentsWithUnfinishedPas.clear();
            for (EdgeSegment entryEdgeSegment : currVertex.getEntryEdgeSegments()) {
                Double entrySegmentSendingFlow;
                if (!this.odDag.containsEdgeSegment(entryEdgeSegment) || (entrySegmentSendingFlow = (Double)odDagFlows.get(entryEdgeSegment)) == null) continue;
                if (Precision.positive((double)entrySegmentSendingFlow) && edgeSegmentPasOriginVertexAlternativeIndex.get(entryEdgeSegment) != null) {
                    entrySegmentsWithUnfinishedPas.add(entryEdgeSegment);
                }
                vertexOdSendingFlow += entrySegmentSendingFlow.doubleValue();
            }
            if (entrySegmentsWithUnfinishedPas.size() > 1) {
                this.finishInitialBushPassAtMerge(entrySegmentsWithUnfinishedPas, originVertexAlternatives, edgeSegmentPasOriginVertexAlternativeIndex);
            }
            numUsedOdExitSegments = this.odDag.getNumberOfEdgeSegments(currVertex, true);
            double proportionalOdExitFlow = vertexOdSendingFlow / (double)numUsedOdExitSegments;
            for (EdgeSegment entrySegment : currVertex.getEntryEdgeSegments()) {
                if (!this.odDag.containsEdgeSegment(entrySegment)) continue;
                int numUsedExits = 0;
                for (EdgeSegment exitSegment : currVertex.getExitEdgeSegments()) {
                    if (!this.odDag.containsEdgeSegment(exitSegment)) continue;
                    this.bush.addTurnSendingFlow(entrySegment, entryExitLabel, exitSegment, entryExitLabel, proportionalOdExitFlow);
                    odDagFlows.put(exitSegment, proportionalOdExitFlow);
                    ++numUsedExits;
                    if (entrySegmentsWithUnfinishedPas.isEmpty()) continue;
                    BushInitialiserHelper.extendUnfinishedPass(exitSegment, entrySegmentsWithUnfinishedPas, edgeSegmentPasOriginVertexAlternativeIndex, originVertexAlternatives);
                    entrySegmentsWithUnfinishedPas.clear();
                }
                if (numUsedExits <= true || originVertexAlternatives.containsKey(currVertex)) continue;
                BushInitialiserHelper.addNewUnfinishedPass(currVertex, this.odDag, edgeSegmentPasOriginVertexAlternativeIndex, originVertexAlternatives);
            }
        }
    }
}

